/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.validator;

import java.util.Collection;
import java.util.Hashtable;
import org.netbeans.modules.xml.wsdl.validator.spi.ValidatorSchemaFactory;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorSchemaFactoryRegistry {
    private static ValidatorSchemaFactoryRegistry registry;
    private Hashtable<String, ValidatorSchemaFactory> schemaFactories;

    private ValidatorSchemaFactoryRegistry() {
        this.initialize();
    }

    public static ValidatorSchemaFactoryRegistry getDefault() {
        if (registry == null) {
            registry = new ValidatorSchemaFactoryRegistry();
        }
        return registry;
    }

    private void initialize() {
        this.schemaFactories = new Hashtable();
        Lookup.Result result = Lookup.getDefault().lookupResult(ValidatorSchemaFactory.class);
        result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ValidatorSchemaFactoryRegistry.this.refreshServices();
            }
        });
        this.refreshServices();
    }

    public ValidatorSchemaFactory getValidatorSchemaFactory(String string) {
        return this.schemaFactories.get(string);
    }

    public Collection<ValidatorSchemaFactory> getAllValidatorSchemaFactories() {
        return this.schemaFactories.values();
    }

    private void refreshServices() {
        this.schemaFactories.clear();
        for (ValidatorSchemaFactory validatorSchemaFactory : Lookup.getDefault().lookupAll(ValidatorSchemaFactory.class)) {
            this.schemaFactories.put(validatorSchemaFactory.getNamespaceURI(), validatorSchemaFactory);
        }
    }
}

