/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.extensions.mime.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.OperationParameter;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.mime.MIMEComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.mime.MIMEContent;
import org.netbeans.modules.xml.wsdl.model.extensions.mime.MIMEMimeXml;
import org.netbeans.modules.xml.wsdl.model.extensions.mime.MIMEMultipartRelated;
import org.netbeans.modules.xml.wsdl.model.extensions.mime.MIMEPart;
import org.netbeans.modules.xml.wsdl.model.extensions.mime.MIMEQName;
import org.netbeans.modules.xml.wsdl.model.extensions.mime.validation.MIMEComponentValidator;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBinding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBody;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeader;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeaderFault;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPQName;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12Binding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12Body;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12Header;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12HeaderFault;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12QName;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSIAPValidator
implements MIMEComponent.Visitor {
    public static final String CONTENT_TYPE_TEXT_XML = "text/xml";
    public static final String NS_URI_SWA_REF = "http://ws-i.org/profiles/basic/1.1/xsd";
    public static final String SCHEMA_TYPE_SWA_REF = "swaRef";
    private final List<Validator.ResultItem> mResults;
    private final MIMEComponentValidator mValidator;
    private WSDLModel mWSDLModel;
    private boolean isSOAPBinding;
    private boolean isSOAP12Binding;

    public WSIAPValidator(MIMEComponentValidator mIMEComponentValidator, WSDLModel wSDLModel) {
        this.mValidator = mIMEComponentValidator;
        this.mResults = new LinkedList<Validator.ResultItem>();
        this.mWSDLModel = wSDLModel;
    }

    public void validate() {
        Definitions definitions = this.mWSDLModel.getDefinitions();
        for (Binding binding : definitions.getBindings()) {
            int n;
            int n2 = binding.getExtensibilityElements(SOAPBinding.class).size();
            if (n2 == 1) {
                this.isSOAP12Binding = false;
                this.isSOAPBinding = true;
                this.visit(binding);
            }
            if ((n = binding.getExtensibilityElements(SOAP12Binding.class).size()) != 1) continue;
            this.isSOAP12Binding = true;
            this.isSOAPBinding = false;
            this.visit(binding);
        }
    }

    public List<Validator.ResultItem> getResultItems() {
        return this.mResults;
    }

    private void visit(Binding binding) {
        Collection<BindingOperation> collection = binding.getBindingOperations();
        for (BindingOperation bindingOperation : collection) {
            BindingInput bindingInput = bindingOperation.getBindingInput();
            BindingOutput bindingOutput = bindingOperation.getBindingOutput();
            this.testAP2901(bindingInput, bindingOutput);
            List list = this.getMimeContentElements(bindingInput == null ? new ArrayList() : bindingInput.getExtensibilityElements());
            List list2 = this.getMimeContentElements(bindingOutput == null ? new ArrayList() : bindingOutput.getExtensibilityElements());
            this.testAP2903_2910_2944(bindingOperation, bindingInput, bindingOutput, list, list2);
            this.testAP2911_2906(bindingInput == null ? new ArrayList() : bindingInput.getExtensibilityElements(MIMEMultipartRelated.class), bindingOutput == null ? new ArrayList() : bindingOutput.getExtensibilityElements(MIMEMultipartRelated.class));
            List<MIMEPart> list3 = this.getAllMimeParts(bindingInput == null ? new ArrayList() : bindingInput.getExtensibilityElements());
            List<MIMEPart> list4 = this.getAllMimeParts(bindingOutput == null ? new ArrayList() : bindingOutput.getExtensibilityElements());
            this.testAP2909(list3, list4);
            this.testAP2930(bindingOperation);
        }
    }

    private void visit(BindingFault bindingFault) {
        if (bindingFault.getExtensibilityElements(MIMEMultipartRelated.class).size() > 0) {
            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingFault, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2930")));
        }
    }

    @Override
    public void visit(MIMEContent mIMEContent) {
        Part part;
        if (mIMEContent.getPartRef() == null || mIMEContent.getPartRef().get() == null) {
            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)mIMEContent, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2903_PART")));
        }
        if (mIMEContent.getPartRef() != null && mIMEContent.getPartRef().get() != null && ((part = (Part)mIMEContent.getPartRef().get()).getType() == null && part.getElement() == null || part.getType() != null && part.getElement() != null)) {
            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)mIMEContent, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2910")));
        }
        if (mIMEContent.getPartRef() != null && mIMEContent.getPartRef().get() != null && (part = (Part)mIMEContent.getPartRef().get()).getElement() != null && !CONTENT_TYPE_TEXT_XML.equals(mIMEContent.getType())) {
            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)mIMEContent, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2944")));
        }
    }

    @Override
    public void visit(MIMEMimeXml mIMEMimeXml) {
    }

    @Override
    public void visit(MIMEMultipartRelated mIMEMultipartRelated) {
        List<MIMEPart> list = mIMEMultipartRelated.getMIMEParts();
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            boolean bl2 = false;
            boolean bl3 = false;
            List<ExtensibilityElement> list2 = list.get(i).getExtensibilityElements();
            for (int j = 0; j < list2.size(); ++j) {
                if (list2.get(j).getQName().equals(SOAPQName.BODY.getQName()) && this.isSOAPBinding || list2.get(j).getQName().equals(SOAP12QName.BODY.getQName()) && this.isSOAP12Binding) {
                    bl2 = true;
                    if (bl) {
                        if (this.isSOAPBinding) {
                            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)mIMEMultipartRelated, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2911")));
                        } else if (this.isSOAP12Binding) {
                            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)mIMEMultipartRelated, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2911_SOAP12")));
                        }
                    } else {
                        bl = true;
                    }
                }
                if ((!list2.get(j).getQName().equals(SOAPQName.HEADER.getQName()) || !this.isSOAPBinding) && (!list2.get(j).getQName().equals(SOAP12QName.HEADER.getQName()) || !this.isSOAP12Binding)) continue;
                bl3 = true;
            }
            if (bl2 || !bl3) continue;
            if (this.isSOAPBinding) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)list.get(i), NbBundle.getMessage(WSIAPValidator.class, (String)"AP2906")));
                continue;
            }
            if (!this.isSOAP12Binding) continue;
            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)list.get(i), NbBundle.getMessage(WSIAPValidator.class, (String)"AP2906_SOAP12")));
        }
        if (!bl) {
            if (this.isSOAPBinding) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)mIMEMultipartRelated, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2911")));
            } else if (this.isSOAP12Binding) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)mIMEMultipartRelated, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2911_SOAP12")));
            }
        }
    }

    @Override
    public void visit(MIMEPart mIMEPart) {
        List<MIMEContent> list = mIMEPart.getExtensibilityElements(MIMEContent.class);
        if (list != null && list.size() > 1) {
            String string = list.get(0).getPart();
            int n = 1;
            if (n < list.size() && !string.equals(list.get(n).getPart())) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)mIMEPart, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2909")));
            }
        }
    }

    private List getMimeContentElements(List list) {
        ArrayList<ExtensibilityElement> arrayList = new ArrayList<ExtensibilityElement>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(i);
                if (extensibilityElement.getQName().equals(MIMEQName.MULTIPART_RELATED.getQName())) {
                    List<MIMEPart> list2 = ((MIMEMultipartRelated)extensibilityElement).getMIMEParts();
                    for (int j = 0; j < list2.size(); ++j) {
                        List list3 = this.getMimeContentElements(list2.get(j).getExtensibilityElements());
                        arrayList.addAll(list3);
                    }
                    continue;
                }
                if (!extensibilityElement.getQName().equals(MIMEQName.CONTENT.getQName())) continue;
                arrayList.add(extensibilityElement);
            }
        }
        return arrayList;
    }

    private List<MIMEPart> getAllMimeParts(List list) {
        ArrayList<MIMEPart> arrayList = new ArrayList<MIMEPart>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(i);
                if (!extensibilityElement.getQName().equals(MIMEQName.MULTIPART_RELATED.getQName())) continue;
                List<MIMEPart> list2 = ((MIMEMultipartRelated)extensibilityElement).getMIMEParts();
                arrayList.addAll(list2);
                for (int j = 0; j < list2.size(); ++j) {
                    List<MIMEPart> list3 = this.getAllMimeParts(list2.get(j).getExtensibilityElements());
                    arrayList.addAll(list3);
                }
            }
        }
        return arrayList;
    }

    private List getMimeMultipartElements(List list) {
        ArrayList<ExtensibilityElement> arrayList = new ArrayList<ExtensibilityElement>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(i);
                if (!extensibilityElement.getQName().equals(MIMEQName.MULTIPART_RELATED.getQName())) continue;
                arrayList.add(extensibilityElement);
                List<MIMEPart> list2 = ((MIMEMultipartRelated)extensibilityElement).getMIMEParts();
                for (int j = 0; j < list2.size(); ++j) {
                    List list3 = this.getMimeMultipartElements(list2.get(j).getExtensibilityElements());
                    arrayList.addAll(list3);
                }
            }
        }
        return arrayList;
    }

    private void testAP2901(BindingInput bindingInput, BindingOutput bindingOutput) {
        int n;
        int n2;
        int n3;
        int n4;
        if (bindingInput != null) {
            n4 = 0;
            if (this.isSOAPBinding) {
                n4 = bindingInput.getExtensibilityElements(SOAPBody.class).size();
            } else if (this.isSOAP12Binding) {
                n4 = bindingInput.getExtensibilityElements(SOAP12Body.class).size();
            }
            n3 = bindingInput.getExtensibilityElements(MIMEContent.class).size();
            n2 = bindingInput.getExtensibilityElements(MIMEMultipartRelated.class).size();
            n = bindingInput.getExtensibilityElements(MIMEMimeXml.class).size();
            if (n4 == 0 && n3 == 0 && n2 == 0 && n == 0) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingInput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2901_INPUT")));
            }
        }
        if (bindingOutput != null) {
            n4 = 0;
            if (this.isSOAPBinding) {
                n4 = bindingOutput.getExtensibilityElements(SOAPBody.class).size();
            } else if (this.isSOAP12Binding) {
                n4 = bindingOutput.getExtensibilityElements(SOAP12Body.class).size();
            }
            n3 = bindingOutput.getExtensibilityElements(MIMEContent.class).size();
            n2 = bindingOutput.getExtensibilityElements(MIMEMultipartRelated.class).size();
            n = bindingOutput.getExtensibilityElements(MIMEMimeXml.class).size();
            if (n4 == 0 && n3 == 0 && n2 == 0 && n == 0) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingOutput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2901_OUTPUT")));
            }
        }
    }

    private void testAP2903_2910_2944(BindingOperation bindingOperation, BindingInput bindingInput, BindingOutput bindingOutput, List list, List list2) {
        MIMEContent mIMEContent;
        int n;
        OperationParameter operationParameter;
        if (!list.isEmpty()) {
            operationParameter = ((Operation)bindingOperation.getOperation().get()).getInput();
            if (operationParameter == null) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingInput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2903_PORTTYPE_NULL")));
            } else if (operationParameter.getMessage() == null) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingInput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2903_MESSAGE_NULL")));
            } else {
                for (n = 0; n < list.size(); ++n) {
                    mIMEContent = (MIMEContent)list.get(n);
                    mIMEContent.accept(this);
                }
            }
        }
        if (!list2.isEmpty()) {
            operationParameter = ((Operation)bindingOperation.getOperation().get()).getOutput();
            if (operationParameter == null) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingOutput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2903_PORTTYPE_NULL")));
            } else if (operationParameter.getMessage() == null) {
                this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingOutput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2903_MESSAGE_NULL")));
            } else {
                for (n = 0; n < list2.size(); ++n) {
                    mIMEContent = (MIMEContent)list2.get(n);
                    mIMEContent.accept(this);
                }
            }
        }
    }

    private void testAP2911_2906(List list, List list2) {
        MIMEMultipartRelated mIMEMultipartRelated;
        int n;
        if (list != null) {
            for (n = 0; n < list.size(); ++n) {
                mIMEMultipartRelated = (MIMEMultipartRelated)list.get(n);
                mIMEMultipartRelated.accept(this);
            }
        }
        if (list2 != null) {
            for (n = 0; n < list2.size(); ++n) {
                mIMEMultipartRelated = (MIMEMultipartRelated)list2.get(n);
                mIMEMultipartRelated.accept(this);
            }
        }
    }

    private void testAP2930(BindingOperation bindingOperation) {
        Collection<BindingFault> collection = bindingOperation.getBindingFaults();
        if (!collection.isEmpty()) {
            for (BindingFault bindingFault : collection) {
                this.visit(bindingFault);
            }
        }
    }

    private void testAP2909(List<MIMEPart> list, List<MIMEPart> list2) {
        for (MIMEPart mIMEPart : list) {
            mIMEPart.accept(this);
        }
        for (MIMEPart mIMEPart : list2) {
            mIMEPart.accept(this);
        }
    }

    private void testAP2940(Input input, Output output) {
        List<String> list;
        if (input == null || input.getMessage() == null || input.getMessage().get() == null || !(list = this.getSwaRefParts((Message)input.getMessage().get())).isEmpty()) {
            // empty if block
        }
    }

    private List<String> getSwaRefParts(Message message) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Part part : message.getParts()) {
            QName qName;
            boolean bl = true;
            if (part.getType() != null) {
                bl = false;
                qName = part.getType().getQName();
                GlobalType globalType = (GlobalType)part.getType().get();
                this.isSwarefType(globalType);
                if (globalType instanceof GlobalSimpleType) {
                    this.isSwarefType((GlobalSimpleType)globalType);
                    continue;
                }
                if (!(globalType instanceof GlobalComplexType)) continue;
            }
            if (part.getElement() == null) continue;
            qName = part.getElement().getQName();
        }
        return arrayList;
    }

    private boolean isSwarefType(GlobalType globalType) {
        if (globalType instanceof GlobalSimpleType) {
            return this.isSwarefType((GlobalSimpleType)globalType);
        }
        return globalType instanceof GlobalComplexType;
    }

    private boolean isSwarefType(GlobalSimpleType globalSimpleType) {
        return NS_URI_SWA_REF.equals(globalSimpleType.getModel().getSchema().getTargetNamespace()) && SCHEMA_TYPE_SWA_REF.equals(globalSimpleType.getName());
    }

    private Collection<String> getPartNames(Collection<Part> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Part part : collection) {
            arrayList.add(part.getName());
        }
        return arrayList;
    }

    private Collection<String> getFaultNames(Collection<Fault> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Fault fault : collection) {
            arrayList.add(fault.getName());
        }
        return arrayList;
    }

    public void testAP2941(Binding binding, BindingOperation bindingOperation, BindingInput bindingInput, BindingOutput bindingOutput, Input input, Output output) {
        List list;
        if (input != null && input.getMessage() != null && !(list = this.getBindingParts_AP2941(bindingOperation.getBindingInput().getExtensibilityElements(), (Message)input.getMessage().get())).containsAll(this.getPartNames(((Message)input.getMessage().get()).getParts()))) {
            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingInput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2941")));
        }
        if (output != null && output.getMessage() != null && !(list = this.getBindingParts_AP2941(bindingOperation.getBindingOutput().getExtensibilityElements(), (Message)output.getMessage().get())).containsAll(this.getPartNames(((Message)output.getMessage().get()).getParts()))) {
            this.mResults.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingOutput, NbBundle.getMessage(WSIAPValidator.class, (String)"AP2941")));
        }
    }

    private List getBindingParts_AP2941(List list, Message message) {
        ArrayList<String> arrayList;
        block16: {
            block15: {
                arrayList = new ArrayList<String>();
                if (!this.isSOAPBinding) break block15;
                if (list == null) break block16;
                for (int i = 0; i < list.size(); ++i) {
                    Collection<Object> collection;
                    ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(i);
                    if (extensibilityElement instanceof SOAPBody) {
                        collection = ((SOAPBody)extensibilityElement).getParts();
                        if (collection == null) continue;
                        arrayList.addAll(collection);
                        continue;
                    }
                    if (extensibilityElement instanceof SOAPHeader) {
                        collection = null;
                        if (!(extensibilityElement instanceof SOAPHeader)) continue;
                        SOAPHeader sOAPHeader = (SOAPHeader)extensibilityElement;
                        if (message.equals(sOAPHeader.getMessage().get())) {
                            arrayList.add(sOAPHeader.getPart());
                        }
                        collection = sOAPHeader.getSOAPHeaderFaults();
                        for (SOAPHeaderFault sOAPHeaderFault : collection) {
                            if (!message.equals(sOAPHeaderFault.getMessage().get())) continue;
                            arrayList.add(sOAPHeaderFault.getPart());
                        }
                        continue;
                    }
                    if (extensibilityElement instanceof MIMEContent) {
                        arrayList.add(((MIMEContent)extensibilityElement).getPart());
                        continue;
                    }
                    if (!(extensibilityElement instanceof MIMEMultipartRelated)) continue;
                    collection = ((MIMEMultipartRelated)extensibilityElement).getMIMEParts();
                    for (int j = 0; j < collection.size(); ++j) {
                        arrayList.addAll(this.getBindingParts_AP2941(((MIMEPart)collection.get(j)).getExtensibilityElements(), message));
                    }
                }
                break block16;
            }
            if (this.isSOAP12Binding && list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Collection<Object> collection;
                    ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(i);
                    if (extensibilityElement instanceof SOAP12Body) {
                        collection = ((SOAP12Body)extensibilityElement).getParts();
                        if (collection == null) continue;
                        arrayList.addAll(collection);
                        continue;
                    }
                    if (extensibilityElement instanceof SOAP12Header) {
                        collection = null;
                        if (!(extensibilityElement instanceof SOAP12Header)) continue;
                        SOAP12Header sOAP12Header = (SOAP12Header)extensibilityElement;
                        if (message.equals(sOAP12Header.getMessage().get())) {
                            arrayList.add(sOAP12Header.getPart());
                        }
                        collection = sOAP12Header.getSOAPHeaderFaults();
                        for (SOAP12HeaderFault sOAP12HeaderFault : collection) {
                            if (!message.equals(sOAP12HeaderFault.getMessage().get())) continue;
                            arrayList.add(sOAP12HeaderFault.getPart());
                        }
                        continue;
                    }
                    if (extensibilityElement instanceof MIMEContent) {
                        arrayList.add(((MIMEContent)extensibilityElement).getPart());
                        continue;
                    }
                    if (!(extensibilityElement instanceof MIMEMultipartRelated)) continue;
                    collection = ((MIMEMultipartRelated)extensibilityElement).getMIMEParts();
                    for (int j = 0; j < collection.size(); ++j) {
                        arrayList.addAll(this.getBindingParts_AP2941(((MIMEPart)collection.get(j)).getExtensibilityElements(), message));
                    }
                }
            }
        }
        return arrayList;
    }
}

