/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.sun;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.netbeans.modules.j2me.cdc.platform.CDCDevice;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformDetector;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformUtil;
import org.netbeans.modules.j2me.cdc.platform.system.ExternalProcessing;
import org.openide.filesystems.FileObject;
import org.openide.util.io.ReaderInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JmeSdkCdcDetector
extends CDCPlatformDetector {
    private static String PLATFORM_TYPE = "cdc-hi";

    public String getPlatformName() {
        return "CDC Platform";
    }

    public String getPlatformType() {
        return PLATFORM_TYPE;
    }

    public boolean accept(FileObject fileObject) {
        FileObject fileObject2 = CDCPlatformUtil.findTool((String)"bin", (String)"emulator.exe", Collections.singleton(fileObject));
        FileObject fileObject3 = CDCPlatformUtil.findTool((String)"bin", (String)"emulator", Collections.singleton(fileObject));
        FileObject fileObject4 = CDCPlatformUtil.findTool((String)"runtimes/cdc-hi/bin", (String)"cvm.exe", Collections.singleton(fileObject));
        FileObject fileObject5 = CDCPlatformUtil.findTool((String)"runtimes/cdc-hi/bin", (String)"cvm", Collections.singleton(fileObject));
        boolean bl = null != fileObject2 && null != fileObject4 || null != fileObject3 && null != fileObject5;
        return bl;
    }

    public CDCPlatform detectPlatform(FileObject fileObject) throws IOException {
        assert (fileObject != null);
        String string = this.getEmulatorResult(fileObject, "-version");
        String[] stringArray = string.split("\n");
        String string2 = "CDC " + stringArray[0];
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        FileObject fileObject2 = fileObject.getFileObject("docs/api/cdc-1.1");
        if (fileObject2 != null) {
            this.findJavaDoc(fileObject2, arrayList);
        }
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        for (FileObject object2 : arrayList) {
        }
        String string3 = this.getEmulatorResult(fileObject, "-Xquery");
        Properties properties = new Properties();
        StringReader stringReader = new StringReader(string3);
        ReaderInputStream readerInputStream = new ReaderInputStream((Reader)stringReader);
        properties.load((InputStream)readerInputStream);
        readerInputStream.close();
        String string4 = string2;
        String string5 = PLATFORM_TYPE;
        List<URL> list = Collections.singletonList(fileObject.getURL());
        List list2 = Collections.emptyList();
        CDCDevice[] cDCDeviceArray = this.getJavaMeSdkDevices(properties);
        CDCPlatform cDCPlatform = new CDCPlatform(string4, "Java_ME_SDK_CDC", string5, "1.3", list, list2, arrayList2, cDCDeviceArray, true);
        return cDCPlatform;
    }

    private void addDevice(Properties properties, String string, List<CDCDevice> list) {
        CDCDevice.Screen[] screenArray;
        String string2 = properties.getProperty(string + ".version.configuration");
        if (!string2.startsWith("CDC")) {
            return;
        }
        String string3 = properties.getProperty(string + ".version.profile");
        String[] stringArray = string3.split(",");
        CDCDevice.CDCProfile[] cDCProfileArray = new CDCDevice.CDCProfile[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            screenArray = stringArray[i];
            cDCProfileArray[i] = this.parseProfile(properties, string, (String)screenArray);
        }
        String string4 = properties.getProperty(string + ".descriptor");
        screenArray = this.addScreens(properties, string);
        CDCDevice cDCDevice = new CDCDevice(string, string4, cDCProfileArray, screenArray);
        list.add(cDCDevice);
    }

    private CDCDevice.Screen[] addScreens(Properties properties, String string) {
        CDCDevice.Screen screen;
        CDCDevice.Screen[] screenArray = new CDCDevice.Screen[1];
        String string2 = properties.getProperty(string + "screen.width");
        String string3 = properties.getProperty(string + "screen.height");
        String string4 = properties.getProperty(string + "screen.bitDepth");
        String string5 = properties.getProperty(string + "screen.isColor");
        String string6 = properties.getProperty(string + "screen.isTouch");
        String string7 = properties.getProperty(string + "screen.isMain", "true");
        screenArray[0] = screen = new CDCDevice.Screen(string2, string3, string4, string5, string6, string7);
        return screenArray;
    }

    private String descriptionOfAProfile(String string) {
        if (string.startsWith("PBP-")) {
            return string.replace("PBP-", "Personal basis profile ");
        }
        if (string.startsWith("PP-")) {
            return string.replace("PP-", "Personal profile ");
        }
        return string;
    }

    private void findJavaDoc(FileObject fileObject, List<FileObject> list) {
        FileObject[] fileObjectArray;
        if (fileObject == null) {
            return;
        }
        for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
            if (!fileObject2.isData() || !"index".equals(fileObject2.getName())) continue;
            list.add(fileObject2.getParent());
        }
        for (FileObject fileObject2 : fileObjectArray) {
            if (!fileObject2.isFolder() || list.contains(fileObject2.getParent())) continue;
            this.findJavaDoc(fileObject2, list);
        }
    }

    private CDCDevice[] getJavaMeSdkDevices(Properties properties) {
        String string = properties.getProperty("device.list");
        String[] stringArray = string.split(",");
        ArrayList<CDCDevice> arrayList = new ArrayList<CDCDevice>(stringArray.length);
        for (String string2 : stringArray) {
            this.addDevice(properties, string2, arrayList);
        }
        return arrayList.toArray(new CDCDevice[arrayList.size()]);
    }

    private String getEmulatorResult(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject("bin");
        FileObject fileObject3 = fileObject2.getFileObject("emulator.exe");
        if (null == fileObject3) {
            fileObject3 = fileObject2.getFileObject("emulator");
        }
        return ExternalProcessing.callExternal(fileObject3, fileObject, string);
    }

    private CDCDevice.CDCProfile parseProfile(Properties properties, String string, String string2) {
        String string3;
        String string4 = string2.split("-")[1];
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(CDCPlatform.PROP_EXEC_MAIN, "");
        String string5 = string3 = properties.getProperty(string + ".bootclasspath").replace(',', File.pathSeparatorChar);
        boolean bl = true;
        String string6 = this.descriptionOfAProfile(string2);
        return new CDCDevice.CDCProfile(string2, string6, string4, hashMap, string3, string5, bl);
    }
}

