/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.refactoring.spi.impl.CopyAction;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ActionsImplementationFactory {
    private static final Logger LOG = Logger.getLogger(ActionsImplementationFactory.class.getName());
    private static final Lookup.Result<ActionsImplementationProvider> implementations = Lookup.getDefault().lookupResult(ActionsImplementationProvider.class);

    private ActionsImplementationFactory() {
    }

    public static boolean canRename(Lookup lookup) {
        for (ActionsImplementationProvider actionsImplementationProvider : implementations.allInstances()) {
            if (!actionsImplementationProvider.canRename(lookup)) continue;
            return true;
        }
        return false;
    }

    public static void doRename(Lookup lookup) {
        for (ActionsImplementationProvider actionsImplementationProvider : implementations.allInstances()) {
            boolean bl = actionsImplementationProvider.canRename(lookup);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("canRename: %s, %s", actionsImplementationProvider, bl));
            }
            if (!bl) continue;
            actionsImplementationProvider.doRename(lookup);
            return;
        }
        ActionsImplementationFactory.notifyOutOfContext("LBL_RenameRefactoring");
    }

    public static boolean canFindUsages(Lookup lookup) {
        for (ActionsImplementationProvider actionsImplementationProvider : implementations.allInstances()) {
            if (!actionsImplementationProvider.canFindUsages(lookup)) continue;
            return true;
        }
        return false;
    }

    public static void doFindUsages(Lookup lookup) {
        for (ActionsImplementationProvider actionsImplementationProvider : implementations.allInstances()) {
            boolean bl = actionsImplementationProvider.canFindUsages(lookup);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("canFindUsages: %s, %s", actionsImplementationProvider, bl));
            }
            if (!bl) continue;
            actionsImplementationProvider.doFindUsages(lookup);
            return;
        }
        ActionsImplementationFactory.notifyOutOfContext("LBL_FindUsagesRefactoring");
    }

    public static boolean canDelete(Lookup lookup) {
        for (ActionsImplementationProvider actionsImplementationProvider : implementations.allInstances()) {
            if (!actionsImplementationProvider.canDelete(lookup)) continue;
            return true;
        }
        return false;
    }

    public static void doDelete(Lookup lookup) {
        for (ActionsImplementationProvider actionsImplementationProvider : implementations.allInstances()) {
            boolean bl = actionsImplementationProvider.canDelete(lookup);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("canDelete: %s, %s", actionsImplementationProvider, bl));
            }
            if (!bl) continue;
            actionsImplementationProvider.doDelete(lookup);
            return;
        }
        ActionsImplementationFactory.notifyOutOfContext("LBL_SafeDeleteRefactoring");
    }

    public static void doMove(Lookup lookup) {
        for (ActionsImplementationProvider actionsImplementationProvider : implementations.allInstances()) {
            boolean bl = actionsImplementationProvider.canMove(lookup);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("canMove: %s, %s", actionsImplementationProvider, bl));
            }
            if (!bl) continue;
            actionsImplementationProvider.doMove(lookup);
            return;
        }
        ActionsImplementationFactory.notifyOutOfContext("LBL_MoveRefactoring");
    }

    public static boolean canMove(Lookup lookup) {
        for (ActionsImplementationProvider actionsImplementationProvider : implementations.allInstances()) {
            if (!actionsImplementationProvider.canMove(lookup)) continue;
            return true;
        }
        return false;
    }

    public static void doCopy(Lookup lookup) {
        for (ActionsImplementationProvider actionsImplementationProvider : implementations.allInstances()) {
            boolean bl = actionsImplementationProvider.canCopy(lookup);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("canCopy: %s, %s", actionsImplementationProvider, bl));
            }
            if (!bl) continue;
            actionsImplementationProvider.doCopy(lookup);
            return;
        }
        ActionsImplementationFactory.notifyOutOfContext("LBL_CopyRefactoring");
    }

    public static boolean canCopy(Lookup lookup) {
        for (ActionsImplementationProvider actionsImplementationProvider : implementations.allInstances()) {
            if (!actionsImplementationProvider.canCopy(lookup)) continue;
            return true;
        }
        return false;
    }

    private static void notifyOutOfContext(String string) {
        String string2 = NbBundle.getMessage(CopyAction.class, (String)string);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CopyAction.class, (String)"MSG_CantApplyRefactoring", (Object)string2)));
    }
}

