/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesEncoding;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesRequestProcessor;
import org.netbeans.modules.properties.Util;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.TopComponent;

public class PropertiesEditorSupport
extends CloneableEditorSupport
implements EditCookie,
EditorCookie.Observable,
PrintCookie,
CloseCookie,
Serializable,
SaveAsCapable {
    static final Logger LOG = Logger.getLogger("org.netbeans.modules.properties.PropertiesEditorSupport");
    private FileStatusListener fsStatusListener;
    transient PropertiesFileEntry myEntry;
    static final long serialVersionUID = 1787354011149868490L;
    private static Map<DataObject, Charset> charsets = Collections.synchronizedMap(new HashMap());

    public PropertiesEditorSupport(PropertiesFileEntry propertiesFileEntry) {
        super((CloneableEditorSupport.Env)new Environment(propertiesFileEntry), Lookups.singleton((Object)propertiesFileEntry.getDataObject()));
        this.myEntry = propertiesFileEntry;
    }

    final CloneableEditorSupport.Env desEnv() {
        return (CloneableEditorSupport.Env)this.env;
    }

    protected boolean canClose() {
        if (this.hasOpenedTableComponent()) {
            return true;
        }
        MultiDataObject multiDataObject = this.myEntry.getDataObject();
        if (multiDataObject == null || !multiDataObject.isModified()) {
            return true;
        }
        return super.canClose();
    }

    protected CloneableEditor createCloneableEditor() {
        return new PropertiesEditor(this);
    }

    public final DataObject getDataObject() {
        return this.myEntry.getDataObject();
    }

    private boolean isEnvReadOnly() {
        CloneableEditorSupport.Env env = this.desEnv();
        return env instanceof Environment && !((Environment)env).getFileImpl().canWrite();
    }

    private void attachStatusListener() {
        FileSystem fileSystem;
        if (this.fsStatusListener != null) {
            return;
        }
        try {
            fileSystem = this.myEntry.getFile().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(65536, (Throwable)fileStateInvalidException);
            return;
        }
        this.fsStatusListener = new FsStatusListener();
        fileSystem.addFileStatusListener(FileUtil.weakFileStatusListener((FileStatusListener)this.fsStatusListener, (Object)fileSystem));
    }

    private void updateEditorDisplayNames() {
        assert (EventQueue.isDispatchThread());
        String string = this.messageName();
        String string2 = this.messageHtmlName();
        String string3 = this.messageToolTip();
        Enumeration enumeration = this.allEditors.getComponents();
        while (enumeration.hasMoreElements()) {
            TopComponent topComponent = (TopComponent)enumeration.nextElement();
            topComponent.setDisplayName(string);
            topComponent.setHtmlDisplayName(string2);
            topComponent.setToolTipText(string3);
        }
    }

    protected void initializeCloneableEditor(CloneableEditor cloneableEditor) {
        ((PropertiesEditor)cloneableEditor).initialize(this.myEntry);
    }

    protected StyledDocument createStyledDocument(EditorKit editorKit) {
        StyledDocument styledDocument = super.createStyledDocument(editorKit);
        styledDocument.putProperty("title", this.myEntry.getFile().toString());
        styledDocument.putProperty("stream", this.myEntry.getDataObject());
        styledDocument.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            private void changed() {
                PropertiesEditorSupport.this.myEntry.getHandler().autoParse();
            }
        });
        return styledDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        PropertiesEncoding.PropCharset propCharset = new PropertiesEncoding.PropCharset(this.myEntry.getFile());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, propCharset));
        try {
            editorKit.read(bufferedReader, (Document)styledDocument, 0);
        }
        finally {
            ((Reader)bufferedReader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        PropertiesEncoding.PropCharsetEncoder propCharsetEncoder = new PropertiesEncoding.PropCharsetEncoder();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, propCharsetEncoder));
        try {
            editorKit.write(bufferedWriter, (Document)styledDocument, 0, styledDocument.getLength());
        }
        finally {
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
        }
    }

    protected boolean notifyModified() {
        this.myEntry.getHandler().autoParse();
        if (super.notifyModified()) {
            if (this.hasOpenedEditorComponent() || this.hasOpenedTableComponent()) {
                ((Environment)this.env).addSaveCookie();
                return true;
            }
            try {
                ((Environment)this.env).save();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return false;
        }
        return false;
    }

    protected Task reloadDocument() {
        Task task = super.reloadDocument();
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                PropertiesEditorSupport.this.myEntry.getHandler().autoParse();
            }
        });
        return task;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        ((Environment)this.env).removeSaveCookie();
    }

    public void open() {
        super.open();
        this.attachStatusListener();
    }

    protected void notifyClosed() {
        if (!this.hasOpenedTableComponent()) {
            boolean bl = this.isModified();
            super.notifyClosed();
            if (bl && this.myEntry.getFile().isValid() && !this.myEntry.getFile().isVirtual()) {
                this.myEntry.getHandler().reparseNowBlocking();
            }
        }
    }

    protected String messageOpening() {
        return NbBundle.getMessage(PropertiesEditorSupport.class, (String)"LBL_ObjectOpen", (Object)this.getFileLabel());
    }

    protected String messageOpened() {
        return NbBundle.getMessage(PropertiesEditorSupport.class, (String)"LBL_ObjectOpened", (Object)this.getFileLabel());
    }

    private String getFileLabel() {
        PropertiesDataObject propertiesDataObject = (PropertiesDataObject)this.myEntry.getDataObject();
        return propertiesDataObject.isMultiLocale() ? propertiesDataObject.getPrimaryFile().getName() + "(" + Util.getLocaleLabel((MultiDataObject.Entry)this.myEntry) + ")" : propertiesDataObject.getPrimaryFile().getNameExt();
    }

    protected String messageName() {
        if (!this.myEntry.getDataObject().isValid()) {
            return "";
        }
        return DataEditorSupport.annotateName((String)this.getFileLabel(), (boolean)false, (boolean)this.isModified(), (!this.myEntry.getFile().canWrite() ? 1 : 0) != 0);
    }

    protected String messageHtmlName() {
        Object object;
        if (!this.myEntry.getDataObject().isValid()) {
            return null;
        }
        String string = this.getFileLabel();
        String string2 = null;
        FileObject fileObject = this.myEntry.getFile();
        try {
            object = fileObject.getFileSystem().getStatus();
            if (object != null) {
                Set<FileObject> set = Collections.singleton(fileObject);
                if (object instanceof FileSystem.HtmlStatus) {
                    FileSystem.HtmlStatus htmlStatus = (FileSystem.HtmlStatus)object;
                    string2 = htmlStatus.annotateNameHtml(string, set);
                    if (string.equals(string2)) {
                        string2 = null;
                    }
                    if (string2 != null && !string2.startsWith("<html>")) {
                        string2 = "<html>" + string2;
                    }
                }
                if (string2 == null) {
                    string2 = object.annotateName(string, set);
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        object = string2 != null ? string2 : string;
        return DataEditorSupport.annotateName((String)object, (boolean)true, (boolean)this.isModified(), (!this.myEntry.getFile().canWrite() ? 1 : 0) != 0);
    }

    protected String messageSave() {
        return NbBundle.getMessage(PropertiesEditorSupport.class, (String)"MSG_SaveFile", (Object)this.getFileLabel());
    }

    protected String messageToolTip() {
        FileObject fileObject = this.myEntry.getFile();
        return DataEditorSupport.toolTip((FileObject)fileObject, (boolean)this.isModified(), (!this.myEntry.getFile().canWrite() ? 1 : 0) != 0);
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new UndoRedoStampFlagManager();
    }

    UndoRedo.Manager getUndoRedoManager() {
        return super.getUndoRedo();
    }

    void forceNotifyClosed() {
        super.notifyClosed();
    }

    private void saveThisEntry() throws IOException {
        SaveImpl saveImpl = new SaveImpl(this);
        FileUtil.runAtomicAction((FileSystem.AtomicAction)saveImpl);
        if (!this.env.isModified()) {
            this.myEntry.setModified(false);
        }
    }

    final void superSaveDoc() throws IOException {
        super.saveDocument();
    }

    public void saveAs(FileObject fileObject, String string) throws IOException {
        DataFolder dataFolder;
        String string2 = FileUtil.getExtension((String)string);
        DataObject dataObject = null;
        MultiDataObject multiDataObject = this.myEntry.getDataObject();
        if (!multiDataObject.isModified() || null == this.getDocument()) {
            dataFolder = DataFolder.findFolder((FileObject)fileObject);
            FileObject fileObject2 = fileObject.getFileObject(string);
            if (null != fileObject2) {
                fileObject2.delete();
            }
            if (null != (fileObject2 = this.myEntry.copyRename(dataFolder.getPrimaryFile(), this.getFileNameNoExtension(string), string2))) {
                dataObject = DataObject.find((FileObject)fileObject2);
            }
        } else {
            dataFolder = FileUtil.createData((FileObject)fileObject, (String)string);
            this.saveDocumentAs(dataFolder.getOutputStream());
            multiDataObject.setModified(false);
            dataObject = DataObject.find((FileObject)dataFolder);
        }
        if (null != dataObject && null != (dataFolder = (OpenCookie)dataObject.getCookie(OpenCookie.class))) {
            this.close(false);
            dataFolder.open();
        }
    }

    private String getFileNameNoExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private void saveDocumentAs(final OutputStream outputStream) throws IOException {
        final StyledDocument styledDocument = this.getDocument();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SaveAsWriter
        implements Runnable {
            private IOException ex;

            SaveAsWriter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BufferedOutputStream bufferedOutputStream = null;
                    try {
                        bufferedOutputStream = new BufferedOutputStream(outputStream);
                        EditorKit editorKit = PropertiesEditorSupport.this.createEditorKit();
                        PropertiesEditorSupport.this.saveFromKitToStream(styledDocument, editorKit, bufferedOutputStream);
                        ((OutputStream)bufferedOutputStream).close();
                        bufferedOutputStream = null;
                    }
                    catch (BadLocationException badLocationException) {
                        LOG.log(Level.INFO, null, badLocationException);
                    }
                    finally {
                        if (bufferedOutputStream != null) {
                            ((OutputStream)bufferedOutputStream).close();
                        }
                    }
                }
                catch (IOException iOException) {
                    this.ex = iOException;
                }
            }

            public void after() throws IOException {
                if (this.ex != null) {
                    throw this.ex;
                }
            }
        }
        SaveAsWriter saveAsWriter = new SaveAsWriter();
        styledDocument.render(saveAsWriter);
        saveAsWriter.after();
    }

    public synchronized boolean hasOpenedTableComponent() {
        PropertiesDataObject propertiesDataObject = (PropertiesDataObject)this.myEntry.getDataObject();
        if (propertiesDataObject.getBundleStructureOrNull() == null || propertiesDataObject.getBundleStructure().getEntryCount() == 0) {
            return false;
        }
        return propertiesDataObject.getOpenSupport().hasOpenedTableComponent();
    }

    public synchronized boolean hasOpenedEditorComponent() {
        Enumeration enumeration = this.allEditors.getComponents();
        return enumeration.hasMoreElements();
    }

    private static class SaveImpl
    implements FileSystem.AtomicAction {
        private static final SaveImpl DEFAULT = new SaveImpl(null);
        private final PropertiesEditorSupport des;

        public SaveImpl(PropertiesEditorSupport propertiesEditorSupport) {
            this.des = propertiesEditorSupport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            if (this.des.desEnv().isModified() && this.des.isEnvReadOnly()) {
                IOException iOException = new IOException("File is read-only: " + ((Environment)this.des.env).getFileImpl());
                throw iOException;
            }
            DataObject dataObject = this.des.getDataObject();
            Charset charset = FileEncodingQuery.getEncoding((FileObject)dataObject.getPrimaryFile());
            try {
                charsets.put(dataObject, charset);
                this.des.superSaveDoc();
            }
            finally {
                charsets.remove(dataObject);
            }
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object object) {
            return object != null && this.getClass() == object.getClass();
        }
    }

    static class StampFlag {
        private long timeStamp;
        private Object atomicFlag;

        public StampFlag(long l, Object object) {
            this.timeStamp = l;
            this.atomicFlag = object;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long l) {
            this.timeStamp = l;
        }

        public Object getAtomicFlag() {
            return this.atomicFlag;
        }
    }

    class UndoRedoStampFlagManager
    extends UndoRedo.Manager {
        WeakHashMap<UndoableEdit, StampFlag> stampFlags = new WeakHashMap(5);

        UndoRedoStampFlagManager() {
        }

        public synchronized boolean addEdit(UndoableEdit undoableEdit) {
            this.stampFlags.put(undoableEdit, new StampFlag(System.currentTimeMillis(), PropertiesEditorSupport.this.myEntry.atomicUndoRedoFlag));
            return super.addEdit(undoableEdit);
        }

        public boolean replaceEdit(UndoableEdit undoableEdit) {
            this.stampFlags.put(undoableEdit, new StampFlag(System.currentTimeMillis(), PropertiesEditorSupport.this.myEntry.atomicUndoRedoFlag));
            return super.replaceEdit(undoableEdit);
        }

        public synchronized void undo() throws CannotUndoException {
            UndoableEdit undoableEdit = this.editToBeUndone();
            if (undoableEdit != null) {
                Object object = this.stampFlags.get(undoableEdit).getAtomicFlag();
                super.undo();
                this.stampFlags.put(undoableEdit, new StampFlag(System.currentTimeMillis(), object));
            }
        }

        public synchronized void redo() throws CannotRedoException {
            UndoableEdit undoableEdit = this.editToBeRedone();
            if (undoableEdit != null) {
                Object object = this.stampFlags.get(undoableEdit).getAtomicFlag();
                super.redo();
                this.stampFlags.put(undoableEdit, new StampFlag(System.currentTimeMillis(), object));
            }
        }

        public long getTimeStampOfEditToBeUndone() {
            UndoableEdit undoableEdit = this.editToBeUndone();
            if (undoableEdit == null) {
                return 0L;
            }
            return this.stampFlags.get(undoableEdit).getTimeStamp();
        }

        public long getTimeStampOfEditToBeRedone() {
            UndoableEdit undoableEdit = this.editToBeRedone();
            if (undoableEdit == null) {
                return 0L;
            }
            return this.stampFlags.get(undoableEdit).getTimeStamp();
        }

        public Object getAtomicFlagOfEditToBeUndone() {
            UndoableEdit undoableEdit = this.editToBeUndone();
            if (undoableEdit == null) {
                return null;
            }
            return this.stampFlags.get(undoableEdit).getAtomicFlag();
        }

        public Object getAtomicFlagOfEditToBeRedone() {
            UndoableEdit undoableEdit = this.editToBeRedone();
            if (undoableEdit == null) {
                return null;
            }
            return this.stampFlags.get(undoableEdit).getAtomicFlag();
        }
    }

    public static class PropertiesEditor
    extends CloneableEditor {
        protected transient PropertiesFileEntry entry;
        private transient PropertyChangeListener saveCookieLNode;
        static final long serialVersionUID = -2702087884943509637L;

        public PropertiesEditor() {
        }

        public PropertiesEditor(PropertiesEditorSupport propertiesEditorSupport) {
            super((CloneableEditorSupport)propertiesEditorSupport);
        }

        private void initialize(PropertiesFileEntry propertiesFileEntry) {
            this.entry = propertiesFileEntry;
            Node node = propertiesFileEntry.getNodeDelegate();
            this.setActivatedNodes(new Node[]{node});
            this.updateName();
            this.saveCookieLNode = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("cookie".equals(propertyChangeEvent.getPropertyName()) || "name".equals(propertyChangeEvent.getPropertyName())) {
                        PropertiesEditor.super.updateName();
                    }
                }
            };
            this.entry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.saveCookieLNode, (Object)((Object)this.entry)));
        }

        protected boolean closeLast() {
            return super.closeLast();
        }

        public Image getIcon() {
            PropertiesDataObject propertiesDataObject = (PropertiesDataObject)this.entry.getDataObject();
            return ImageUtilities.loadImage((String)(propertiesDataObject.isMultiLocale() ? "org/netbeans/modules/properties/propertiesLocale.gif" : "org/netbeans/modules/properties/propertiesObject.png"));
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("propfiles.editlocale");
        }

        private JEditorPane getPane() {
            return this.pane;
        }
    }

    public class PropertiesEditAt
    implements EditCookie {
        private String key;

        PropertiesEditAt(String string) {
            this.key = string;
        }

        public void setKey(String string) {
            this.key = string;
        }

        public void edit() {
            PropertiesEditor propertiesEditor = (PropertiesEditor)PropertiesEditorSupport.super.openCloneableTopComponent();
            propertiesEditor.requestActive();
            Element.ItemElem itemElem = PropertiesEditorSupport.this.myEntry.getHandler().getStructure().getItem(this.key);
            if (itemElem != null) {
                int n = itemElem.getKeyElem().getBounds().getBegin().getOffset();
                if (propertiesEditor.getPane() != null && propertiesEditor.getPane().getCaret() != null) {
                    propertiesEditor.getPane().getCaret().setDot(n);
                }
            }
        }
    }

    private static final class EnvironmentListener
    extends FileChangeAdapter {
        private Reference<Environment> reference;

        public EnvironmentListener(Environment environment) {
            LOG.finer("new EnvironmentListener(<Environment>)");
            this.reference = new WeakReference<Environment>(environment);
        }

        public void fileDeleted(FileEvent fileEvent) {
            Environment environment = this.reference.get();
            if (environment != null) {
                environment.updateDocumentProperty();
                environment.fileRemoved();
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("EnviromentListener.fileChanged(...)");
                LOG.finer(" - original file: " + FileUtil.getFileDisplayName((FileObject)fileEvent.getFile()));
                LOG.finer(" - current file: " + FileUtil.getFileDisplayName((FileObject)((FileObject)fileEvent.getSource())));
            }
            if (fileEvent.firedFrom((FileSystem.AtomicAction)SaveImpl.DEFAULT)) {
                return;
            }
            Environment environment = this.reference.get();
            if (environment != null) {
                if (!environment.getFileImpl().equals(fileEvent.getFile())) {
                    fileEvent.getFile().removeFileChangeListener((FileChangeListener)this);
                    environment.getFileImpl().addFileChangeListener((FileChangeListener)new EnvironmentListener(environment));
                    return;
                }
                if (fileEvent.getFile().isVirtual()) {
                    environment.entry.getFile().removeFileChangeListener((FileChangeListener)this);
                    environment.fileRemoved();
                    environment.entry.getFile().addFileChangeListener((FileChangeListener)this);
                } else {
                    environment.fileChanged(fileEvent.isExpected(), fileEvent.getTime());
                }
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            Environment environment = this.reference.get();
            if (environment != null) {
                environment.updateDocumentProperty();
                environment.fileRenamed();
            }
        }
    }

    private static class Environment
    implements CloneableEditorSupport.Env,
    PropertyChangeListener,
    SaveCookie {
        static final long serialVersionUID = 354528097109874355L;
        private PropertiesFileEntry entry;
        private transient FileLock fileLock;
        private transient FileObject fileObject;
        private transient PropertyChangeSupport propSupp;
        private transient VetoableChangeSupport vetoSupp;
        private transient EnvironmentListener envListener;

        public Environment(PropertiesFileEntry propertiesFileEntry) {
            LOG.finer("PropertiesEditorSupport(<PropertiesFileEntry>)");
            LOG.finer(" - new Environment(<PropertiesFileEntry>)");
            this.entry = propertiesFileEntry;
            this.envListener = new EnvironmentListener(this);
            propertiesFileEntry.getFile().addFileChangeListener((FileChangeListener)this.envListener);
            propertiesFileEntry.addPropertyChangeListener(this);
        }

        private FileObject getFileImpl() {
            this.changeFile();
            return this.fileObject;
        }

        protected final DataObject getDataObject() {
            return this.entry.getDataObject();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            LOG.finer("Environment.addPropertyChangeListener(...)");
            this.prop().addPropertyChangeListener(propertyChangeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Environment.propertyChange(" + propertyChangeEvent.getPropertyName() + ", " + propertyChangeEvent.getOldValue() + ", " + propertyChangeEvent.getNewValue() + ')');
            }
            if ("valid".equals(propertyChangeEvent.getPropertyName())) {
                if (Boolean.FALSE.equals(propertyChangeEvent.getOldValue())) {
                    return;
                }
                PropertiesEditorSupport propertiesEditorSupport = (PropertiesEditorSupport)this.findCloneableOpenSupport();
                if (propertiesEditorSupport != null) {
                    this.unmarkModified();
                    propertiesEditorSupport.close(false);
                }
            } else {
                this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            LOG.finer("Environment.removePropertyChangeListener(...)");
            this.prop().removePropertyChangeListener(propertyChangeListener);
        }

        public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
            LOG.finer("Environment.addVetoableChangeListener(...)");
            this.veto().addVetoableChangeListener(vetoableChangeListener);
        }

        public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
            LOG.finer("Environment.removeVetoableChangeListener(...)");
            this.veto().removeVetoableChangeListener(vetoableChangeListener);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (PropertiesEditorSupport)this.entry.getCookieSet().getCookie(EditCookie.class);
        }

        public boolean isValid() {
            return this.entry.getDataObject().isValid();
        }

        public boolean isModified() {
            return this.entry.isModified();
        }

        public void markModified() throws IOException {
            LOG.finer("Environment.markModified()");
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.entry.takeLock();
            }
            this.entry.setModified(true);
        }

        public void unmarkModified() {
            LOG.finer("Environment.unmarkModified()");
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.releaseLock();
            }
            this.entry.setModified(false);
        }

        final void updateDocumentProperty() {
            StyledDocument styledDocument;
            EditorCookie editorCookie = (EditorCookie)this.getDataObject().getCookie(EditorCookie.class);
            if (editorCookie != null && (styledDocument = editorCookie.getDocument()) != null) {
                styledDocument.putProperty("title", FileUtil.getFileDisplayName((FileObject)this.getDataObject().getPrimaryFile()));
            }
        }

        public String getMimeType() {
            return this.getFileImpl().getMIMEType();
        }

        public Date getTime() {
            this.getFileImpl().refresh();
            return this.getFileImpl().lastModified();
        }

        protected final void changeFile() {
            boolean bl;
            FileObject fileObject = this.entry.getFile();
            if (fileObject.equals(this.fileObject)) {
                return;
            }
            if (this.fileLock != null) {
                if (this.fileLock.isValid()) {
                    LOG.fine("changeFile releaseLock: " + this.fileLock + " for " + this.fileObject);
                    this.fileLock.releaseLock();
                    bl = true;
                } else {
                    this.fileLock = null;
                    bl = false;
                }
            } else {
                bl = false;
            }
            boolean bl2 = this.fileObject == null;
            this.fileObject = fileObject;
            LOG.fine("changeFile: " + fileObject + " for " + this.fileObject);
            if (this.envListener != null) {
                this.fileObject.removeFileChangeListener((FileChangeListener)this.envListener);
            }
            this.envListener = new EnvironmentListener(this);
            this.fileObject.addFileChangeListener((FileChangeListener)this.envListener);
            if (bl) {
                try {
                    this.fileLock = this.entry.takeLock();
                    LOG.fine("changeFile takeLock: " + this.fileLock + " for " + this.fileObject);
                }
                catch (IOException iOException) {
                    Logger.getLogger(PropertiesEditorSupport.class.getName()).log(Level.WARNING, null, iOException);
                }
            }
            if (!bl2) {
                this.firePropertyChange("expectedTime", null, this.getTime());
            }
        }

        public InputStream inputStream() throws IOException {
            LOG.finer("Environment.inputStream()");
            return this.getFileImpl().getInputStream();
        }

        public OutputStream outputStream() throws IOException {
            LOG.finer("Environment.outputStream()");
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.entry.takeLock();
            }
            LOG.fine("outputStream after takeLock: " + this.fileLock + " for " + this.fileObject);
            try {
                return this.getFileImpl().getOutputStream(this.fileLock);
            }
            catch (IOException iOException) {
                if (this.fileLock == null || !this.fileLock.isValid()) {
                    this.fileLock = this.entry.takeLock();
                }
                LOG.fine("ugly workaround for #40552: " + this.fileLock + " for " + this.fileObject);
                return this.getFileImpl().getOutputStream(this.fileLock);
            }
        }

        public void save() throws IOException {
            LOG.finer("Environment.save()");
            ((PropertiesEditorSupport)this.findCloneableOpenSupport()).saveThisEntry();
        }

        private void firePropertyChange(String string, Object object, Object object2) {
            this.prop().firePropertyChange(string, object, object2);
        }

        private void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
            this.veto().fireVetoableChange(string, object, object2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PropertyChangeSupport prop() {
            Environment environment = this;
            synchronized (environment) {
                if (this.propSupp == null) {
                    this.propSupp = new PropertyChangeSupport(this);
                }
            }
            return this.propSupp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VetoableChangeSupport veto() {
            Environment environment = this;
            synchronized (environment) {
                if (this.vetoSupp == null) {
                    this.vetoSupp = new VetoableChangeSupport(this);
                }
            }
            return this.vetoSupp;
        }

        private void addSaveCookie() {
            LOG.finer("Environment.addSaveCookie(...)");
            if (this.entry.getCookie(SaveCookie.class) == null) {
                this.entry.getCookieSet().add((Node.Cookie)this);
            }
            PropertiesDataObject propertiesDataObject = (PropertiesDataObject)this.getDataObject();
            propertiesDataObject.updateModificationStatus();
            if (propertiesDataObject.getCookie(SaveCookie.class) == null) {
                propertiesDataObject.getCookieSet0().add((Node.Cookie)this);
            }
        }

        private void removeSaveCookie() {
            LOG.finer("Environment.removeSaveCookie(...)");
            SaveCookie saveCookie = this.entry.getCookie(SaveCookie.class);
            if (saveCookie != null && saveCookie.equals(this)) {
                this.entry.getCookieSet().remove((Node.Cookie)this);
            }
            final Environment environment = this;
            PropertiesRequestProcessor.getInstance().post(new Runnable(){

                public void run() {
                    PropertiesDataObject propertiesDataObject = (PropertiesDataObject)Environment.this.getDataObject();
                    propertiesDataObject.updateModificationStatus();
                    propertiesDataObject.getCookieSet0().remove((Node.Cookie)environment);
                }
            });
        }

        private void fileChanged(boolean bl, long l) {
            LOG.finer("Environment.fileChanged(...)");
            if (bl) {
                this.firePropertyChange("time", null, null);
            } else {
                this.firePropertyChange("time", null, new Date(l));
            }
        }

        final void fileRenamed() {
            this.firePropertyChange("expectedTime", null, this.getTime());
        }

        private void fileRemoved() {
            LOG.finer("Environment.fileRemoved() ... ");
            try {
                this.fireVetoableChange("valid", Boolean.TRUE, Boolean.FALSE);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        }
    }

    private static final class Env
    extends Environment {
        static final long serialVersionUID = -9218186467757330339L;
        private PropertiesFileEntry entry;

        public Env(PropertiesFileEntry propertiesFileEntry) {
            super(propertiesFileEntry);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.entry != null) {
                ((Environment)this).entry = this.entry;
            }
        }
    }

    final class FsStatusListener
    implements FileStatusListener,
    Runnable {
        FsStatusListener() {
        }

        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            if (fileStatusEvent.isNameChange() && fileStatusEvent.hasChanged(PropertiesEditorSupport.this.myEntry.getFile())) {
                Mutex.EVENT.writeAccess((Runnable)this);
            }
        }

        public void run() {
            PropertiesEditorSupport.this.updateEditorDisplayNames();
        }
    }
}

