/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.hostinfo.impl;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;

public final class HostInfoFactory {
    private static final String UNKNOWN = "UNKNOWN";

    private HostInfoFactory() {
    }

    protected static HostInfo newHostInfo(Properties properties) {
        HostInfoImpl hostInfoImpl = new HostInfoImpl();
        OSImpl oSImpl = new OSImpl();
        oSImpl.setBitness(HostInfoFactory.getInt(properties, "BITNESS", 32));
        oSImpl.setFamily(properties.getProperty("OSFAMILY", UNKNOWN));
        oSImpl.setName(properties.getProperty("OSNAME", UNKNOWN));
        oSImpl.setVersion(properties.getProperty("OSBUILD", UNKNOWN));
        hostInfoImpl.os = oSImpl;
        hostInfoImpl.hostname = properties.getProperty("HOSTNAME", UNKNOWN);
        try {
            hostInfoImpl.cpuFamily = HostInfo.CpuFamily.valueOf(properties.getProperty("CPUFAMILY", UNKNOWN).toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            hostInfoImpl.cpuFamily = HostInfo.CpuFamily.UNKNOWN;
        }
        hostInfoImpl.shell = properties.getProperty("SH", UNKNOWN);
        hostInfoImpl.tempDir = properties.getProperty("TMPDIRBASE", UNKNOWN);
        hostInfoImpl.cpuNum = HostInfoFactory.getInt(properties, "CPUNUM", 1);
        hostInfoImpl.path = properties.getProperty("PATH", "/bin:/usr/bin");
        if (properties.containsKey("LOCALTIME")) {
            long l = (Long)properties.get("LOCALTIME");
            long l2 = HostInfoFactory.getTime(properties, "DATETIME", l);
            hostInfoImpl.clockSkew = l2 - l;
        }
        return hostInfoImpl;
    }

    private static int getInt(Properties properties, String string, int n) {
        int n2 = n;
        String string2 = properties.getProperty(string, null);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    private static long getTime(Properties properties, String string, long l) {
        long l2 = l;
        String string2 = properties.getProperty(string, null);
        if (string2 != null) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("y-M-d H:m:s");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                Date date = simpleDateFormat.parse(string2);
                l2 = date.getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return l2;
    }

    static String getNBKey() {
        int n = System.getProperty("netbeans.user", "").hashCode();
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            n = 3 * n + 5 * inetAddress.getHostName().hashCode();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return Integer.toHexString(n);
    }

    static final class OSImpl
    implements HostInfo.OS {
        private HostInfo.OSFamily family = HostInfo.OSFamily.UNKNOWN;
        private String name = "UNKNOWN";
        private String version = "UNKNOWN";
        private HostInfo.Bitness bitness = HostInfo.Bitness._32;

        OSImpl() {
        }

        public HostInfo.Bitness getBitness() {
            return this.bitness;
        }

        public String getVersion() {
            return this.version;
        }

        public HostInfo.OSFamily getFamily() {
            return this.family;
        }

        public String getName() {
            return this.name;
        }

        private void setVersion(String string) {
            this.version = string;
        }

        private void setBitness(int n) {
            this.bitness = n == 64 ? HostInfo.Bitness._64 : HostInfo.Bitness._32;
        }

        private void setFamily(String string) {
            try {
                this.family = HostInfo.OSFamily.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private void setName(String string) {
            this.name = string;
        }
    }

    private static class HostInfoImpl
    implements HostInfo {
        private HostInfo.OS os;
        private HostInfo.CpuFamily cpuFamily;
        private String hostname;
        private String shell;
        private String tempDir;
        private int cpuNum;
        private long clockSkew;
        private String path;

        private HostInfoImpl() {
        }

        public HostInfo.OS getOS() {
            return this.os;
        }

        public HostInfo.CpuFamily getCpuFamily() {
            return this.cpuFamily;
        }

        public int getCpuNum() {
            return this.cpuNum;
        }

        public HostInfo.OSFamily getOSFamily() {
            return this.os.getFamily();
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getShell() {
            return this.shell;
        }

        public String getTempDir() {
            return this.tempDir;
        }

        public File getTempDirFile() {
            if (this.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                return new File(WindowsSupport.getInstance().convertToWindowsPath(this.tempDir));
            }
            return new File(this.tempDir);
        }

        public long getClockSkew() {
            return this.clockSkew;
        }

        public String getPath() {
            return this.path;
        }
    }
}

