/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.filesearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileSearchParams {
    private final ExecutionEnvironment execEnv;
    private final List<String> searchPaths;
    private final String filename;
    private final boolean searchInUserPaths;

    public FileSearchParams(ExecutionEnvironment executionEnvironment, List<String> list, String string, boolean bl) {
        if (executionEnvironment == null || list == null || string == null) {
            throw new NullPointerException("FileSearchParams cannot be null");
        }
        this.execEnv = executionEnvironment;
        this.searchPaths = Collections.unmodifiableList(new ArrayList<String>(list));
        this.filename = string;
        this.searchInUserPaths = bl;
    }

    public ExecutionEnvironment getExecEnv() {
        return this.execEnv;
    }

    public String getFilename() {
        return this.filename;
    }

    public List<String> getSearchPaths() {
        return this.searchPaths;
    }

    public boolean isSearchInUserPaths() {
        return this.searchInUserPaths;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileSearchParams)) {
            return false;
        }
        FileSearchParams fileSearchParams = (FileSearchParams)object;
        return this.searchInUserPaths == fileSearchParams.searchInUserPaths && ((Object)this.execEnv).equals(fileSearchParams.execEnv) && this.filename.equals(fileSearchParams.filename) && ((Object)this.searchPaths).equals(fileSearchParams.searchPaths);
    }

    public int hashCode() {
        int n = 7;
        n = 29 * n + (this.execEnv != null ? this.execEnv.hashCode() : 0);
        n = 29 * n + (this.searchPaths != null ? ((Object)this.searchPaths).hashCode() : 0);
        n = 29 * n + (this.filename != null ? this.filename.hashCode() : 0);
        n = 29 * n + (this.searchInUserPaths ? 1 : 0);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("File to search: " + this.filename + "; ");
        stringBuilder.append("Search env: " + ((Object)this.execEnv).toString() + "; ");
        stringBuilder.append("Search paths: " + Arrays.toString(this.searchPaths.toArray(new String[0])) + "; ");
        stringBuilder.append("Search in PATH: " + (this.searchInUserPaths ? "yes" : "no"));
        return stringBuilder.toString();
    }
}

