/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessUtils {
    private ProcessUtils() {
    }

    public static List<String> readProcessError(Process process) throws IOException {
        if (process == null) {
            return Collections.emptyList();
        }
        return ProcessUtils.readProcessStream(process.getErrorStream());
    }

    public static String readProcessErrorLine(Process process) throws IOException {
        if (process == null) {
            return "";
        }
        return ProcessUtils.readProcessStreamLine(process.getErrorStream());
    }

    public static List<String> readProcessOutput(Process process) throws IOException {
        if (process == null) {
            return Collections.emptyList();
        }
        return ProcessUtils.readProcessStream(process.getInputStream());
    }

    public static String readProcessOutputLine(Process process) throws IOException {
        if (process == null) {
            return "";
        }
        return ProcessUtils.readProcessStreamLine(process.getInputStream());
    }

    public static void logError(Level level, Logger logger, Process process) throws IOException {
        if (logger == null || !logger.isLoggable(level)) {
            return;
        }
        List<String> list = ProcessUtils.readProcessError(process);
        for (String string : list) {
            logger.log(level, "ERROR: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> readProcessStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return Collections.emptyList();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                linkedList.add(string);
            }
            Object var5_4 = null;
            if (bufferedReader == null) return linkedList;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readProcessStreamLine(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
            Object var5_4 = null;
            if (bufferedReader == null) return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    public static void writeError(Writer writer, Process process) throws IOException {
        List<String> list = ProcessUtils.readProcessError(process);
        for (String string : list) {
            writer.write(string);
        }
    }
}

