/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

public final class MacroExpanderFactory {
    private MacroExpanderFactory() {
    }

    public static MacroExpander getExpander(ExecutionEnvironment executionEnvironment) {
        return MacroExpanderFactory.getExpander(executionEnvironment, null);
    }

    public static MacroExpander getExpander(ExecutionEnvironment executionEnvironment, String string) {
        CommonMacroExpander commonMacroExpander = "SunStudio".equals(string) ? new SunStudioMacroExpander(executionEnvironment) : new CommonMacroExpander(executionEnvironment);
        return commonMacroExpander;
    }

    private static class SunStudioMacroExpander
    extends CommonMacroExpander {
        public SunStudioMacroExpander(ExecutionEnvironment executionEnvironment) {
            super(executionEnvironment);
        }

        protected void setupPredefined(HostInfo hostInfo) {
            super.setupPredefined(hostInfo);
            String string = (String)predefinedMacros.get("platform");
            if ("x86".equals(string)) {
                string = "intel";
            }
            string = hostInfo.getOSFamily() == HostInfo.OSFamily.SUNOS ? string + "-S2" : string + "-" + hostInfo.getOSFamily().name();
            predefinedMacros.put("platform", string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommonMacroExpander
    implements MacroExpander {
        protected static final Map<String, String> predefinedMacros = Collections.synchronizedMap(new HashMap());
        protected final ExecutionEnvironment execEnv;
        private final int[][] ttable = new int[][]{{0, 0, 0, 1, 0, 0}, {2, 3, 3, 10, 4, 3}, {2, 2, 5, 6, 5, 5}, {7, 7, 8, 8, 8, 9}, {7, 3, 3, 3, 8, 8}};
        private final StringBuilder res = new StringBuilder();
        private final StringBuilder buf = new StringBuilder();
        private boolean initialized;

        public CommonMacroExpander(ExecutionEnvironment executionEnvironment) {
            this.execEnv = executionEnvironment;
            this.initialized = false;
        }

        private int getCharClass(char c) {
            if (c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                return 0;
            }
            if (c >= '0' && c <= '9') {
                return 1;
            }
            if (c == '$') {
                return 3;
            }
            if (c == '{') {
                return 4;
            }
            if (c == '}') {
                return 5;
            }
            return 2;
        }

        private String valueOf(String string, Map<String, String> map) {
            String string2 = map.get(string);
            return string2 == null ? "${" + string + "}" : string2;
        }

        @Override
        public final String expandPredefinedMacros(String string) throws ParseException {
            return this.expandMacros(string, predefinedMacros);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final String expandMacros(String string, Map<String, String> map) throws ParseException {
            if (string == null || string.length() == 0) {
                return string;
            }
            CommonMacroExpander commonMacroExpander = this;
            synchronized (commonMacroExpander) {
                if (!this.initialized) {
                    try {
                        HostInfo hostInfo = HostInfoUtils.getHostInfo(this.execEnv);
                        if (hostInfo != null) {
                            this.setupPredefined(hostInfo);
                            this.initialized = true;
                        }
                    }
                    catch (IOException iOException) {
                    }
                    catch (CancellationException cancellationException) {
                        // empty catch block
                    }
                }
            }
            this.res.setLength(0);
            this.buf.setLength(0);
            int n = 0;
            int n2 = -1;
            char[] cArray = (string + '\u0000').toCharArray();
            block19: for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                switch (this.ttable[n][this.getCharClass(c)]) {
                    case 0: {
                        if (c == '\u0000') continue block19;
                        this.res.append(c);
                        continue block19;
                    }
                    case 1: {
                        n2 = i;
                        this.buf.setLength(0);
                        n = 1;
                        continue block19;
                    }
                    case 2: {
                        this.buf.append(c);
                        n = 2;
                        continue block19;
                    }
                    case 3: {
                        this.res.append(string.substring(n2, i + (c == '\u0000' ? 0 : 1)));
                        this.buf.setLength(0);
                        n = 0;
                        continue block19;
                    }
                    case 4: {
                        n = 4;
                        continue block19;
                    }
                    case 5: {
                        this.res.append(this.valueOf(this.buf.toString().trim(), map));
                        --i;
                        this.buf.setLength(0);
                        n = 0;
                        continue block19;
                    }
                    case 6: {
                        this.res.append(this.valueOf(this.buf.toString().trim(), map));
                        n2 = i;
                        this.buf.setLength(0);
                        n = 1;
                        continue block19;
                    }
                    case 7: {
                        this.buf.append(c);
                        n = 3;
                        continue block19;
                    }
                    case 8: {
                        throw new ParseException("Bad substitution", i);
                    }
                    case 9: {
                        this.res.append(this.valueOf(this.buf.toString().trim(), map));
                        this.buf.setLength(0);
                        n = 0;
                        continue block19;
                    }
                    case 10: {
                        this.res.append(string.substring(n2, i));
                        --i;
                        this.buf.setLength(0);
                        n = 0;
                    }
                }
            }
            return this.res.toString();
        }

        protected void setupPredefined(HostInfo hostInfo) {
            String string;
            String string2;
            switch (hostInfo.getOSFamily()) {
                case WINDOWS: {
                    string2 = "dll";
                    string = "Windows";
                    break;
                }
                case MACOSX: {
                    string2 = "dylib";
                    string = "MacOSX";
                    break;
                }
                case SUNOS: {
                    string2 = "so";
                    string = "SunOS";
                    break;
                }
                case LINUX: {
                    string2 = "so";
                    string = "Linux";
                    break;
                }
                default: {
                    string = hostInfo.getOSFamily().name();
                    string2 = "so";
                }
            }
            HostInfo.OS oS = hostInfo.getOS();
            predefinedMacros.put("hostname", hostInfo.getHostname().toLowerCase());
            predefinedMacros.put("soext", string2);
            predefinedMacros.put("platform", hostInfo.getCpuFamily().name().toLowerCase());
            predefinedMacros.put("osname", string);
            predefinedMacros.put("isa", oS.getBitness().toString());
            predefinedMacros.put("_isa", oS.getBitness() == HostInfo.Bitness._64 ? "_64" : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MacroExpander {
        public String expandPredefinedMacros(String var1) throws ParseException;

        public String expandMacros(String var1, Map<String, String> var2) throws ParseException;
    }
}

