/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.ui.commands;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.spi.commands.FrameworkCommand;
import org.netbeans.modules.php.spi.commands.FrameworkCommandSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FrameworkCommandChooser
extends JPanel {
    private static final long serialVersionUID = 24055317521316402L;
    private static final Object NO_TASK_ITEM = FrameworkCommandChooser.getMessage("FrameworkCommandChooser.no.task", new String[0]);
    private static final Object NO_MATCHING_TASK_ITEM = FrameworkCommandChooser.getMessage("FrameworkCommandChooser.no.matching.task", new String[0]);
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private static boolean debug;
    private static String lastTask;
    private static boolean keepOpened;
    private static final Map<String, Map<FrameworkCommand, ParameterContainer>> PROJECT_TO_TASK;
    private final FrameworkCommandSupport frameworkCommandSupport;
    private final List<FrameworkCommand> allTasks = new ArrayList<FrameworkCommand>();
    private final JTextField taskParametersComboBoxEditor;
    private JButton runButton;
    private boolean refreshNeeded;
    private JCheckBox debugCheckbox;
    private JScrollPane helpScrollPane;
    private JTextArea helpTextArea;
    private JCheckBox keepOpenedCheckBox;
    private JLabel matchingTaskLabel;
    private JList matchingTaskList;
    private JScrollPane matchingTaskSP;
    private JLabel previewLabel;
    private JTextField previewTextField;
    private JSplitPane splitPane;
    private JTextField taskField;
    private JPanel taskFieldPanel;
    private JLabel taskHint;
    private JLabel taskLabel;
    private JLabel taskParamLabel;
    private JComboBox taskParametersComboBox;

    private FrameworkCommandChooser(FrameworkCommandSupport frameworkCommandSupport, JButton jButton) {
        assert (frameworkCommandSupport != null);
        assert (jButton != null);
        this.frameworkCommandSupport = frameworkCommandSupport;
        this.runButton = jButton;
        this.initComponents();
        this.taskParametersComboBoxEditor = (JTextField)this.taskParametersComboBox.getEditor().getEditorComponent();
        this.matchingTaskList.setCellRenderer(new FrameworkCommandRenderer());
        this.debugCheckbox.setSelected(debug);
        this.keepOpenedCheckBox.setSelected(keepOpened);
        this.keepOpenedCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                keepOpened = itemEvent.getStateChange() == 1;
            }
        });
        this.refreshNeeded = this.reloadAllTasks();
        this.refreshTaskList();
        this.taskField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                FrameworkCommandChooser.this.refreshTaskList();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                FrameworkCommandChooser.this.refreshTaskList();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                FrameworkCommandChooser.this.refreshTaskList();
            }
        });
        this.preselectLastlySelected();
        this.initTaskParameters();
        this.updateHelp();
        this.updatePreview();
    }

    public static void open(final FrameworkCommandSupport frameworkCommandSupport) {
        assert (frameworkCommandSupport != null);
        assert (EventQueue.isDispatchThread()) : "must be called from EDT";
        String string = frameworkCommandSupport.getFrameworkName();
        final JButton jButton = new JButton(FrameworkCommandChooser.getMessage("FrameworkCommandChooser.runButton", new String[0]));
        final FrameworkCommandChooser frameworkCommandChooser = new FrameworkCommandChooser(frameworkCommandSupport, jButton);
        String string2 = FrameworkCommandChooser.getMessage("FrameworkCommandChooser.title", string, frameworkCommandSupport.getPhpModule().getDisplayName());
        jButton.getAccessibleContext().setAccessibleDescription(FrameworkCommandChooser.getMessage("FrameworkCommandChooser.runButton.accessibleDescription", string));
        FrameworkCommandChooser.setRunButtonState(jButton, frameworkCommandChooser);
        frameworkCommandChooser.matchingTaskList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FrameworkCommandChooser.setRunButtonState(jButton, frameworkCommandChooser);
                frameworkCommandChooser.initTaskParameters();
                frameworkCommandChooser.updateHelp();
                frameworkCommandChooser.updatePreview();
            }
        });
        final JButton jButton2 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)FrameworkCommandChooser.getMessage("FrameworkCommandChooser.refreshButton", new String[0]));
        jButton2.getAccessibleContext().setAccessibleDescription(FrameworkCommandChooser.getMessage("FrameworkCommandChooser.refreshButton.accessibleDescription", string));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton2.setEnabled(false);
                jButton.setEnabled(false);
                frameworkCommandChooser.reloadTasks(new Runnable(){

                    public void run() {
                        assert (EventQueue.isDispatchThread()) : "is EDT";
                        jButton2.setEnabled(true);
                        FrameworkCommandChooser.setRunButtonState(jButton, frameworkCommandChooser);
                    }
                });
            }
        });
        Object[] objectArray = new Object[]{jButton2, jButton, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)frameworkCommandChooser, string2, false, objectArray, (Object)jButton, 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleName(FrameworkCommandChooser.getMessage("FrameworkCommandChooser.accessibleName", string));
        dialog.getAccessibleContext().setAccessibleDescription(FrameworkCommandChooser.getMessage("FrameworkCommandChooser.accessibleDescription", string));
        if (frameworkCommandChooser.refreshNeeded) {
            jButton2.setEnabled(false);
            jButton.setEnabled(false);
            frameworkCommandChooser.reloadTasks(new Runnable(){

                public void run() {
                    assert (EventQueue.isDispatchThread()) : "is EDT";
                    jButton2.setEnabled(true);
                    FrameworkCommandChooser.setRunButtonState(jButton, frameworkCommandChooser);
                }
            });
        }
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!frameworkCommandChooser.keepOpenedCheckBox.isSelected()) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
                FrameworkCommand frameworkCommand = frameworkCommandChooser.getSelectedTask();
                debug = frameworkCommandChooser.debugCheckbox.isSelected();
                lastTask = frameworkCommand.getCommand();
                frameworkCommandChooser.storeParameters();
                frameworkCommandSupport.runCommand(new FrameworkCommandSupport.CommandDescriptor(frameworkCommand, frameworkCommandChooser.getParameters(), debug));
            }
        });
        dialog.setVisible(true);
    }

    void initTaskParameters() {
        FrameworkCommand frameworkCommand = this.getSelectedTask();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        arrayList.addAll(this.getStoredParams(frameworkCommand));
        this.taskParametersComboBox.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.preselectLastSelectedParam(frameworkCommand);
        this.taskParametersComboBoxEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            private void processUpdate() {
                FrameworkCommandChooser.this.updatePreview();
            }
        });
    }

    void updateHelp() {
        final FrameworkCommand frameworkCommand = this.getSelectedTask();
        if (frameworkCommand == null) {
            this.updateHelp(null);
        } else if (frameworkCommand.hasHelp()) {
            this.updateHelp(frameworkCommand.getHelp());
        } else {
            this.updateHelp(FrameworkCommandChooser.getMessage("LBL_PleaseWait", new String[0]));
            EXECUTOR.submit(new Runnable(){

                public void run() {
                    final String string = frameworkCommand.getHelp();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            FrameworkCommandChooser.this.updateHelp(string);
                        }
                    });
                }
            });
        }
    }

    void updateHelp(String string) {
        assert (SwingUtilities.isEventDispatchThread()) : "must be run in EDT";
        this.helpTextArea.setText(string);
        this.helpTextArea.setCaretPosition(0);
    }

    void updatePreview() {
        FrameworkCommand frameworkCommand = this.getSelectedTask();
        String string = null;
        if (frameworkCommand != null) {
            string = frameworkCommand.getPreview() + " " + this.taskParametersComboBoxEditor.getText();
        }
        this.previewTextField.setText(string);
    }

    private void preselectLastSelectedParam(FrameworkCommand frameworkCommand) {
        ParameterContainer parameterContainer = this.getTasksToParams().get(frameworkCommand);
        if (parameterContainer == null) {
            return;
        }
        String string = parameterContainer.getLastSelected();
        if (string == null) {
            this.taskParametersComboBox.setSelectedItem("");
            return;
        }
        for (int i = 0; i < this.taskParametersComboBox.getItemCount(); ++i) {
            Object e = this.taskParametersComboBox.getItemAt(i);
            if (!e.equals(string)) continue;
            this.taskParametersComboBox.setSelectedIndex(i);
            break;
        }
    }

    private Map<FrameworkCommand, ParameterContainer> getTasksToParams() {
        String string = this.frameworkCommandSupport.getPhpModule().getSourceDirectory().getPath();
        Map<FrameworkCommand, ParameterContainer> map = PROJECT_TO_TASK.get(string);
        if (map == null) {
            map = new HashMap<FrameworkCommand, ParameterContainer>();
            PROJECT_TO_TASK.put(string, map);
        }
        return map;
    }

    private List<String> getStoredParams(FrameworkCommand frameworkCommand) {
        if (frameworkCommand == null) {
            return Collections.emptyList();
        }
        Map<FrameworkCommand, ParameterContainer> map = this.getTasksToParams();
        if (map == null) {
            return Collections.emptyList();
        }
        ParameterContainer parameterContainer = map.get(frameworkCommand);
        if (parameterContainer == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(parameterContainer.getParams());
        Collections.sort(arrayList);
        return arrayList;
    }

    private String getParameters() {
        Object object = this.taskParametersComboBox.getSelectedItem();
        return object.toString().trim();
    }

    private static void setRunButtonState(JButton jButton, FrameworkCommandChooser frameworkCommandChooser) {
        jButton.setEnabled(frameworkCommandChooser.getSelectedTask() != null);
    }

    private void storeParameters() {
        ParameterContainer parameterContainer;
        String string = this.frameworkCommandSupport.getPhpModule().getSourceDirectory().getPath();
        Map<FrameworkCommand, ParameterContainer> map = PROJECT_TO_TASK.get(string);
        if (map == null) {
            map = new HashMap<FrameworkCommand, ParameterContainer>();
            PROJECT_TO_TASK.put(string, map);
        }
        if ((parameterContainer = map.get(this.getSelectedTask())) == null) {
            parameterContainer = new ParameterContainer();
            map.put(this.getSelectedTask(), parameterContainer);
        }
        String string2 = this.getParameters();
        parameterContainer.addParam(string2);
        parameterContainer.setLastSelected(string2);
    }

    private void preselectLastlySelected() {
        if (lastTask == null) {
            return;
        }
        for (FrameworkCommand frameworkCommand : this.allTasks) {
            if (!lastTask.equals(frameworkCommand.getCommand())) continue;
            this.matchingTaskList.setSelectedValue(frameworkCommand, true);
            break;
        }
        this.initTaskParameters();
    }

    private boolean reloadAllTasks() {
        this.allTasks.clear();
        List<FrameworkCommand> list = this.frameworkCommandSupport.getFrameworkCommands();
        if (list != null) {
            this.allTasks.addAll(list);
            return false;
        }
        return true;
    }

    private void refreshTaskList() {
        String string = this.taskField.getText().trim();
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        List<FrameworkCommand> list = Filter.getFilteredTasks(this.allTasks, string);
        for (FrameworkCommand frameworkCommand : list) {
            defaultListModel.addElement(frameworkCommand);
        }
        this.matchingTaskList.setModel(defaultListModel);
        if (defaultListModel.isEmpty()) {
            if (this.allTasks.isEmpty()) {
                defaultListModel.addElement(NO_TASK_ITEM);
            } else {
                defaultListModel.addElement(NO_MATCHING_TASK_ITEM);
            }
        }
        this.matchingTaskList.setSelectedIndex(0);
        this.initTaskParameters();
    }

    private void reloadTasks(final Runnable runnable) {
        final Object e = this.matchingTaskList.getSelectedValue();
        final JComponent[] jComponentArray = new JComponent[]{this.matchingTaskSP, this.matchingTaskLabel, this.matchingTaskLabel, this.matchingTaskList, this.taskLabel, this.taskField, this.debugCheckbox, this.taskParamLabel, this.taskParametersComboBox, this.taskHint};
        this.setEnabled(jComponentArray, false);
        this.matchingTaskList.setListData(new Object[]{FrameworkCommandChooser.getMessage("FrameworkCommandChooser.reloading.tasks", this.frameworkCommandSupport.getFrameworkName())});
        this.frameworkCommandSupport.refreshFrameworkCommandsLater(new Runnable(){

            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        FrameworkCommandChooser.this.reloadAllTasks();
                        FrameworkCommandChooser.this.refreshTaskList();
                        FrameworkCommandChooser.this.matchingTaskList.setSelectedValue(e, true);
                        runnable.run();
                        FrameworkCommandChooser.this.setEnabled(jComponentArray, true);
                        FrameworkCommandChooser.this.taskField.requestFocus();
                    }
                });
            }
        });
    }

    private void setEnabled(JComponent[] jComponentArray, boolean bl) {
        for (JComponent jComponent : jComponentArray) {
            jComponent.setEnabled(bl);
        }
    }

    private FrameworkCommand getSelectedTask() {
        Object e = this.matchingTaskList.getSelectedValue();
        if (e != null && !NO_MATCHING_TASK_ITEM.equals(e) && !NO_TASK_ITEM.equals(e)) {
            return (FrameworkCommand)e;
        }
        return null;
    }

    private static String getMessage(String string, String ... stringArray) {
        return NbBundle.getMessage(FrameworkCommandChooser.class, (String)string, (Object[])stringArray);
    }

    private void initComponents() {
        this.debugCheckbox = new JCheckBox();
        this.taskLabel = new JLabel();
        this.taskFieldPanel = new JPanel();
        this.taskField = new JTextField();
        this.taskHint = new JLabel();
        this.taskParamLabel = new JLabel();
        this.taskParametersComboBox = new JComboBox();
        this.matchingTaskLabel = new JLabel();
        this.splitPane = new JSplitPane();
        this.matchingTaskSP = new JScrollPane();
        this.matchingTaskList = new JList();
        this.helpScrollPane = new JScrollPane();
        this.helpTextArea = new JTextArea();
        this.previewTextField = new JTextField();
        this.previewLabel = new JLabel();
        this.keepOpenedCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.debugCheckbox, (String)NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.debugCheckbox.text"));
        this.debugCheckbox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.debugCheckbox.AccessibleContext.accessibleName"));
        this.debugCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.debugCheckbox.AccessibleContext.accessibleDescription"));
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                return FrameworkCommandChooser.this.matchingTaskList;
            }

            public Component getFirstComponent(Container container) {
                return FrameworkCommandChooser.this.matchingTaskList;
            }

            public Component getLastComponent(Container container) {
                return FrameworkCommandChooser.this.keepOpenedCheckBox;
            }

            public Component getComponentAfter(Container container, Component component) {
                if (component == FrameworkCommandChooser.this.matchingTaskList) {
                    return FrameworkCommandChooser.this.helpTextArea;
                }
                if (component == FrameworkCommandChooser.this.helpTextArea) {
                    return FrameworkCommandChooser.this.previewTextField;
                }
                if (component == FrameworkCommandChooser.this.taskField) {
                    return FrameworkCommandChooser.this.taskParametersComboBox;
                }
                if (component == FrameworkCommandChooser.this.previewTextField) {
                    return FrameworkCommandChooser.this.keepOpenedCheckBox;
                }
                if (component == FrameworkCommandChooser.this.taskParametersComboBox) {
                    return FrameworkCommandChooser.this.matchingTaskList;
                }
                return FrameworkCommandChooser.this.matchingTaskList;
            }

            public Component getComponentBefore(Container container, Component component) {
                if (component == FrameworkCommandChooser.this.helpTextArea) {
                    return FrameworkCommandChooser.this.matchingTaskList;
                }
                if (component == FrameworkCommandChooser.this.previewTextField) {
                    return FrameworkCommandChooser.this.helpTextArea;
                }
                if (component == FrameworkCommandChooser.this.taskParametersComboBox) {
                    return FrameworkCommandChooser.this.taskField;
                }
                if (component == FrameworkCommandChooser.this.keepOpenedCheckBox) {
                    return FrameworkCommandChooser.this.previewTextField;
                }
                if (component == FrameworkCommandChooser.this.matchingTaskList) {
                    return FrameworkCommandChooser.this.taskParametersComboBox;
                }
                return FrameworkCommandChooser.this.keepOpenedCheckBox;
            }
        });
        this.taskLabel.setLabelFor(this.taskField);
        Mnemonics.setLocalizedText((JLabel)this.taskLabel, (String)NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskLabel.text"));
        this.taskFieldPanel.setLayout(new BorderLayout());
        this.taskField.setText(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskField.text"));
        this.taskField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                FrameworkCommandChooser.this.taskFieldKeyPressed(keyEvent);
            }
        });
        this.taskFieldPanel.add((Component)this.taskField, "North");
        this.taskField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskField.AccessibleContext.accessibleName"));
        this.taskField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskField.AccessibleContext.accessibleDescription"));
        this.taskHint.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.taskHint, (String)NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskHint.text"));
        this.taskFieldPanel.add((Component)this.taskHint, "South");
        this.taskHint.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskHint.AccessibleContext.accessibleName"));
        this.taskHint.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskHint.AccessibleContext.accessibleDescription"));
        this.taskParamLabel.setLabelFor(this.taskParametersComboBox);
        Mnemonics.setLocalizedText((JLabel)this.taskParamLabel, (String)NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskParamLabel.text"));
        this.taskParametersComboBox.setEditable(true);
        this.matchingTaskLabel.setLabelFor(this.matchingTaskList);
        Mnemonics.setLocalizedText((JLabel)this.matchingTaskLabel, (String)NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.matchingTaskLabel.text"));
        this.splitPane.setBorder(null);
        this.splitPane.setDividerLocation(150);
        this.splitPane.setDividerSize(5);
        this.splitPane.setOrientation(0);
        this.matchingTaskList.setFont(new Font("Monospaced", 0, 12));
        this.matchingTaskList.setSelectionMode(0);
        this.matchingTaskList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                FrameworkCommandChooser.this.matchingTaskListMouseClicked(mouseEvent);
            }
        });
        this.matchingTaskSP.setViewportView(this.matchingTaskList);
        this.matchingTaskList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.matchingTaskList.AccessibleContext.accessibleName"));
        this.matchingTaskList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.matchingTaskList.AccessibleContext.accessibleDescription"));
        this.splitPane.setTopComponent(this.matchingTaskSP);
        this.matchingTaskSP.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.matchingTaskSP.AccessibleContext.accessibleName"));
        this.matchingTaskSP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.matchingTaskSP.AccessibleContext.accessibleDescription"));
        this.helpTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.helpTextArea.setColumns(20);
        this.helpTextArea.setEditable(false);
        this.helpTextArea.setRows(5);
        this.helpScrollPane.setViewportView(this.helpTextArea);
        this.helpTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.helpTextArea.AccessibleContext.accessibleName"));
        this.helpTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.helpTextArea.AccessibleContext.accessibleDescription"));
        this.splitPane.setRightComponent(this.helpScrollPane);
        this.helpScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.helpScrollPane.AccessibleContext.accessibleName"));
        this.helpScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.helpScrollPane.AccessibleContext.accessibleDescription"));
        this.previewTextField.setEditable(false);
        this.previewLabel.setLabelFor(this.previewTextField);
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.previewLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.keepOpenedCheckBox, (String)NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.keepOpenedCheckBox.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.keepOpenedCheckBox).add(1, (Component)this.splitPane, -1, 659, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.taskLabel).add((Component)this.taskParamLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.taskParametersComboBox, 0, 575, Short.MAX_VALUE).add((Component)this.taskFieldPanel, -1, 575, Short.MAX_VALUE))).add(1, (Component)this.matchingTaskLabel).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.previewLabel).addPreferredGap(0).add((Component)this.previewTextField, -1, 580, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.taskLabel).add((Component)this.taskFieldPanel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.taskParamLabel).add((Component)this.taskParametersComboBox, -2, 21, -2)).addPreferredGap(1).add((Component)this.matchingTaskLabel).addPreferredGap(0).add((Component)this.splitPane, -1, 306, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.previewTextField, -2, -1, -2).add((Component)this.previewLabel)).addPreferredGap(0).add((Component)this.keepOpenedCheckBox)));
        this.taskLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskLabel.AccessibleContext.accessibleName"));
        this.taskLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskLabel.AccessibleContext.accessibleDescription"));
        this.taskFieldPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskFieldPanel.AccessibleContext.accessibleName"));
        this.taskFieldPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskFieldPanel.AccessibleContext.accessibleDescription"));
        this.taskParamLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskParamLabel.AccessibleContext.accessibleName"));
        this.taskParamLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskParamLabel.AccessibleContext.accessibleDescription"));
        this.taskParametersComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskParametersComboBox.AccessibleContext.accessibleDescription"));
        this.matchingTaskLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.matchingTaskLabel.AccessibleContext.accessibleName"));
        this.matchingTaskLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.matchingTaskLabel.AccessibleContext.accessibleDescription"));
        this.splitPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.splitPane.AccessibleContext.accessibleName"));
        this.splitPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.splitPane.AccessibleContext.accessibleDescription"));
        this.previewTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.previewTextField.AccessibleContext.accessibleDescription"));
        this.previewLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.previewLabel.AccessibleContext.accessibleName"));
        this.previewLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.previewLabel.AccessibleContext.accessibleDescription"));
        this.keepOpenedCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.keepOpenedCheckBox.AccessibleContext.accessibleName"));
        this.keepOpenedCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.keepOpenedCheckBox.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.AccessibleContext.accessibleDescription"));
    }

    private void handleNavigationKeys(KeyEvent keyEvent) {
        Object object = this.matchingTaskList.getInputMap().get(KeyStroke.getKeyStrokeForEvent(keyEvent));
        boolean bl = "selectPreviousRow".equals(object) || "selectPreviousRowExtendSelection".equals(object) || "selectNextRow".equals(object) || "selectNextRowExtendSelection".equals(object) || "scrollUp".equals(object) || "scrollUpExtendSelection".equals(object) || "scrollDown".equals(object) || "scrollDownExtendSelection".equals(object);
        int n = this.matchingTaskList.getSelectedIndex();
        ListModel listModel = this.matchingTaskList.getModel();
        int n2 = listModel.getSize();
        if ("selectNextRow".equals(object) && n == n2 - 1) {
            this.matchingTaskList.setSelectedIndex(0);
            this.matchingTaskList.ensureIndexIsVisible(0);
            return;
        }
        if ("selectPreviousRow".equals(object) && n == 0) {
            int n3 = n2 - 1;
            this.matchingTaskList.setSelectedIndex(n3);
            this.matchingTaskList.ensureIndexIsVisible(n3);
            return;
        }
        if (bl) {
            Action action = this.matchingTaskList.getActionMap().get(object);
            action.actionPerformed(new ActionEvent(this.matchingTaskList, 0, (String)object));
            keyEvent.consume();
        }
    }

    private void taskFieldKeyPressed(KeyEvent keyEvent) {
        this.handleNavigationKeys(keyEvent);
    }

    private void matchingTaskListMouseClicked(MouseEvent mouseEvent) {
        if (this.runButton.isEnabled() && mouseEvent.getClickCount() == 2) {
            this.runButton.doClick();
        }
    }

    static {
        keepOpened = false;
        PROJECT_TO_TASK = new HashMap<String, Map<FrameworkCommand, ParameterContainer>>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterContainer {
        private final Set<String> params = new HashSet<String>();
        private String lastSelected;

        private ParameterContainer() {
        }

        public void addParam(String string) {
            this.params.add(string);
        }

        public String getLastSelected() {
            return this.lastSelected;
        }

        public void setLastSelected(String string) {
            this.lastSelected = string;
        }

        public Set<String> getParams() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Filter {
        private final String filter;
        private final List<FrameworkCommand> tasks;

        private Filter(List<FrameworkCommand> list, String string) {
            this.tasks = list;
            this.filter = string;
        }

        static List<FrameworkCommand> getFilteredTasks(List<FrameworkCommand> list, String string) {
            Filter filter = new Filter(list, string);
            return filter.filter();
        }

        private List<FrameworkCommand> filter() {
            ArrayList<FrameworkCommand> arrayList = new ArrayList<FrameworkCommand>();
            Pattern pattern = StringUtils.getPattern(this.filter);
            if (pattern != null) {
                for (FrameworkCommand frameworkCommand : this.tasks) {
                    Matcher matcher = pattern.matcher(frameworkCommand.getCommand());
                    if (!matcher.matches()) continue;
                    arrayList.add(frameworkCommand);
                }
            } else {
                ArrayList<FrameworkCommand> arrayList2 = new ArrayList<FrameworkCommand>();
                for (FrameworkCommand frameworkCommand : this.tasks) {
                    String string;
                    String string2 = frameworkCommand.getCommand().toLowerCase(Locale.ENGLISH);
                    if (string2.startsWith(string = this.filter.toLowerCase(Locale.ENGLISH))) {
                        arrayList2.add(frameworkCommand);
                        continue;
                    }
                    if (!string2.contains(string)) continue;
                    arrayList.add(frameworkCommand);
                }
                arrayList.addAll(0, arrayList2);
            }
            return arrayList;
        }
    }

    private static class FrameworkCommandRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -6180208903089211882L;

        public FrameworkCommandRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            Object object3;
            this.setName("ComboBox.listRenderer");
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                object3 = jList.getBackground();
                object2 = new Color(Math.abs(((Color)object3).getRed() - 10), Math.abs(((Color)object3).getGreen() - 10), Math.abs(((Color)object3).getBlue() - 10));
                this.setBackground((Color)(n % 2 == 0 ? object3 : object2));
                this.setForeground(jList.getForeground());
            }
            this.setFont(jList.getFont());
            if (object instanceof FrameworkCommand) {
                object3 = (FrameworkCommand)object;
                object2 = ((FrameworkCommand)object3).getDescription();
                StringBuilder stringBuilder = new StringBuilder(100);
                stringBuilder.append("<html>");
                stringBuilder.append("<b>").append(((FrameworkCommand)object3).getDisplayName()).append("</b>");
                if (object2 != null) {
                    stringBuilder.append(" : ").append((String)object2);
                }
                stringBuilder.append("</html>");
                this.setText(stringBuilder.toString());
            } else {
                this.setText(object.toString());
            }
            return this;
        }
    }
}

