/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.jsf.dialogs.BrowseFolders;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateClientPanelVisual
extends JPanel
implements HelpCtx.Provider {
    private WizardDescriptor wizardDescriptor;
    private final Set listeners = new HashSet(1);
    private static final String NAME_SPACE = "http://java.sun.com/jsf/facelets";
    private static final String TAG_NAME = "ui:insert";
    private static final String VALUE_NAME = "name";
    Collection<String> templateData = Collections.EMPTY_SET;
    private ButtonGroup bgRootTag;
    private JButton jbBrowse;
    private JLabel jlRootTag;
    private JLabel jlTemplate;
    private JRadioButton jrbComposition;
    private JRadioButton jrbHtml;
    private JTextField jtfTemplate;

    public TemplateClientPanelVisual(WizardDescriptor wizardDescriptor) {
        this.initComponents();
        this.wizardDescriptor = wizardDescriptor;
    }

    private void initComponents() {
        this.bgRootTag = new ButtonGroup();
        this.jrbHtml = new JRadioButton();
        this.jrbComposition = new JRadioButton();
        this.jlRootTag = new JLabel();
        this.jlTemplate = new JLabel();
        this.jtfTemplate = new JTextField();
        this.jbBrowse = new JButton();
        this.bgRootTag.add(this.jrbHtml);
        this.jrbHtml.setSelected(true);
        this.jrbHtml.setText("<html>&lt;html&gt;</html>");
        this.jrbHtml.setActionCommand("html");
        this.jrbHtml.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jrbHtml.setMargin(new Insets(0, 0, 0, 0));
        this.bgRootTag.add(this.jrbComposition);
        this.jrbComposition.setText("<ui:composition>");
        this.jrbComposition.setActionCommand("composition");
        this.jrbComposition.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jrbComposition.setMargin(new Insets(0, 0, 0, 0));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle");
        this.jlRootTag.setText(resourceBundle.getString("LBL_RootTag"));
        this.jlTemplate.setText(resourceBundle.getString("LBL_SelectTemplate"));
        this.jtfTemplate.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                TemplateClientPanelVisual.this.jtfTemplateKeyReleased(keyEvent);
            }
        });
        this.jbBrowse.setText(resourceBundle.getString("LBL_Browse"));
        this.jbBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TemplateClientPanelVisual.this.jbBrowseActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jlTemplate).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(138, 138, 138).add((Component)this.jtfTemplate, -1, 280, Short.MAX_VALUE))).addPreferredGap(0).add((Component)this.jbBrowse)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jlRootTag).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jrbComposition).add((Component)this.jrbHtml)).add(250, 250, 250)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jlTemplate).add((Component)this.jbBrowse).add((Component)this.jtfTemplate, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jlRootTag).add((Component)this.jrbHtml)).addPreferredGap(0).add((Component)this.jrbComposition).addContainerGap(33, Short.MAX_VALUE)));
    }

    private void jtfTemplateKeyReleased(KeyEvent keyEvent) {
        this.templateData = Collections.EMPTY_SET;
        this.fireChangeEvent();
    }

    private void jbBrowseActionPerformed(ActionEvent actionEvent) {
        Sources sources = (Sources)Templates.getProject((WizardDescriptor)this.wizardDescriptor).getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("doc_root");
        FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
        if (fileObject != null) {
            File file = FileUtil.toFile((FileObject)fileObject);
            this.jtfTemplate.setText(file.getAbsolutePath());
            this.templateData = Collections.EMPTY_SET;
        }
        this.fireChangeEvent();
    }

    protected boolean validateTemplate() {
        if (this.templateData != null && this.templateData.size() != 0) {
            return true;
        }
        String string = null;
        String string2 = this.jtfTemplate.getText();
        if (string2 == null || "".equals(string2)) {
            string = "MSG_NoTemplateSelected";
        } else {
            File file = new File(string2);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    Source source = Source.create((FileObject)fileObject);
                    this.templateData = new ArrayList<String>();
                    try {
                        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                            public void run(ResultIterator resultIterator) throws Exception {
                                HtmlParserResult htmlParserResult;
                                Parser.Result result = resultIterator.getParserResult(0);
                                if (result.getSnapshot().getMimeType().equals("text/html") && (htmlParserResult = (HtmlParserResult)result).getNamespaces().containsKey(TemplateClientPanelVisual.NAME_SPACE)) {
                                    List list = TemplateClientPanelVisual.this.findValue(htmlParserResult.root(TemplateClientPanelVisual.NAME_SPACE).children(), TemplateClientPanelVisual.TAG_NAME, new ArrayList());
                                    for (AstNode astNode : list) {
                                        String string;
                                        AstNode.Attribute attribute = astNode.getAttribute(TemplateClientPanelVisual.VALUE_NAME);
                                        if (attribute == null || (string = attribute.unquotedValue()) == null || "".equals(string)) continue;
                                        TemplateClientPanelVisual.this.templateData.add(string);
                                    }
                                }
                            }
                        });
                    }
                    catch (ParseException parseException) {
                        Exceptions.printStackTrace((Throwable)parseException);
                    }
                    if (this.templateData == null || this.templateData.size() == 0) {
                        string = "MSG_NoFaceletsTemplate";
                    }
                } else {
                    string = "MSG_TemplateHasToBeFile";
                }
            } else {
                string = "MSG_EneterExistingTemplate";
            }
        }
        if (string != null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TemplateClientPanelVisual.class, (String)string));
        }
        return string == null;
    }

    private List<AstNode> findValue(List<AstNode> list, String string, List<AstNode> list2) {
        if (list == null) {
            return list2;
        }
        for (int i = 0; i < list.size(); ++i) {
            AstNode astNode = list.get(i);
            if (string.equals(astNode.name())) {
                list2.add(astNode);
                continue;
            }
            list2 = this.findValue(astNode.children(), string, list2);
        }
        return list2;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TemplateClientPanelVisual.class);
    }

    public InputStream getTemplateClient() {
        String string = "org/netbeans/modules/web/jsf/facelets/resources/templates/";
        string = string + this.bgRootTag.getSelection().getActionCommand() + "TemplateClient.template";
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        return inputStream;
    }

    public Collection<String> getTemplateData() {
        return this.templateData;
    }

    public FileObject getTemplate() {
        FileObject fileObject = null;
        String string = this.jtfTemplate.getText();
        if (string != null && !"".equals(string)) {
            File file = new File(string);
            fileObject = FileUtil.toFileObject((File)file);
        }
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
        }
    }
}

