/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.spi.project.libraries.LibraryFactory;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JSFUtils {
    private static final String LIB_FOLDER = "lib";
    public static String DEFAULT_JSF_1_1_NAME = "jsf1102";
    public static String DEFAULT_JSF_1_2_NAME = "jsf12";
    public static String DEFAULT_JSF_2_0_NAME = "jsf20";
    public static String DEFAULT_JSTL_1_1_NAME = "jstl11";
    public static final String FACES_EXCEPTION = "javax.faces.FacesException";
    public static final String JSF_1_2__API_SPECIFIC_CLASS = "javax.faces.application.StateManagerWrapper";
    public static final String JSF_2_0__API_SPECIFIC_CLASS = "javax.faces.application.ProjectStage";
    public static final String JSF_2_0__IMPL_SPECIFIC_CLASS = "com.sun.faces.facelets.Facelet";
    public static final String MYFACES_SPECIFIC_CLASS = "org.apache.myfaces.webapp.StartupServletContextListener";
    protected static final String FACELETS_SKIPCOMMNETS = "javax.faces.FACELETS_SKIP_COMMENTS";
    protected static final String FACELETS_DEVELOPMENT = "facelets.DEVELOPMENT";
    protected static final String FACELETS_DEFAULT_SUFFIX = "javax.faces.DEFAULT_SUFFIX";
    public static final String FACES_PROJECT_STAGE = "javax.faces.PROJECT_STAGE";

    public static String isJSFInstallFolder(File file, JSFVersion jSFVersion) {
        String string = null;
        if (file.exists() && file.isDirectory()) {
            File file2 = new File(file, LIB_FOLDER);
            if (file2.exists()) {
                File[] fileArray = file2.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        boolean bl = false;
                        if (file.getName().endsWith(".jar")) {
                            bl = true;
                        }
                        return bl;
                    }
                });
                boolean bl = false;
                JSFVersion jSFVersion2 = JSFVersion.JSF_1_1;
                try {
                    List<File> list = Arrays.asList(fileArray);
                    bl = Util.containsClass(list, (String)FACES_EXCEPTION);
                    if (Util.containsClass(list, (String)JSF_1_2__API_SPECIFIC_CLASS)) {
                        jSFVersion2 = JSFVersion.JSF_1_2;
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                if (!bl) {
                    string = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_IS_NOT_JSF_API", (Object)file2.getPath());
                } else if (jSFVersion2.compareTo(jSFVersion) > 0) {
                    string = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_REQUIRED_JSF_VERSION");
                }
            } else {
                string = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_THERE_IS_NOT_LIB_FOLDER", (Object)file.getPath());
            }
        } else {
            string = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_IS_NOT_VALID_PATH", (Object)file.getPath());
        }
        return string;
    }

    public static boolean createJSFUserLibrary(File file, String string) throws IOException {
        boolean bl = false;
        File file2 = new File(file, LIB_FOLDER);
        if (file2.exists() && file2.isDirectory()) {
            URL uRL;
            File[] fileArray = file2.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().endsWith(".jar");
                }
            });
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (int i = 0; i < fileArray.length; ++i) {
                uRL = FileUtil.urlForArchiveOrDir((File)fileArray[i]);
                if (uRL == null) continue;
                arrayList.add(uRL);
            }
            LibraryManager libraryManager = LibraryManager.getDefault();
            uRL = LibrariesSupport.getLibraryTypeProvider((String)"j2se").createLibrary();
            uRL.setName(string);
            uRL.setDescription(string);
            uRL.setContent("classpath", arrayList);
            libraryManager.addLibrary(LibraryFactory.createLibrary((LibraryImplementation)uRL));
            bl = true;
        }
        return bl;
    }

    public static boolean debugFacelets(FileObject fileObject) {
        boolean bl = false;
        if (fileObject != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
                InitParam initParam = null;
                if (webApp != null) {
                    initParam = (InitParam)webApp.findBeanByName("InitParam", "ParamName", FACELETS_DEVELOPMENT);
                }
                if (initParam != null) {
                    bl = "true".equals(initParam.getParamValue().trim());
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return bl;
    }

    public static boolean skipCommnets(FileObject fileObject) {
        boolean bl = false;
        if (fileObject != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
                InitParam initParam = null;
                if (webApp != null) {
                    initParam = (InitParam)webApp.findBeanByName("InitParam", "ParamName", "facelets.SKIP_COMMENTS");
                }
                if (initParam != null) {
                    bl = "true".equals(initParam.getParamValue().trim());
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return bl;
    }

    public static String getRelativePath(FileObject fileObject, FileObject fileObject2) {
        String string = "./";
        String string2 = null;
        for (FileObject fileObject3 = fileObject.getParent(); fileObject3 != null && (string2 = FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject2)) == null; fileObject3 = fileObject3.getParent()) {
            string = string + "../";
        }
        return string2 != null ? string + string2 : null;
    }
}

