/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.model.CodeMarker;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.impl.CachingSupport;
import org.netbeans.modules.php.editor.model.impl.CodeMarkerImpl;
import org.netbeans.modules.php.editor.model.impl.ModelVisitor;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileScopeImpl
extends ScopeImpl
implements FileScope {
    private CachingSupport cachedModelSupport;
    private ParserResult info;
    private Map<ModelElement, List<Occurence>> occurences = new HashMap<ModelElement, List<Occurence>>();
    private List<CodeMarkerImpl> codeMarkers = new ArrayList<CodeMarkerImpl>();

    FileScopeImpl(ParserResult parserResult) {
        this(parserResult, "program");
    }

    private FileScopeImpl(ParserResult parserResult, String string) {
        super(null, string, (Union2<String, FileObject>)Union2.createSecond(parserResult != null ? parserResult.getSnapshot().getSource().getFileObject() : null), new OffsetRange(0, 0), PhpKind.PROGRAM);
        this.info = parserResult;
        this.cachedModelSupport = new CachingSupport(this);
    }

    void addCodeMarker(CodeMarkerImpl codeMarkerImpl) {
        this.codeMarkers.add(codeMarkerImpl);
    }

    void addOccurence(Occurence occurence) {
        ModelElement modelElement = occurence.getDeclaration();
        this.addOccurence(modelElement, occurence);
    }

    void addOccurence(ModelElement modelElement, Occurence occurence) {
        List<Occurence> list = this.occurences.get(modelElement);
        if (list == null) {
            list = new ArrayList<Occurence>();
            List<Occurence> list2 = this.occurences.put(modelElement, list);
            assert (list2 == null);
        }
        assert (occurence != null);
        list.add(occurence);
    }

    List<? extends CodeMarker> getMarkers() {
        return this.codeMarkers;
    }

    List<Occurence> getOccurences() {
        ArrayList<Occurence> arrayList = new ArrayList<Occurence>();
        Collection<List<Occurence>> collection = this.occurences.values();
        for (List<Occurence> list : collection) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    List<Occurence> getAllOccurences(ModelElement modelElement) {
        List<Occurence> list = this.occurences.get(modelElement);
        return list != null ? list : Collections.emptyList();
    }

    List<Occurence> getAllOccurences(Occurence occurence) {
        return this.getAllOccurences(occurence.getDeclaration());
    }

    @Override
    public IndexScope getIndexScope() {
        return ModelVisitor.getIndexScope(this.info);
    }

    @Override
    public Collection<? extends NamespaceScope> getDeclaredNamespaces() {
        return FileScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter<NamespaceScope>(){

            @Override
            public boolean isAccepted(ModelElement modelElement) {
                return modelElement.getPhpKind().equals((Object)PhpKind.NAMESPACE_DECLARATION);
            }
        });
    }

    @NonNull
    public CachingSupport getCachingSupport() {
        return this.cachedModelSupport;
    }

    @Override
    public NamespaceScope getDefaultDeclaredNamespace() {
        return ModelUtils.getFirst(ModelUtils.filter(this.getDeclaredNamespaces(), new ModelUtils.ElementFilter<NamespaceScope>(){

            @Override
            public boolean isAccepted(NamespaceScope namespaceScope) {
                return namespaceScope.isDefaultNamespace();
            }
        }));
    }
}

