/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.editor.codegen.CGSGenerator;
import org.netbeans.modules.php.editor.codegen.CGSInfo;
import org.netbeans.modules.php.editor.codegen.Property;
import org.netbeans.modules.php.editor.codegen.ui.CheckBoxTreeRenderer;
import org.netbeans.modules.php.editor.codegen.ui.CheckNode;
import org.netbeans.modules.php.editor.codegen.ui.NodeSelectionListener;
import org.openide.util.NbBundle;

public class ConstructorPanel
extends JPanel {
    private final String className;
    private final List<Property> properties;
    private final CGSInfo cgsInfo;
    private JCheckBox cbGenerateDoc;
    private JComboBox cbMethodGeneration;
    private JLabel jLabel1;
    private JLabel label;
    private JPanel pGSCustomize;
    private JScrollPane scrollPane;

    public ConstructorPanel(CGSGenerator.GenType genType, CGSInfo cGSInfo) {
        this.initComponents();
        this.className = cGSInfo.getClassName();
        switch (genType) {
            case CONSTRUCTOR: {
                this.properties = cGSInfo.getProperties();
                break;
            }
            case GETTER: {
                this.properties = cGSInfo.getPossibleGetters();
                break;
            }
            case SETTER: {
                this.properties = cGSInfo.getPossibleSetters();
                break;
            }
            default: {
                this.properties = cGSInfo.getPossibleGettersSetters();
            }
        }
        this.cgsInfo = cGSInfo;
        this.initPanel(genType);
        this.initTree();
    }

    private void initPanel(CGSGenerator.GenType genType) {
        String string = "";
        boolean bl = true;
        String string2 = "";
        if (this.properties.size() > 0) {
            string2 = this.properties.get(0).getName();
        }
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        switch (genType) {
            case CONSTRUCTOR: {
                string = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_CONSTRUCTOR");
                bl = false;
                break;
            }
            case GETTER: {
                string = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_GETTERS");
                for (CGSGenerator.GenWay genWay : CGSGenerator.GenWay.values()) {
                    defaultComboBoxModel.addElement(genWay.getGetterExample(string2));
                }
                break;
            }
            case SETTER: {
                string = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_SETTERS");
                for (CGSGenerator.GenWay genWay : CGSGenerator.GenWay.values()) {
                    defaultComboBoxModel.addElement(genWay.getSetterExample(string2));
                }
                break;
            }
            case GETTER_AND_SETTER: {
                string = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_GETTERS_AND_SETTERS");
                for (CGSGenerator.GenWay genWay : CGSGenerator.GenWay.values()) {
                    defaultComboBoxModel.addElement(genWay.getGetterExample(string2) + ", " + genWay.getSetterExample(string2));
                }
                break;
            }
        }
        this.label.setText(string);
        this.pGSCustomize.setVisible(bl);
        if (bl) {
            this.cbMethodGeneration.setModel(defaultComboBoxModel);
            int n = 0;
            if (this.cgsInfo.getHowToGenerate() != null) {
                for (CGSGenerator.GenWay genWay : CGSGenerator.GenWay.values()) {
                    if (genWay.equals((Object)this.cgsInfo.getHowToGenerate())) break;
                    ++n;
                }
            }
            this.cbMethodGeneration.setSelectedIndex(n);
        }
        this.cbGenerateDoc.setSelected(this.cgsInfo.isGenerateDoc());
        this.cbGenerateDoc.setVisible(false);
    }

    private void initTree() {
        CheckNode.CGSClassNode cGSClassNode = new CheckNode.CGSClassNode(this.className);
        JTree jTree = new JTree(cGSClassNode);
        for (Property property : this.properties) {
            cGSClassNode.add(new CheckNode.CGSPropertyNode(property));
        }
        jTree.setCellRenderer(new CheckBoxTreeRenderer());
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        NodeSelectionListener nodeSelectionListener = new NodeSelectionListener(jTree);
        jTree.addMouseListener(nodeSelectionListener);
        jTree.addKeyListener(nodeSelectionListener);
        jTree.expandRow(0);
        jTree.setShowsRootHandles(true);
        jTree.setSelectionRow(0);
        this.scrollPane.add(jTree);
        this.scrollPane.setViewportView(jTree);
    }

    private void initComponents() {
        this.label = new JLabel();
        this.scrollPane = new JScrollPane();
        this.pGSCustomize = new JPanel();
        this.jLabel1 = new JLabel();
        this.cbMethodGeneration = new JComboBox();
        this.cbGenerateDoc = new JCheckBox();
        this.label.setText(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.label.text"));
        this.jLabel1.setText(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.jLabel1.text"));
        this.cbMethodGeneration.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbMethodGeneration.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConstructorPanel.this.cbMethodGenerationActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.pGSCustomize);
        this.pGSCustomize.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1, -2, 105, -2).addPreferredGap(0).add((Component)this.cbMethodGeneration, 0, 247, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.cbMethodGeneration, -2, -1, -2)).add(65, 65, 65)));
        this.cbGenerateDoc.setText(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.cbGenerateDoc.text"));
        this.cbGenerateDoc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConstructorPanel.this.cbGenerateDocActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (Component)this.scrollPane, -1, 376, Short.MAX_VALUE).add(1, (Component)this.label).add(1, (Component)this.cbGenerateDoc, -1, 376, Short.MAX_VALUE).add(1, (Component)this.pGSCustomize, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.label).addPreferredGap(0).add((Component)this.scrollPane, -1, 226, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.pGSCustomize, -2, 45, -2).addPreferredGap(0).add((Component)this.cbGenerateDoc).addContainerGap()));
    }

    private void cbMethodGenerationActionPerformed(ActionEvent actionEvent) {
        int n = this.cbMethodGeneration.getSelectedIndex();
        this.cgsInfo.setHowToGenerate(CGSGenerator.GenWay.values()[n]);
    }

    private void cbGenerateDocActionPerformed(ActionEvent actionEvent) {
        this.cgsInfo.setGenerateDoc(this.cbGenerateDoc.isSelected());
    }
}

