/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.codegen.ASTNodeUtilities;
import org.netbeans.modules.php.editor.codegen.ui.TableGeneratorPanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class TableGenerator
implements CodeGenerator {
    private static final String HEADER_BEGIN = "echo '<table>';\necho '<tr>';\n";
    private static final String HEADER_LINE = "echo '<th>${COLUMN}</th>';\n";
    private static final String HEADER_END = "echo '</tr>';\n";
    private static final String CONN_BEGIN = "$$${RESULT newVarName default=\"result\"} = mysqli_query($$${CONN}, '${SQL}');\nwhile (($$${ROW newVarName default=\"row\"} = mysqli_fetch_array($$${RESULT}, MYSQLI_ASSOC)) != NULL) {\n   echo '<tr>';\n";
    private static final String CONN_LINE = "   echo '<td>' . $$${ROW}['${COLUMN}'] . '</td>';\n";
    private static final String CONN_END = "   echo '</tr>';\n}\nmysqli_free_result($$${RESULT});\necho '</table>';";
    private final JTextComponent component;

    public TableGenerator(JTextComponent jTextComponent) {
        this.component = jTextComponent;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(TableGenerator.class, (String)"LBL_DatabaseTable");
    }

    public void invoke() {
        TableGeneratorPanel.TableAndColumns tableAndColumns;
        String string = this.findConnVariableInScope();
        if (string == null) {
            string = "conn";
        }
        if ((tableAndColumns = TableGeneratorPanel.selectTableAndColumns(string)) == null) {
            return;
        }
        String string2 = this.generateTemplateText(tableAndColumns);
        CodeTemplateManager codeTemplateManager = CodeTemplateManager.get((Document)this.component.getDocument());
        CodeTemplate codeTemplate = codeTemplateManager.createTemporary(string2);
        codeTemplate.insert(this.component);
    }

    private String findConnVariableInScope() {
        final ArrayList arrayList = new ArrayList();
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)this.component.getDocument())), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    ParserResult parserResult = (ParserResult)resultIterator.getParserResult();
                    ASTNodeUtilities.getVariablesInScope(parserResult, TableGenerator.this.component.getCaretPosition(), new ASTNodeUtilities.VariableAcceptor(){

                        public boolean acceptVariable(String string) {
                            if (string.contains("conn")) {
                                arrayList.add(string);
                            }
                            return false;
                        }
                    });
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
            return null;
        }
        if (arrayList.contains("conn")) {
            return "conn";
        }
        if (arrayList.contains("connection")) {
            return "connection";
        }
        Iterator iterator = arrayList.iterator();
        if (iterator.hasNext()) {
            String string = (String)iterator.next();
            return string;
        }
        return null;
    }

    private String generateTemplateText(TableGeneratorPanel.TableAndColumns tableAndColumns) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(HEADER_BEGIN);
        List<String> list = tableAndColumns.getSelectedColumns().isEmpty() ? tableAndColumns.getAllColumns() : tableAndColumns.getSelectedColumns();
        for (String string : list) {
            stringBuilder.append(HEADER_LINE.replace("${COLUMN}", string));
        }
        stringBuilder.append(HEADER_END);
        stringBuilder.append(CONN_BEGIN.replace("${SQL}", this.generateSelect(tableAndColumns)).replace("${CONN}", tableAndColumns.getConnVariable()));
        for (String string : list) {
            stringBuilder.append(CONN_LINE.replace("${COLUMN}", string));
        }
        stringBuilder.append(CONN_END);
        return stringBuilder.toString();
    }

    private String generateSelect(TableGeneratorPanel.TableAndColumns tableAndColumns) {
        SQLIdentifiers.Quoter quoter = tableAndColumns.getIdentifierQuoter();
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        List<String> list = tableAndColumns.getSelectedColumns();
        if (list.isEmpty()) {
            stringBuilder.append(" * ");
        } else {
            int n = 0;
            for (String string : list) {
                stringBuilder.append(this.quoteIdentifier(quoter, string));
                if (n < list.size() - 1) {
                    stringBuilder.append(',');
                }
                ++n;
                stringBuilder.append(' ');
            }
        }
        stringBuilder.append("FROM ");
        stringBuilder.append(this.quoteIdentifier(quoter, tableAndColumns.getTable()));
        return stringBuilder.toString();
    }

    private String quoteIdentifier(SQLIdentifiers.Quoter quoter, String string) {
        return quoter.quoteIfNeeded(string).replace("'", "\\'");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup lookup) {
            JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
            return Collections.singletonList(new TableGenerator(jTextComponent));
        }
    }
}

