/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.util.TimestampType;
import org.openide.util.NbBundle;

public class DateType {
    public static final String DEFAULT_FOMAT_PATTERN = "yyyy-MM-dd";
    private static final DateFormat[] DATE_PARSING_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd"), DateFormat.getDateInstance(), DateFormat.getTimeInstance(3), DateFormat.getTimeInstance(3, TimestampType.LOCALE), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("MM-dd-yyyy")};

    public DateType() {
        for (int i = 0; i < DATE_PARSING_FORMATS.length; ++i) {
            DATE_PARSING_FORMATS[i].setLenient(false);
        }
    }

    public static java.sql.Date convert(Object object) throws DBException {
        Calendar calendar = Calendar.getInstance();
        if (null == object) {
            return null;
        }
        if (object instanceof Timestamp) {
            calendar.setTimeInMillis(((Timestamp)object).getTime());
        } else if (object instanceof Date) {
            calendar.setTimeInMillis(((Date)object).getTime());
        } else if (object instanceof String) {
            Date date = DateType.doParse((String)object);
            if (date == null) {
                throw new DBException(NbBundle.getMessage(DateType.class, (String)"MSG_failure_convert_date", (Object)object.getClass().getName(), (Object)object.toString()));
            }
            calendar.setTimeInMillis(date.getTime());
        } else {
            throw new DBException(NbBundle.getMessage(DateType.class, (String)"MSG_failure_convert_date", (Object)object.getClass().getName(), (Object)object.toString()));
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new java.sql.Date(calendar.getTimeInMillis());
    }

    private static synchronized Date doParse(String string) {
        Date date = null;
        for (DateFormat dateFormat : DATE_PARSING_FORMATS) {
            try {
                date = dateFormat.parse(string);
                break;
            }
            catch (ParseException parseException) {
                Logger.getLogger(DateType.class.getName()).log(Level.FINEST, parseException.getLocalizedMessage(), parseException);
            }
        }
        return date;
    }
}

