/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dataview;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ObjectStreamException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.ColumnNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.windows.TopComponent;

public class DataViewWindow
extends TopComponent {
    private JTextArea queryarea;
    private JTable jtable;
    private DataModel dbadaptor;
    private JComboBox rcmdscombo;
    private JLabel status;
    private JPopupMenu tablePopupMenu;
    private DatabaseConnection connection;
    static final long serialVersionUID = 6855188441469780252L;
    static int tstrg = 0;
    static int gtcmd = 0;

    public DataViewWindow(DatabaseConnection databaseConnection, String string) throws SQLException {
        this.connection = databaseConnection;
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewWindowA11yDesc"));
        String string2 = databaseConnection.getDisplayName();
        int n = string2.indexOf(" [");
        string2 = string2.substring(0, n);
        this.setName(string2);
        this.setToolTipText(NbBundle.getMessage(DataViewWindow.class, (String)"CommandEditorTitle") + " " + string2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.dbadaptor = new DataModel(databaseConnection);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints2.anchor = 15;
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(DataViewWindow.class, (String)"QueryLabel"));
        jLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewQueryLabelA11yDesc"));
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints2);
        jPanel.add(jLabel);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.gridy = 1;
        this.queryarea = new JTextArea(string, 3, 70);
        this.queryarea.setLineWrap(true);
        this.queryarea.setWrapStyleWord(true);
        this.queryarea.setDropTarget(new DropTarget(this.queryarea, new ViewDropTarget()));
        this.queryarea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewTextAreaA11yName"));
        this.queryarea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewTextAreaA11yDesc"));
        this.queryarea.setToolTipText(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewTextAreaA11yDesc"));
        jLabel.setLabelFor(this.queryarea);
        JScrollPane jScrollPane = new JScrollPane(this.queryarea);
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints2);
        jPanel.add(jScrollPane);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints2.anchor = 10;
        JLabel jLabel2 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)NbBundle.getMessage(DataViewWindow.class, (String)"HistoryLabel"));
        jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewHistoryLabelA11yDesc"));
        gridBagLayout2.setConstraints(jLabel2, gridBagConstraints2);
        jPanel.add(jLabel2);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints2.anchor = 15;
        this.rcmdscombo = new JComboBox(new ComboModel());
        this.rcmdscombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewComboBoxA11yName"));
        this.rcmdscombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewComboBoxA11yDesc"));
        this.rcmdscombo.setToolTipText(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewComboBoxA11yDesc"));
        jLabel2.setLabelFor(this.rcmdscombo);
        gridBagLayout2.setConstraints(this.rcmdscombo, gridBagConstraints2);
        jPanel.add(this.rcmdscombo);
        this.rcmdscombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                RecentCommand recentCommand = (RecentCommand)jComboBox.getSelectedItem();
                if (recentCommand != null) {
                    DataViewWindow.this.setCommand(recentCommand.getCommand());
                }
            }
        });
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 15;
        final JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(DataViewWindow.class, (String)"ExecuteButton"));
        jButton.setToolTipText(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_ExecuteButtonA11yDesc"));
        gridBagLayout2.setConstraints(jButton, gridBagConstraints2);
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton.setEnabled(false);
                RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

                    public void run() {
                        DataViewWindow.this.executeCommand();
                    }
                });
                task.addTaskListener(new TaskListener(){

                    public void taskFinished(Task task) {
                        jButton.setEnabled(true);
                    }
                });
                RequestProcessor.getDefault().post((Runnable)task, 0);
            }
        });
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints2.anchor = 15;
        this.status = new JLabel(" ");
        this.status.setBorder(new LineBorder(Color.gray));
        this.status.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewStatusLabelA11yDesc"));
        gridBagLayout2.setConstraints(this.status, gridBagConstraints2);
        jPanel.add(this.status);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout3);
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints3.anchor = 15;
        JLabel jLabel3 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)NbBundle.getMessage(DataViewWindow.class, (String)"ResultsLabel"));
        jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewResultsLabelA11yDesc"));
        gridBagLayout3.setConstraints(jLabel3, gridBagConstraints3);
        jPanel2.add(jLabel3);
        this.tablePopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(DataViewWindow.class, (String)"CopyCellValue"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = DataViewWindow.this.jtable.getValueAt(DataViewWindow.this.jtable.getSelectedRow(), DataViewWindow.this.jtable.getSelectedColumn());
                    String string = object != null ? object.toString() : "";
                    ExClipboard exClipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
                    StringSelection stringSelection = new StringSelection(string);
                    exClipboard.setContents((Transferable)stringSelection, (ClipboardOwner)stringSelection);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        this.tablePopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(NbBundle.getMessage(DataViewWindow.class, (String)"CopyRowValues"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int[] nArray;
                    int[] nArray2 = DataViewWindow.this.jtable.getSelectedRows();
                    if (DataViewWindow.this.jtable.getRowSelectionAllowed()) {
                        nArray = new int[DataViewWindow.this.jtable.getColumnCount()];
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = i;
                        }
                    } else {
                        nArray = DataViewWindow.this.jtable.getSelectedColumns();
                    }
                    if (nArray2 != null && nArray != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < nArray2.length; ++i) {
                            for (int j = 0; j < nArray.length; ++j) {
                                Object object;
                                if (j > 0) {
                                    stringBuffer.append('\t');
                                }
                                stringBuffer.append((object = DataViewWindow.this.jtable.getValueAt(nArray2[i], nArray[j])) != null ? object.toString() : "");
                            }
                            stringBuffer.append('\n');
                        }
                        ExClipboard exClipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
                        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
                        exClipboard.setContents((Transferable)stringSelection, (ClipboardOwner)stringSelection);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        this.tablePopupMenu.add(jMenuItem2);
        this.jtable = new JTable(this.dbadaptor);
        this.jtable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewTableA11yName"));
        this.jtable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewTableA11yDesc"));
        this.jtable.setToolTipText(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewTableA11yDesc"));
        this.jtable.setAutoResizeMode(0);
        this.jtable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    int n = DataViewWindow.this.jtable.rowAtPoint(mouseEvent.getPoint());
                    int n2 = DataViewWindow.this.jtable.columnAtPoint(mouseEvent.getPoint());
                    boolean bl = false;
                    int[] nArray = DataViewWindow.this.jtable.getSelectedRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] != n) continue;
                        bl = true;
                        break;
                    }
                    if (!DataViewWindow.this.jtable.getRowSelectionAllowed()) {
                        bl = false;
                        int[] nArray2 = DataViewWindow.this.jtable.getSelectedColumns();
                        for (int i = 0; i < nArray2.length; ++i) {
                            if (nArray2[i] != n2) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) {
                        DataViewWindow.this.jtable.changeSelection(n, n2, false, false);
                    }
                    DataViewWindow.this.tablePopupMenu.show(DataViewWindow.this.jtable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        jLabel3.setLabelFor(this.jtable);
        jScrollPane = new JScrollPane(this.jtable);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 1;
        gridBagLayout3.setConstraints(jScrollPane, gridBagConstraints3);
        jPanel2.add(jScrollPane);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, jPanel2);
        gridBagLayout.setConstraints(jSplitPane, gridBagConstraints);
        this.add(jSplitPane);
    }

    protected String preferredID() {
        return this.getName();
    }

    public int getPersistenceType() {
        return 2;
    }

    public String getCommand() {
        return this.queryarea.getText();
    }

    public void setCommand(String string) {
        this.queryarea.setText(string);
    }

    public boolean executeCommand() {
        boolean bl;
        String string = this.queryarea.getText().trim();
        try {
            this.dbadaptor.execute(string);
            RecentCommand recentCommand = new RecentCommand(string);
            ((ComboModel)this.rcmdscombo.getModel()).addElement(recentCommand);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            this.status.setText(NbBundle.getMessage(DataViewWindow.class, (String)"CommandFailed"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(NbBundle.getMessage(DataViewWindow.class, (String)"DataViewFetchErrorPrefix") + exception.getMessage()), 0));
        }
        return bl;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return null;
    }

    class DataModel
    extends AbstractTableModel {
        DatabaseConnection connection;
        Vector coldef = new Vector();
        Vector data = new Vector();
        boolean editable = false;
        static final long serialVersionUID = 7729426847826999963L;

        public DataModel(DatabaseConnection databaseConnection) throws SQLException {
            this.connection = databaseConnection;
        }

        public synchronized void execute(String string) throws Exception {
            Statement statement;
            if (string.length() == 0) {
                DataViewWindow.this.status.setText(" ");
                return;
            }
            DataViewWindow.this.status.setText(NbBundle.getMessage(DataViewWindow.class, (String)"CommandRunning"));
            try {
                Connection connection = this.connection.getConnection();
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                String string2 = NbBundle.getMessage(DataViewWindow.class, (String)"EXC_ConnectionError", (Object)exception.getMessage());
                throw new DatabaseException(string2);
            }
            if (string.toLowerCase().startsWith("select")) {
                Vector<Object> vector;
                int n;
                int n2;
                ResultSet resultSet = statement.executeQuery(string);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n3 = resultSetMetaData.getColumnCount();
                Vector<ColDef> vector2 = new Vector<ColDef>();
                Vector<Object> vector3 = new Vector<Object>();
                for (n2 = 1; n2 <= n3; ++n2) {
                    try {
                        n = resultSetMetaData.isWritable(n2) ? 1 : 0;
                    }
                    catch (SQLException sQLException) {
                        n = 0;
                    }
                    ColDef colDef = new ColDef(resultSetMetaData.getColumnLabel(n2), n != 0);
                    colDef.setDataType(resultSetMetaData.getColumnType(n2));
                    vector2.add(colDef);
                }
                n2 = 0;
                n = 100;
                int n4 = 200;
                String string3 = NbBundle.getMessage(DataViewWindow.class, (String)"DataViewCancelButton");
                String string4 = NbBundle.getMessage(DataViewWindow.class, (String)"DataViewNextFetchButton");
                String string5 = NbBundle.getMessage(DataViewWindow.class, (String)"DataViewAllFetchButton");
                JButton jButton = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)jButton, (String)string4);
                jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewNextFetchButtonA11yDesc"));
                JButton jButton2 = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)string5);
                jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewAllFetchButtonA11yDesc"));
                JButton jButton3 = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)jButton3, (String)string3);
                jButton3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataViewWindow.class, (String)"ACS_DataViewCancelButtonA11yDesc"));
                while (resultSet.next()) {
                    vector = new Vector(n3);
                    for (int i = 1; i <= n3; ++i) {
                        vector.add(resultSet.getObject(i));
                    }
                    vector3.addElement(vector);
                    if (++n2 < n) continue;
                    String string6 = NbBundle.getMessage(DataViewWindow.class, (String)"DataViewMessage", (Object)n2, (Object)n4);
                    NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string6, NbBundle.getMessage(DataViewWindow.class, (String)"FetchDataTitle"), 1, 3, new Object[]{jButton, jButton2, jButton3}, NotifyDescriptor.CANCEL_OPTION);
                    Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
                    if (jButton2.equals(object)) {
                        n = Integer.MAX_VALUE;
                        continue;
                    }
                    if (!jButton.equals(object)) break;
                    n += n4;
                }
                vector = vector3;
                final Vector<ColDef> vector4 = vector2;
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DataModel.this.data = vector;
                        DataModel.this.coldef = vector4;
                        DataModel.this.fireTableChanged(null);
                    }
                });
                resultSet.close();
            } else if (string.toLowerCase().startsWith("delete") || string.toLowerCase().startsWith("insert") || string.toLowerCase().startsWith("update")) {
                statement.executeUpdate(string);
            } else {
                statement.execute(string);
                this.connection.notifyChange();
            }
            DataViewWindow.this.status.setText(NbBundle.getMessage(DataViewWindow.class, (String)"CommandExecuted"));
            statement.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getColumnName(int n) {
            DataModel dataModel = this;
            synchronized (dataModel) {
                if (n < this.coldef.size()) {
                    String string = ((ColDef)this.coldef.elementAt(n)).getName();
                    return string;
                }
                return "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class getColumnClass(int n) {
            DataModel dataModel = this;
            synchronized (dataModel) {
                if (n < this.coldef.size()) {
                    int n2 = ((ColDef)this.coldef.elementAt(n)).getDataType();
                    switch (n2) {
                        case -1: 
                        case 1: 
                        case 12: {
                            return String.class;
                        }
                        case -7: {
                            return Boolean.class;
                        }
                        case -6: 
                        case 4: 
                        case 5: {
                            return Integer.class;
                        }
                        case -5: {
                            return Long.class;
                        }
                        case 6: 
                        case 8: {
                            return Double.class;
                        }
                        case 91: {
                            return Date.class;
                        }
                    }
                }
                return Object.class;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCellEditable(int n, int n2) {
            DataModel dataModel = this;
            synchronized (dataModel) {
                if (!this.editable) {
                    return false;
                }
                if (n2 < this.coldef.size()) {
                    return ((ColDef)this.coldef.elementAt(n2)).isWritable();
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getColumnCount() {
            DataModel dataModel = this;
            synchronized (dataModel) {
                return this.coldef.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            DataModel dataModel = this;
            synchronized (dataModel) {
                return this.data.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueAt(int n, int n2) {
            DataModel dataModel = this;
            synchronized (dataModel) {
                Vector vector = new Vector();
                if (n < this.data.size()) {
                    vector = (Vector)this.data.elementAt(n);
                }
                if (vector != null && n2 < vector.size()) {
                    return vector.elementAt(n2);
                }
                return null;
            }
        }

        private String format(Object object, int n) {
            if (object == null) {
                return "null";
            }
            switch (n) {
                case 4: 
                case 6: 
                case 8: {
                    return object.toString();
                }
                case -7: {
                    return (Boolean)object != false ? "1" : "0";
                }
                case 91: {
                    return object.toString();
                }
            }
            return "\"" + object.toString() + "\"";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValueAt(Object object, int n, int n2) {
            DataModel dataModel = this;
            synchronized (dataModel) {
                int n3 = 0;
                StringBuffer stringBuffer = new StringBuffer();
                Enumeration enumeration = this.coldef.elements();
                while (enumeration.hasMoreElements()) {
                    ColDef colDef = (ColDef)enumeration.nextElement();
                    if (colDef.isBestRowIdentifierColumn()) {
                        String string = colDef.getName();
                        String string2 = this.format(this.getValueAt(n, n3), colDef.getDataType());
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(" and ");
                        }
                        stringBuffer.append(string + " = " + string2);
                    }
                    ++n3;
                }
            }
        }
    }

    class ViewDropTarget
    implements DropTargetListener {
        ViewDropTarget() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        private ColumnNode getNode(Transferable transferable) {
            Node node = NodeTransfer.node((Transferable)transferable, (int)6);
            if (node != null) {
                return (ColumnNode)node;
            }
            node = NodeTransfer.node((Transferable)transferable, (int)1);
            if (node != null) {
                return (ColumnNode)node;
            }
            return null;
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            String string = null;
            Transferable transferable = dropTargetDropEvent.getTransferable();
            StringBuffer stringBuffer = new StringBuffer();
            try {
                DataFlavor dataFlavor = new DataFlavor("application/x-java-openide-multinode;class=org.openide.util.datatransfer.MultiTransferObject", NbBundle.getMessage(DataViewWindow.class, (String)"transferFlavorsMultiFlavorName"), MultiTransferObject.class.getClassLoader());
                if (transferable.isDataFlavorSupported(dataFlavor)) {
                    MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                    int n = multiTransferObject.getCount();
                    int n2 = 0;
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    for (int i = 0; i < n; ++i) {
                        ColumnNode columnNode = this.getNode(multiTransferObject.getTransferableAt(i));
                        if (columnNode == null) continue;
                        String string2 = columnNode.getParentName();
                        Integer n3 = (Integer)hashMap.get(string2);
                        if (n3 == null) {
                            n3 = new Integer(n2++);
                            hashMap.put(string2, n3);
                        }
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append("t" + n3 + "." + columnNode.getName());
                    }
                    StringBuffer stringBuffer2 = new StringBuffer();
                    for (String string2 : hashMap.keySet()) {
                        if (stringBuffer2.length() > 0) {
                            stringBuffer2.append(", ");
                        }
                        stringBuffer2.append(string2 + " t" + hashMap.get(string2));
                    }
                    string = "select " + stringBuffer.toString() + " from " + stringBuffer2.toString();
                } else {
                    ColumnNode columnNode = this.getNode(transferable);
                    if (columnNode != null) {
                        string = "select " + columnNode.getName() + " from " + columnNode.getParentName();
                    }
                }
                if (string != null) {
                    DataViewWindow.this.setCommand(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComboModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        Vector<Object> commands;
        Object selected;
        static final long serialVersionUID = -5831993904798984334L;

        public ComboModel() {
            this(new Vector<Object>(1));
        }

        public ComboModel(Vector<Object> vector) {
            this.commands = vector;
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public void setSelectedItem(Object object) {
            this.selected = object;
            this.fireContentsChanged(this, -1, -1);
        }

        public void addElement(Object object) {
            if (!this.commands.contains(object)) {
                this.commands.add(object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void removeElement(Object object) {
            this.commands.removeElement(object);
            this.fireContentsChanged(this, -1, -1);
        }

        public void insertElementAt(Object object, int n) {
            if (!this.commands.contains(object)) {
                this.commands.insertElementAt(object, n);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void removeElementAt(int n) {
            this.commands.removeElementAt(n);
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public int getSize() {
            return this.commands.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.commands.get(n);
        }
    }

    class RecentCommand {
        private String command;
        private String shortCommand;

        public RecentCommand(String string) {
            this.command = string;
            this.shortCommand = this.getShortCommand();
        }

        public String toString() {
            return this.shortCommand;
        }

        public String getCommand() {
            return this.command;
        }

        public boolean equals(Object object) {
            if (object instanceof RecentCommand) {
                return ((RecentCommand)object).getShortCommand().equals(this.shortCommand);
            }
            return super.equals(object);
        }

        public int hashCode() {
            int n = 7;
            n = 17 * n + (this.shortCommand != null ? this.shortCommand.hashCode() : 0);
            return n;
        }

        private String getShortCommand() {
            StringTokenizer stringTokenizer = new StringTokenizer(this.command);
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreElements()) {
                stringBuffer.append(stringTokenizer.nextElement());
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
    }

    class ColDef {
        private String name;
        private boolean writable;
        private boolean bric;
        int datatype;

        public ColDef(String string, boolean bl) {
            this.name = string;
            this.writable = bl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public int getDataType() {
            return this.datatype;
        }

        public void setDataType(int n) {
            this.datatype = n;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public void setWritable(boolean bl) {
            this.writable = bl;
        }

        public boolean isBestRowIdentifierColumn() {
            return this.bric;
        }

        public void setBestRowIdentifierColumn(boolean bl) {
            this.bric = bl;
        }
    }
}

