/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;

public class SortedListModel
extends AbstractListModel {
    public static final Comparator DEFAULT_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            return object.toString().compareTo(object2.toString());
        }

        public boolean equals(Object object) {
            return object == this;
        }
    };
    private List elements;
    private Comparator comp = DEFAULT_COMPARATOR;

    public SortedListModel() {
        this.elements = new ArrayList();
    }

    public SortedListModel(Collection collection) {
        this.elements = new ArrayList(collection);
        Collections.sort(this.elements, this.comp);
    }

    public SortedListModel(int n) {
        this.elements = new ArrayList(n);
    }

    public int getSize() {
        return this.elements.size();
    }

    public Object getElementAt(int n) {
        return this.elements.get(n);
    }

    public Comparator getComparator() {
        return this.comp;
    }

    public void setComparator(Comparator comparator) {
        if (this.comp == comparator) {
            return;
        }
        this.comp = comparator;
        Collections.sort(this.elements, this.comp);
        int n = this.elements.size() - 1;
        if (n >= 0) {
            super.fireContentsChanged(this, 0, n);
        }
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public boolean contains(Object object) {
        return Collections.binarySearch(this.elements, object, this.getComparator()) >= 0;
    }

    public Object[] toArray() {
        return this.elements.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.elements.toArray(objectArray);
    }

    public int add(Object object) {
        int n = Collections.binarySearch(this.elements, object, this.getComparator());
        if (n < 0) {
            n = -n - 1;
        }
        this.elements.add(n, object);
        this.fireIntervalAdded(this, n, n);
        return n;
    }

    public int indexOf(Object object) {
        return Collections.binarySearch(this.elements, object, this.getComparator());
    }

    public int remove(Object object) {
        int n = Collections.binarySearch(this.elements, object, this.getComparator());
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    public boolean remove(int n) {
        this.elements.remove(n);
        this.fireIntervalRemoved(this, n, n);
        return true;
    }

    public void clear() {
        int n = this.elements.size() - 1;
        if (n >= 0) {
            this.elements.clear();
            this.fireIntervalRemoved(this, 0, n);
        }
    }

    public String toString() {
        return this.elements.toString();
    }
}

