/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.project.ant.ProjectLibraryProvider;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.util.WeakListeners;

final class SharabilityQueryImpl
implements SharabilityQueryImplementation,
PropertyChangeListener,
AntProjectListener {
    private final AntProjectHelper h;
    private final PropertyEvaluator eval;
    private final String[] includes;
    private final String[] excludes;
    private String[] includePaths;
    private String[] excludePaths;

    SharabilityQueryImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, String[] stringArray, String[] stringArray2) {
        this.h = antProjectHelper;
        this.eval = propertyEvaluator;
        this.includes = stringArray;
        this.excludes = stringArray2;
        this.computeFiles();
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
        antProjectHelper.addAntProjectListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeFiles() {
        String[] stringArray = this.computeFrom(this.includes, false);
        String[] stringArray2 = this.computeFrom(this.excludes, true);
        SharabilityQueryImpl sharabilityQueryImpl = this;
        synchronized (sharabilityQueryImpl) {
            this.includePaths = stringArray;
            this.excludePaths = stringArray2;
        }
    }

    private String[] computeFrom(String[] stringArray, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            String string2 = this.eval.evaluate(string);
            if (string2 == null) continue;
            File file = this.h.resolveFile(string2);
            arrayList.add(file.getAbsolutePath());
        }
        if (bl) {
            arrayList.addAll(ProjectLibraryProvider.getUnsharablePathsWithinProject(this.h));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public synchronized int getSharability(File file) {
        String string = file.getAbsolutePath();
        if (SharabilityQueryImpl.contains(string, this.excludePaths, false)) {
            return 2;
        }
        return SharabilityQueryImpl.contains(string, this.includePaths, false) ? (SharabilityQueryImpl.contains(string, this.excludePaths, true) ? 3 : 1) : 0;
    }

    private static boolean contains(String string, String[] stringArray, boolean bl) {
        for (String string2 : stringArray) {
            if (string.equals(string2)) {
                return true;
            }
            if (!(bl ? string2.startsWith(string + File.separatorChar) : string.startsWith(string2 + File.separatorChar))) continue;
            return true;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.computeFiles();
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        this.computeFiles();
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
    }
}

