/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros.storage.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.modules.editor.macros.storage.ui.MacrosModel;
import org.netbeans.modules.editor.macros.storage.ui.MacrosNamePanel;
import org.netbeans.modules.editor.macros.storage.ui.TableSorter;
import org.netbeans.modules.editor.settings.storage.spi.support.StorageSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MacrosPanel
extends JPanel {
    private final MacrosModel model = MacrosModel.get();
    private JButton bNew;
    private JButton bRemove;
    private JButton bSetShortcut;
    private JEditorPane epMacroCode;
    private JLabel lMacroCode;
    private JLabel lMacros;
    private JScrollPane sMacroCode;
    private JScrollPane spMacros;
    private JTable tMacros;

    public MacrosPanel(Lookup lookup) {
        this.initComponents();
        this.tMacros.getAccessibleContext().setAccessibleName(MacrosPanel.loc("AN_Macros_Table"));
        this.tMacros.getAccessibleContext().setAccessibleDescription(MacrosPanel.loc("AD_Macros_Table"));
        this.epMacroCode.getAccessibleContext().setAccessibleName(MacrosPanel.loc("AN_Macro"));
        this.epMacroCode.getAccessibleContext().setAccessibleDescription(MacrosPanel.loc("AD_Macro"));
        this.bRemove.setEnabled(false);
        this.bSetShortcut.setEnabled(false);
        MacrosPanel.loc(this.bNew, "New_Macro");
        MacrosPanel.loc(this.bRemove, "Remove_Macro");
        MacrosPanel.loc(this.bSetShortcut, "Shortcut");
        this.tMacros.getSelectionModel().setSelectionMode(0);
        this.tMacros.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MacrosPanel.this.tMacrosValueChanged(listSelectionEvent);
            }
        });
        this.tMacros.getTableHeader().setReorderingAllowed(false);
        TableSorter tableSorter = new TableSorter(this.model.getTableModel());
        this.tMacros.setModel(tableSorter);
        tableSorter.setTableHeader(this.tMacros.getTableHeader());
        tableSorter.getTableHeader().setReorderingAllowed(false);
        this.tMacros.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                MacrosPanel.this.tMacrosTableChanged(tableModelEvent);
            }
        });
        this.tMacros.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode()) {
                    MacrosPanel.this.epMacroCode.requestFocusInWindow();
                    keyEvent.consume();
                }
            }
        });
        this.epMacroCode.setEnabled(false);
        this.epMacroCode.setEditorKit(JEditorPane.createEditorKitForContentType("text/plain"));
        this.epMacroCode.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                MacrosPanel.this.epMacroCodeDocumentChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MacrosPanel.this.epMacroCodeDocumentChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        MacrosPanel.loc(this.lMacros, "Macro_List");
        this.lMacros.setLabelFor(this.tMacros);
        MacrosPanel.loc(this.lMacroCode, "Macro_Code");
        this.lMacroCode.setLabelFor(this.epMacroCode);
    }

    public MacrosModel getModel() {
        return this.model;
    }

    public void forceAddMacro(String string) {
        MacrosModel.Macro macro = this.addMacro();
        if (macro != null) {
            macro.setCode(string);
        }
    }

    private void initComponents() {
        this.lMacros = new JLabel();
        this.spMacros = new JScrollPane();
        this.tMacros = new JTable();
        this.bNew = new JButton();
        this.bSetShortcut = new JButton();
        this.bRemove = new JButton();
        this.lMacroCode = new JLabel();
        this.sMacroCode = new JScrollPane();
        this.epMacroCode = new JEditorPane();
        this.lMacros.setText("Macros:");
        this.tMacros.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.spMacros.setViewportView(this.tMacros);
        this.bNew.setText("New");
        this.bNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacrosPanel.this.bNewActionPerformed(actionEvent);
            }
        });
        this.bSetShortcut.setText("Set Shortcut...");
        this.bSetShortcut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacrosPanel.this.bSetShortcutActionPerformed(actionEvent);
            }
        });
        this.bRemove.setText("Remove");
        this.bRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacrosPanel.this.bRemoveActionPerformed(actionEvent);
            }
        });
        this.lMacroCode.setText("Macro Code:");
        this.sMacroCode.setViewportView(this.epMacroCode);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lMacros).add((Component)this.lMacroCode).add((Component)this.spMacros, -1, 352, Short.MAX_VALUE).add((Component)this.sMacroCode, -1, 352, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((Component)this.bNew, -1, 128, Short.MAX_VALUE).add((Component)this.bSetShortcut, -1, -1, Short.MAX_VALUE).add(1, (Component)this.bRemove, -1, -1, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lMacros).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.bNew).addPreferredGap(0).add((Component)this.bSetShortcut).addPreferredGap(0).add((Component)this.bRemove).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.spMacros, -2, 113, -2).addPreferredGap(0).add((Component)this.lMacroCode).addPreferredGap(0).add((Component)this.sMacroCode, -1, 147, Short.MAX_VALUE)))));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MacrosPanel.class, (String)"AN_MacrosPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MacrosPanel.class, (String)"AD_MacrosPanel"));
    }

    private void bNewActionPerformed(ActionEvent actionEvent) {
        this.addMacro();
    }

    private void bSetShortcutActionPerformed(ActionEvent actionEvent) {
        ShortcutsFinder shortcutsFinder = (ShortcutsFinder)Lookup.getDefault().lookup(ShortcutsFinder.class);
        assert (shortcutsFinder != null) : "Can't find ShortcutsFinder";
        int n = this.tMacros.getSelectedRow();
        shortcutsFinder.refreshActions();
        String string = shortcutsFinder.showShortcutsDialog();
        ShortcutAction shortcutAction = shortcutsFinder.findActionForShortcut(string);
        List<MacrosModel.Macro> list = this.model.getAllMacros();
        for (MacrosModel.Macro object2 : list) {
            String string2;
            if (object2.getShortcuts().size() <= 0 || !(string2 = StorageSupport.keyStrokesToString((Collection)object2.getShortcuts().get(0).getKeyStrokeList(), (boolean)false)).equals(string)) continue;
            object2.setShortcuts(Collections.<String>emptySet());
        }
        if (shortcutAction != null) {
            Set<String> set = Collections.emptySet();
            if (shortcutAction instanceof MacrosModel.Macro) {
                ((MacrosModel.Macro)shortcutAction).setShortcuts(set);
            }
            shortcutsFinder.setShortcuts(shortcutAction, set);
        }
        if (string != null) {
            MacrosModel.Macro macro = this.model.getMacroByIndex(n);
            macro.setShortcut(string);
            shortcutsFinder.setShortcuts((ShortcutAction)macro, Collections.singleton(string));
        }
    }

    private void bRemoveActionPerformed(ActionEvent actionEvent) {
        ShortcutsFinder shortcutsFinder = (ShortcutsFinder)Lookup.getDefault().lookup(ShortcutsFinder.class);
        shortcutsFinder.setShortcuts((ShortcutAction)this.model.getMacroByIndex(this.tMacros.getSelectedRow()), Collections.emptySet());
        this.model.deleteMacro(this.tMacros.getSelectedRow());
    }

    private void tMacrosValueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.tMacros.getSelectedRow();
        if (n < 0 || n >= this.tMacros.getRowCount()) {
            this.epMacroCode.setText("");
            this.epMacroCode.setEnabled(false);
            this.bRemove.setEnabled(false);
            this.bSetShortcut.setEnabled(false);
        } else {
            this.epMacroCode.setText(this.model.getMacroByIndex(n).getCode());
            this.epMacroCode.getCaret().setDot(0);
            this.epMacroCode.setEnabled(true);
            this.bRemove.setEnabled(true);
            this.bSetShortcut.setEnabled(true);
        }
    }

    private void tMacrosTableChanged(final TableModelEvent tableModelEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (tableModelEvent.getType() == 1) {
                    MacrosPanel.this.tMacros.getSelectionModel().setSelectionInterval(tableModelEvent.getFirstRow(), tableModelEvent.getFirstRow());
                } else if (tableModelEvent.getType() == -1) {
                    int n = tableModelEvent.getLastRow();
                    if (n < MacrosPanel.this.tMacros.getModel().getRowCount()) {
                        MacrosPanel.this.tMacros.getSelectionModel().setSelectionInterval(n, n);
                    } else {
                        n = tableModelEvent.getFirstRow() - 1;
                        if (n >= 0) {
                            MacrosPanel.this.tMacros.getSelectionModel().setSelectionInterval(n, n);
                        } else {
                            MacrosPanel.this.tMacros.getSelectionModel().clearSelection();
                        }
                    }
                }
            }
        });
    }

    private void epMacroCodeDocumentChanged() {
        int n = this.tMacros.getSelectedRow();
        if (n >= 0) {
            this.model.getMacroByIndex(n).setCode(this.epMacroCode.getText());
        }
    }

    private static String loc(String string) {
        return NbBundle.getMessage(MacrosPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(MacrosPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(MacrosPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)MacrosPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)MacrosPanel.loc("CTL_" + string));
        }
    }

    private MacrosModel.Macro addMacro() {
        final MacrosNamePanel macrosNamePanel = new MacrosNamePanel();
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)macrosNamePanel, MacrosPanel.loc("CTL_New_macro_dialog_title"));
        macrosNamePanel.setChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                String string = macrosNamePanel.getNameValue().trim();
                String string2 = MacrosPanel.this.model.validateMacroName(string);
                dialogDescriptor.setValid(string2 == null);
                macrosNamePanel.setErrorMessage(string2);
            }
        });
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == DialogDescriptor.OK_OPTION) {
            String string = macrosNamePanel.getNameValue().trim();
            return this.model.createMacro(MimePath.EMPTY, string);
        }
        return null;
    }
}

