/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.gsf.testrunner.api.DiffViewAction;
import org.netbeans.modules.gsf.testrunner.api.Locator;
import org.netbeans.modules.gsf.testrunner.api.TestMethodNode;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.ruby.RubyDeclarationFinder;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.testrunner.ui.BaseTestMethodNodeAction;
import org.netbeans.modules.ruby.testrunner.ui.JumpToCallStackAction;
import org.netbeans.modules.ruby.testrunner.ui.JumpToTestAction;
import org.netbeans.modules.ruby.testrunner.ui.RunTestMethodAction;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyTestMethodNode
extends TestMethodNode {
    private static final Logger LOGGER = Logger.getLogger(RubyTestMethodNode.class.getName());
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private FutureTask<String> stackTraceLocationHolder;

    public RubyTestMethodNode(Testcase testcase, Project project) {
        super(testcase, project, Lookups.singleton((Object)new Locator(){

            public void jumpToSource(Node node) {
                node.getPreferredAction().actionPerformed(null);
            }
        }));
    }

    public Action getPreferredAction() {
        if (this.stackTraceLocationHolder == null) {
            this.stackTraceLocationHolder = this.getTestCaseLineFromStackTrace(this.testcase);
        }
        String string = this.testcase.getLocation();
        String string2 = null;
        try {
            string2 = this.stackTraceLocationHolder.get(300L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            LOGGER.log(Level.INFO, null, executionException);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        String string3 = string2 != null ? string2 : string;
        return string3 == null ? new JumpToTestAction(this.testcase, this.project, NbBundle.getMessage(RubyTestMethodNode.class, (String)"LBL_GoToSource"), false) : new JumpToCallStackAction((Node)this, string3);
    }

    private FutureTask<String> getTestCaseLineFromStackTrace(final Testcase testcase) {
        FutureTask<String> futureTask = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String string;
                Thread.sleep(9000L);
                if (testcase.getTrouble() == null) {
                    return null;
                }
                String[] stringArray = testcase.getTrouble().getStackTrace();
                if (stringArray == null || stringArray.length <= 1) {
                    return null;
                }
                if (stringArray.length > 2 && (string = RubyTestMethodNode.findLocationLine(stringArray, testcase.getName(), RubyTestMethodNode.this.getFileName(testcase))) != null) {
                    return string;
                }
                return stringArray[1];
            }
        });
        EXECUTOR.execute(futureTask);
        return futureTask;
    }

    static final String findLocationLine(String[] stringArray, String string, String string2) {
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].contains(string2)) continue;
            if (stringArray[i].contains(string)) {
                string3 = stringArray[i];
                break;
            }
            if (string3 != null) continue;
            string3 = stringArray[i];
        }
        if (string3 != null) {
            return string3;
        }
        return null;
    }

    private String getFileName(Testcase testcase) {
        String string;
        FileObject fileObject = BaseTestMethodNodeAction.getTestSourceRoot(this.project);
        DeclarationFinder.DeclarationLocation declarationLocation = RubyDeclarationFinder.getTestDeclaration((FileObject)fileObject, (String)(string = BaseTestMethodNodeAction.getTestMethod(testcase)), (boolean)true, (boolean)true);
        FileObject fileObject2 = declarationLocation.getFileObject();
        if (fileObject2 != null) {
            return fileObject2.getNameExt();
        }
        return RubyUtils.camelToUnderlinedName((String)testcase.getClassName());
    }

    public Action[] getActions(boolean bl) {
        if (bl) {
            return new Action[0];
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.getPreferredAction());
        arrayList.add((Object)new RunTestMethodAction(this.testcase, this.project, NbBundle.getMessage(RubyTestMethodNode.class, (String)"LBL_RerunTest"), false));
        arrayList.add((Object)new RunTestMethodAction(this.testcase, this.project, NbBundle.getMessage(RubyTestMethodNode.class, (String)"LBL_DebugTest"), true));
        arrayList.add(new DiffViewAction(this.testcase));
        return arrayList.toArray(new Action[arrayList.size()]);
    }
}

