/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.APTCommentToken;
import org.netbeans.modules.cnd.apt.impl.support.APTConstTextToken;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroParamExpansion;
import org.netbeans.modules.cnd.apt.impl.support.APTTestToken;
import org.netbeans.modules.cnd.apt.impl.support.MacroExpandedToken;
import org.netbeans.modules.cnd.apt.impl.support.lang.APTBaseLanguageFilter;
import org.netbeans.modules.cnd.apt.support.APTBaseToken;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenAbstact;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTUtils {
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.cnd.apt");
    public static final APTToken VA_ARGS_TOKEN;
    public static final APTToken EMPTY_ID_TOKEN;
    public static final APTToken COMMA_TOKEN;
    public static final List<APTToken> DEF_MACRO_BODY;
    public static final APTToken EOF_TOKEN;
    public static final TokenStream EMPTY_STREAM;

    private APTUtils() {
    }

    public static int hash(int n) {
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    public static int hash(List<?> list) {
        if (list == null) {
            return 0;
        }
        int n = 1;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Object obj = list.get(i);
            n = 31 * n + (obj == null ? 0 : obj.hashCode());
        }
        return APTUtils.hash(n);
    }

    public static boolean equalArrayLists(List<?> list, List<?> list2) {
        if (list != list2) {
            int n;
            if (list == null || list2 == null) {
                return false;
            }
            int n2 = list.size();
            if (n2 != (n = list2.size())) {
                return false;
            }
            for (int i = 0; i < n2; ++i) {
                if (list.get(i).equals(list2.get(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static void setTokenText(APTToken aPTToken, char[] cArray, int n, int n2) {
        if (aPTToken instanceof APTBaseToken) {
            aPTToken.setTextID(CharSequenceKey.create((char[])cArray, (int)n, (int)n2));
        } else if (aPTToken instanceof APTCommentToken) {
            ((APTCommentToken)aPTToken).setTextLength(n2);
        } else if (!(aPTToken instanceof APTConstTextToken)) {
            System.err.printf("unexpected token %s while assigning text %s", aPTToken, new String(cArray, n, n2));
            aPTToken.setText(new String(cArray, n, n2));
        }
    }

    public static APTToken createAPTToken(int n) {
        if (APTUtils.isPreprocessorToken(n)) {
            return APTTraceFlags.USE_APT_TEST_TOKEN ? new APTTestToken() : new APTBaseToken();
        }
        switch (n) {
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 192: 
            case 193: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 236: {
                return APTTraceFlags.USE_APT_TEST_TOKEN ? new APTTestToken() : new APTBaseToken();
            }
            case 220: 
            case 221: {
                return new APTCommentToken();
            }
        }
        return new APTConstTextToken();
    }

    public static APTToken getLastToken(TokenStream tokenStream) {
        APTToken aPTToken = null;
        try {
            APTToken aPTToken2 = (APTToken)tokenStream.nextToken();
            while (!APTUtils.isEOF(aPTToken2)) {
                assert (aPTToken2 != null) : "list of tokens must not have 'null' elements";
                aPTToken = aPTToken2;
                aPTToken2 = (APTToken)tokenStream.nextToken();
            }
        }
        catch (TokenStreamException tokenStreamException) {
            // empty catch block
        }
        return aPTToken;
    }

    public static String debugString(TokenStream tokenStream) {
        return APTUtils.stringize(tokenStream, false);
    }

    public static String toString(TokenStream tokenStream) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Token token = tokenStream.nextToken();
            while (!APTUtils.isEOF(token)) {
                assert (token != null) : "list of tokens must not have 'null' elements";
                stringBuilder.append(token.toString());
                token = tokenStream.nextToken();
                if (APTUtils.isEOF(token)) continue;
                stringBuilder.append(" ");
            }
        }
        catch (TokenStreamException tokenStreamException) {
            LOG.log(Level.SEVERE, "error on converting token stream to text\n{0}", new Object[]{tokenStreamException});
        }
        return stringBuilder.toString();
    }

    public static String stringize(TokenStream tokenStream, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            APTToken aPTToken = (APTToken)tokenStream.nextToken();
            while (!APTUtils.isEOF(aPTToken)) {
                assert (aPTToken != null) : "list of tokens must not have 'null' elements";
                stringBuilder.append(aPTToken.getTextID());
                APTToken aPTToken2 = (APTToken)tokenStream.nextToken();
                if (!APTUtils.isEOF(aPTToken2) && !bl) {
                    stringBuilder.append(aPTToken2.getOffset() == aPTToken.getEndOffset() ? "" : Character.valueOf(' '));
                }
                aPTToken = aPTToken2;
            }
        }
        catch (TokenStreamException tokenStreamException) {
            LOG.log(Level.SEVERE, "error on stringizing token stream\n{0}", new Object[]{tokenStreamException});
        }
        return stringBuilder.toString();
    }

    public static String macros2String(Map<CharSequence, APTMacro> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MACROS (sorted " + map.size() + "):\n");
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(map.keySet());
        Collections.sort(arrayList, CharSequenceKey.Comparator);
        for (CharSequence charSequence : arrayList) {
            APTMacro aPTMacro = map.get(charSequence);
            assert (aPTMacro != null);
            stringBuilder.append(aPTMacro);
            stringBuilder.append("'\n");
        }
        return stringBuilder.toString();
    }

    public static CharSequence includes2String(List<IncludeDirEntry> list) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<IncludeDirEntry> iterator = list.iterator();
        while (iterator.hasNext()) {
            IncludeDirEntry includeDirEntry = iterator.next();
            stringBuilder.append(includeDirEntry.getAsSharedCharSequence());
            if (!iterator.hasNext()) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder;
    }

    public static boolean isPreprocessorToken(Token token) {
        assert (token != null);
        return APTUtils.isPreprocessorToken(token.getType());
    }

    public static boolean isPreprocessorToken(int n) {
        switch (n) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static boolean isID(Token token) {
        return token != null && token.getType() == 205;
    }

    public static boolean isInt(Token token) {
        if (token != null) {
            switch (token.getType()) {
                case 7: 
                case 9: 
                case 10: 
                case 206: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isEOF(Token token) {
        assert (token != null);
        return token == null || APTUtils.isEOF(token.getType());
    }

    public static boolean isEOF(int n) {
        return n == 1;
    }

    public static boolean isVaArgsToken(APTToken aPTToken) {
        return aPTToken != null && aPTToken.getTextID().equals(VA_ARGS_TOKEN.getTextID());
    }

    public static boolean isStartConditionNode(int n) {
        switch (n) {
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStartOrSwitchConditionNode(int n) {
        switch (n) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public static boolean isEndCondition(Token token) {
        return APTUtils.isEndCondition(token.getType());
    }

    public static boolean isEndCondition(int n) {
        switch (n) {
            case 18: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public static boolean isEndConditionNode(int n) {
        switch (n) {
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCommentToken(Token token) {
        assert (token != null);
        return APTUtils.isCommentToken(token.getType());
    }

    public static boolean isCommentToken(int n) {
        switch (n) {
            case 220: 
            case 221: {
                return true;
            }
        }
        return false;
    }

    public static boolean isOpenBracket(Token token) {
        assert (token != null);
        return APTUtils.isOpenBracket(token.getType());
    }

    public static boolean isOpenBracket(int n) {
        switch (n) {
            case 138: 
            case 140: 
            case 142: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCloseBracket(Token token) {
        assert (token != null);
        return APTUtils.isCloseBracket(token.getType());
    }

    public static boolean isCloseBracket(int n) {
        switch (n) {
            case 139: 
            case 141: 
            case 143: {
                return true;
            }
        }
        return false;
    }

    public static int getMatchBracket(int n) {
        switch (n) {
            case 143: {
                return 142;
            }
            case 139: {
                return 138;
            }
            case 141: {
                return 140;
            }
            case 142: {
                return 143;
            }
            case 138: {
                return 139;
            }
            case 140: {
                return 141;
            }
        }
        return 1;
    }

    public static boolean isEndDirectiveToken(int n) {
        switch (n) {
            case 1: 
            case 209: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMacroExpandedToken(Token token) {
        if (token instanceof MacroExpandedToken) {
            return true;
        }
        if (token instanceof APTBaseLanguageFilter.FilterToken) {
            return APTUtils.isMacroExpandedToken(((APTBaseLanguageFilter.FilterToken)token).getOriginalToken());
        }
        return false;
    }

    public static boolean isMacroParamExpandedToken(Token token) {
        if (token instanceof APTMacroParamExpansion) {
            return true;
        }
        if (token instanceof MacroExpandedToken) {
            return APTUtils.isMacroParamExpandedToken(((MacroExpandedToken)token).getTo());
        }
        if (token instanceof APTBaseLanguageFilter.FilterToken) {
            return APTUtils.isMacroParamExpandedToken(((APTBaseLanguageFilter.FilterToken)token).getOriginalToken());
        }
        return false;
    }

    public static APTToken getExpandedToken(APTToken aPTToken) {
        if (aPTToken instanceof APTMacroParamExpansion) {
            return APTUtils.getExpandedToken(((APTMacroParamExpansion)aPTToken).getOriginal());
        }
        if (aPTToken instanceof MacroExpandedToken) {
            return APTUtils.getExpandedToken(((MacroExpandedToken)aPTToken).getTo());
        }
        if (aPTToken instanceof APTBaseLanguageFilter.FilterToken) {
            return APTUtils.getExpandedToken(((APTBaseLanguageFilter.FilterToken)aPTToken).getOriginalToken());
        }
        return aPTToken;
    }

    public static boolean areAdjacent(APTToken aPTToken, APTToken aPTToken2) {
        while (aPTToken instanceof MacroExpandedToken && aPTToken2 instanceof MacroExpandedToken) {
            aPTToken = ((MacroExpandedToken)aPTToken).getTo();
            aPTToken2 = ((MacroExpandedToken)aPTToken2).getTo();
        }
        return aPTToken.getEndOffset() == aPTToken2.getOffset();
    }

    public static List<APTToken> toList(TokenStream tokenStream) {
        ArrayList<APTToken> arrayList = new ArrayList<APTToken>(1024);
        try {
            APTToken aPTToken = (APTToken)tokenStream.nextToken();
            while (!APTUtils.isEOF(aPTToken)) {
                assert (aPTToken != null) : "list of tokens must not have 'null' elements";
                arrayList.add(aPTToken);
                aPTToken = (APTToken)tokenStream.nextToken();
            }
        }
        catch (TokenStreamException tokenStreamException) {
            LOG.log(Level.INFO, "error on converting token stream to list", tokenStreamException.getMessage());
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public static Object getTextKey(String string) {
        assert (string != null);
        assert (string.length() > 0);
        return string;
    }

    public static APTToken createAPTToken(APTToken aPTToken, int n) {
        APTToken aPTToken2 = APTTraceFlags.USE_APT_TEST_TOKEN ? new APTTestToken(aPTToken, n) : new APTBaseToken(aPTToken, n);
        return aPTToken2;
    }

    public static APTToken createAPTToken(APTToken aPTToken) {
        return APTUtils.createAPTToken(aPTToken, aPTToken.getType());
    }

    public static APTToken createAPTToken() {
        APTToken aPTToken = APTTraceFlags.USE_APT_TEST_TOKEN ? new APTTestToken() : new APTBaseToken();
        return aPTToken;
    }

    static {
        Object object = System.getProperty("org.netbeans.modules.cnd.apt.level");
        if (object == null) {
            if (APTTraceFlags.TRACE_APT | APTTraceFlags.TRACE_APT_LEXER) {
                LOG.setLevel(Level.ALL);
            } else {
                LOG.setLevel(Level.SEVERE);
            }
        } else {
            try {
                LOG.setLevel(Level.parse((String)object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        VA_ARGS_TOKEN = APTUtils.createAPTToken();
        VA_ARGS_TOKEN.setType(205);
        VA_ARGS_TOKEN.setText("__VA_ARGS__");
        EMPTY_ID_TOKEN = APTUtils.createAPTToken();
        EMPTY_ID_TOKEN.setType(205);
        EMPTY_ID_TOKEN.setText("");
        COMMA_TOKEN = APTUtils.createAPTToken(134);
        COMMA_TOKEN.setType(134);
        COMMA_TOKEN.setText(",");
        object = APTUtils.createAPTToken();
        object.setType(204);
        object.setText("1");
        DEF_MACRO_BODY = new ArrayList<APTToken>(1);
        DEF_MACRO_BODY.add((APTToken)object);
        EOF_TOKEN = new APTEOFToken();
        EMPTY_STREAM = new TokenStream(){

            public Token nextToken() throws TokenStreamException {
                return EOF_TOKEN;
            }
        };
    }

    private static final class APTEOFToken
    extends APTTokenAbstact {
        public int getOffset() {
            throw new UnsupportedOperationException("getOffset must not be used");
        }

        public void setOffset(int n) {
            throw new UnsupportedOperationException("setOffset must not be used");
        }

        public int getEndOffset() {
            throw new UnsupportedOperationException("getEndOffset must not be used");
        }

        public void setEndOffset(int n) {
            throw new UnsupportedOperationException("setEndOffset must not be used");
        }

        public CharSequence getTextID() {
            throw new UnsupportedOperationException("getTextID must not be used");
        }

        public void setTextID(CharSequence charSequence) {
            throw new UnsupportedOperationException("setTextID must not be used");
        }

        public int getEndColumn() {
            throw new UnsupportedOperationException("getEndColumn must not be used");
        }

        public void setEndColumn(int n) {
            throw new UnsupportedOperationException("setEndColumn must not be used");
        }

        public int getEndLine() {
            throw new UnsupportedOperationException("getEndLine must not be used");
        }

        public void setEndLine(int n) {
            throw new UnsupportedOperationException("setEndLine must not be used");
        }

        public int getType() {
            return 1;
        }

        public String getText() {
            return "<EOF>";
        }

        public int getColumn() {
            return Integer.MAX_VALUE;
        }

        public int getLine() {
            return Integer.MAX_VALUE;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object object) {
            return this == object;
        }
    }
}

