/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APTFileCacheManager {
    private static Reference<ConcurrentMap<CharSequence, ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry>>> refAptCaches = new SoftReference<Object>(null);
    private static ConcurrentMap<CharSequence, Reference<ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry>>> file2AptCacheRef = new ConcurrentHashMap<CharSequence, Reference<ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry>>>();
    private static final Object aptCachesLock = new Lock();

    private APTFileCacheManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry> getAPTCache(CharSequence charSequence, Boolean bl) {
        Reference reference;
        ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry> concurrentMap;
        if (bl == null) {
            Reference reference2 = (Reference)file2AptCacheRef.remove(charSequence);
            return null;
        }
        SoftReference<ConcurrentHashMap<APTIncludeHandler.State, APTFileCacheEntry>> softReference = (SoftReference<ConcurrentHashMap<APTIncludeHandler.State, APTFileCacheEntry>>)file2AptCacheRef.get(charSequence);
        ConcurrentHashMap<APTIncludeHandler.State, APTFileCacheEntry> concurrentHashMap = concurrentMap = softReference == null ? null : (ConcurrentHashMap<APTIncludeHandler.State, APTFileCacheEntry>)((Reference)softReference).get();
        if (concurrentMap == null && (reference = (Reference)file2AptCacheRef.putIfAbsent(charSequence, softReference = new SoftReference<ConcurrentHashMap<APTIncludeHandler.State, APTFileCacheEntry>>((ConcurrentHashMap<APTIncludeHandler.State, APTFileCacheEntry>)(concurrentMap = new ConcurrentHashMap<APTIncludeHandler.State, APTFileCacheEntry>())))) != null) {
            ConcurrentMap concurrentMap2 = (ConcurrentMap)reference.get();
            if (concurrentMap2 != null) {
                concurrentMap = concurrentMap2;
            } else {
                Object object = aptCachesLock;
                synchronized (object) {
                    file2AptCacheRef.remove(charSequence, reference);
                    boolean bl2 = false;
                    reference = file2AptCacheRef.putIfAbsent(charSequence, softReference);
                    if (reference != null) {
                        concurrentMap2 = (ConcurrentMap)reference.get();
                        if (concurrentMap2 != null) {
                            concurrentMap = concurrentMap2;
                        } else {
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        file2AptCacheRef.put(charSequence, softReference);
                    }
                }
            }
        }
        assert (concurrentMap != null);
        if (bl == Boolean.TRUE) {
            concurrentMap.clear();
        }
        return concurrentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry> getAPTCache2(CharSequence charSequence, boolean bl) {
        ConcurrentMap concurrentMap;
        ConcurrentMap<CharSequence, ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry>> concurrentMap2;
        ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry> concurrentMap3 = aptCachesLock;
        synchronized (concurrentMap3) {
            concurrentMap2 = refAptCaches.get();
            if (concurrentMap2 == null || bl) {
                concurrentMap2 = new ConcurrentHashMap<CharSequence, ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry>>();
                refAptCaches = new SoftReference<ConcurrentMap<CharSequence, ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry>>>(concurrentMap2);
            }
        }
        concurrentMap3 = (ConcurrentMap)concurrentMap2.get(charSequence);
        if (concurrentMap3 == null && (concurrentMap = (ConcurrentMap)concurrentMap2.putIfAbsent(charSequence, concurrentMap3 = new ConcurrentHashMap<APTIncludeHandler.State, APTFileCacheEntry>())) != null) {
            concurrentMap3 = concurrentMap;
        }
        if (bl) {
            concurrentMap3.clear();
        }
        return concurrentMap3;
    }

    public static APTFileCacheEntry getEntry(CharSequence charSequence, APTPreprocHandler aPTPreprocHandler, Boolean bl) {
        APTIncludeHandler.State state = APTFileCacheManager.getKey(aPTPreprocHandler);
        ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry> concurrentMap = APTFileCacheManager.getAPTCache(charSequence, Boolean.FALSE);
        APTFileCacheEntry aPTFileCacheEntry = (APTFileCacheEntry)concurrentMap.get(state);
        if (bl != null) {
            if (aPTFileCacheEntry == null) {
                if (bl == Boolean.TRUE) {
                    aPTFileCacheEntry = APTFileCacheEntry.createSerialEntry(charSequence);
                } else {
                    aPTFileCacheEntry = APTFileCacheEntry.createConcurrentEntry(charSequence);
                    APTFileCacheEntry aPTFileCacheEntry2 = concurrentMap.putIfAbsent(state, aPTFileCacheEntry);
                    if (aPTFileCacheEntry2 != null) {
                        aPTFileCacheEntry = aPTFileCacheEntry2;
                    }
                }
            } else if (APTTraceFlags.TRACE_APT_CACHE) {
                System.err.printf("APT CACHE for %s\nsize %d, key: %s\ncache state:%s\n", charSequence, concurrentMap.size(), "", "");
            }
        }
        assert (bl == null || aPTFileCacheEntry != null);
        return aPTFileCacheEntry;
    }

    public static void setAPTCacheEntry(CharSequence charSequence, APTPreprocHandler aPTPreprocHandler, APTFileCacheEntry aPTFileCacheEntry, boolean bl) {
        if (aPTFileCacheEntry != null) {
            ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry> concurrentMap = APTFileCacheManager.getAPTCache(charSequence, bl ? Boolean.TRUE : Boolean.FALSE);
            APTIncludeHandler.State state = APTFileCacheManager.getKey(aPTPreprocHandler);
            concurrentMap.put(state, APTFileCacheEntry.toSerial(aPTFileCacheEntry));
        }
    }

    public static void invalidate(APTFileBuffer aPTFileBuffer) {
        ConcurrentMap<APTIncludeHandler.State, APTFileCacheEntry> concurrentMap = APTFileCacheManager.getAPTCache(aPTFileBuffer.getAbsolutePath(), null);
        if (concurrentMap != null) {
            concurrentMap.clear();
        }
    }

    public static void invalidateAll() {
        file2AptCacheRef.clear();
    }

    public static void close() {
        file2AptCacheRef.clear();
    }

    private static APTIncludeHandler.State getKey(APTPreprocHandler aPTPreprocHandler) {
        return aPTPreprocHandler.getIncludeHandler().getState();
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

