/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.versioning.util.projects.ProjectOpener;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectUtilities {
    private static final String ProjectTab_ID_LOGICAL = "projectTabLogical_tc";
    public static final Logger LOG = Logger.getLogger(ProjectUtilities.class.getName());

    public static void openCheckedOutProjects(Map<Project, Set<Project>> map, File file) {
        ProjectOpener projectOpener = new ProjectOpener(map, file);
        projectOpener.openCheckedOutProjects();
    }

    public static void selectAndExpandProject(final Project project) {
        SwingUtilities.invokeLater(new Runnable(){
            final TopComponent ptLogicalTC = ProjectUtilities.access$000("projectTabLogical_tc");
            final ExplorerManager.Provider ptLogicalExplorerManager = (ExplorerManager.Provider)this.ptLogicalTC;

            public void run() {
                if (this.ptLogicalExplorerManager == null) {
                    Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Cannot find Project widnow, aborting.");
                    return;
                }
                Node node = this.ptLogicalExplorerManager.getExplorerManager().getRootContext();
                for (Node node2 : node.getChildren().getNodes()) {
                    Project project2 = (Project)node2.getLookup().lookup(Project.class);
                    if (project2 == null || !project2.getProjectDirectory().equals(project.getProjectDirectory())) continue;
                    try {
                        this.ptLogicalExplorerManager.getExplorerManager().setSelectedNodes(new Node[]{node2});
                        this.ptLogicalTC.requestActive();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private static synchronized TopComponent findDefault(String string) {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(string);
        return topComponent;
    }

    public static void newProjectWizard(File file) {
        Action action = CommonProjectActions.newProjectAction();
        if (action != null) {
            File file2 = ProjectChooser.getProjectsFolder();
            ProjectChooser.setProjectsFolder((File)file);
            FileObject fileObject = FileUtil.toFileObject((File)file);
            action.putValue("existingSourcesFolder", fileObject);
            ProjectUtilities.performAction(action);
        }
    }

    public static void scanForProjects(FileObject fileObject, Map<Project, Set<Project>> map) {
        ProjectManager.getDefault().clearNonProjectCache();
        assert (map.get(null) != null);
        ProjectUtilities.scanForProjectsRecursively(fileObject, map, null, 5);
    }

    private static void scanForProjectsRecursively(FileObject fileObject, Map<Project, Set<Project>> map, Project object, int n) {
        Object object2;
        Enumeration enumeration;
        if (n <= 0) {
            return;
        }
        ProjectManager projectManager = ProjectManager.getDefault();
        if (fileObject.isFolder() && projectManager.isProject(fileObject)) {
            try {
                enumeration = projectManager.findProject(fileObject);
                if (enumeration != null) {
                    object2 = map.get(object);
                    assert (object2 != null);
                    object = enumeration;
                    object2.add(enumeration);
                    map.put((Project)enumeration, new HashSet());
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, " ignoring suspicious project folder...", iOException);
            }
        }
        enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            object2 = (FileObject)enumeration.nextElement();
            if (!object2.isFolder()) continue;
            ProjectUtilities.scanForProjectsRecursively((FileObject)object2, map, object, n - 1);
        }
    }

    private static boolean performAction(Action action) {
        if (action == null) {
            return false;
        }
        ActionEvent actionEvent = new ActionEvent(ProjectUtilities.class, 1001, "command");
        try {
            action.actionPerformed(actionEvent);
            return true;
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, null, exception);
            return false;
        }
    }

    private ProjectUtilities() {
    }

    public static Set<? extends Project> getSubProjects(Project project) {
        Set set = null;
        SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        set = subprojectProvider != null ? subprojectProvider.getSubprojects() : Collections.emptySet();
        return set;
    }

    public static void addSubprojects(Project project, Set<Project> set, Map<Project, Set<? extends Project>> map) {
        Set<Object> set2 = map.get(project);
        if (set2 == null) {
            SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
            set2 = subprojectProvider != null ? subprojectProvider.getSubprojects() : Collections.emptySet();
            map.put(project, (Set<? extends Project>)set2);
            for (Project project2 : set2) {
                set.add(project2);
                ProjectUtilities.addSubprojects(project2, set, map);
            }
        }
    }

    public static void sortProjectsByParents(List<Project> list, Map<Project, Set<Project>> map) {
        ArrayList arrayList = new ArrayList(list.size());
        Collections.sort(arrayList, new Comparator<Project>(){

            @Override
            public int compare(Project project, Project project2) {
                String string = project.getProjectDirectory().getPath();
                String string2 = project2.getProjectDirectory().getPath();
                return string.compareTo(string2);
            }
        });
    }

    static /* synthetic */ TopComponent access$000(String string) {
        return ProjectUtilities.findDefault(string);
    }
}

