/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.versioning.util.IndexingBridge;
import org.openide.util.RequestProcessor;

public final class DelayScanRegistry {
    private final WeakHashMap<RequestProcessor.Task, DelayedScan> registry = new WeakHashMap(5);
    private static DelayScanRegistry instance;
    private static int MAX_WAITING_TIME;
    private static int WAITING_PERIOD;

    public static synchronized DelayScanRegistry getInstance() {
        if (instance == null) {
            instance = new DelayScanRegistry();
        }
        return instance;
    }

    private DelayScanRegistry() {
    }

    public boolean isDelayed(RequestProcessor.Task task, Logger logger, String string) {
        boolean bl = false;
        DelayedScan delayedScan = this.getRegisteredScan(task);
        Future future = OpenProjects.getDefault().openProjects();
        if (!future.isDone()) {
            try {
                future.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            delayedScan.afterProjetOpenning = true;
        }
        if (delayedScan.afterProjetOpenning && IndexingBridge.getInstance().isIndexingInProgress() && delayedScan.waitingLoops * WAITING_PERIOD < MAX_WAITING_TIME) {
            boolean bl2 = false;
            if (!$assertionsDisabled) {
                bl2 = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            Level level = ++delayedScan.waitingLoops < 20 || !bl2 ? Level.FINE : Level.INFO;
            logger.log(level, string + ": Scanning in progress, trying again in " + WAITING_PERIOD + "ms");
            task.schedule(WAITING_PERIOD);
            bl = true;
        } else {
            delayedScan.waitingLoops = 0;
            delayedScan.afterProjetOpenning = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DelayedScan getRegisteredScan(RequestProcessor.Task task) {
        WeakHashMap<RequestProcessor.Task, DelayedScan> weakHashMap = this.registry;
        synchronized (weakHashMap) {
            DelayedScan delayedScan = this.registry.get(task);
            if (delayedScan == null) {
                delayedScan = new DelayedScan();
                this.registry.put(task, delayedScan);
            }
            return delayedScan;
        }
    }

    static {
        MAX_WAITING_TIME = 180000;
        WAITING_PERIOD = 5000;
    }

    private static class DelayedScan {
        private boolean afterProjetOpenning;
        private int waitingLoops;

        private DelayedScan() {
        }
    }
}

