/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPDAUtils {
    public static final boolean IS_JDK_16 = !System.getProperty("java.version").startsWith("1.5");
    public static final boolean IS_JDK_160_02 = IS_JDK_16 && !System.getProperty("java.version").equals("1.6.0") && !System.getProperty("java.version").equals("1.6.0_01");

    public static final ReferenceType getPreferredReferenceType(List<ReferenceType> list, Logger logger) throws VMDisconnectedExceptionWrapper {
        ReferenceType referenceType;
        if (list.size() == 1) {
            referenceType = null;
        } else {
            referenceType = null;
            try {
                for (ReferenceType referenceType2 : list) {
                    Field field;
                    ClassLoaderReference classLoaderReference;
                    try {
                        classLoaderReference = ReferenceTypeWrapper.classLoader(referenceType2);
                    }
                    catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                        continue;
                    }
                    if (classLoaderReference == null) {
                        if (referenceType != null) {
                            referenceType = null;
                            break;
                        }
                        referenceType = referenceType2;
                        continue;
                    }
                    try {
                        field = ReferenceTypeWrapper.fieldByName(ObjectReferenceWrapper.referenceType(classLoaderReference), "parent");
                    }
                    catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                        continue;
                    }
                    if (field != null) {
                        Value value;
                        try {
                            value = ObjectReferenceWrapper.getValue(classLoaderReference, field);
                        }
                        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                            continue;
                        }
                        if (value != null) {
                            if (referenceType != null) {
                                referenceType = null;
                                break;
                            }
                            referenceType = referenceType2;
                        }
                        if (logger == null || !logger.isLoggable(Level.FINE)) continue;
                        logger.fine("Class loader of reference type: " + classLoaderReference + " have parent class loader: " + value);
                        continue;
                    }
                    if (logger == null || !logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Class loader of reference type: " + classLoaderReference + ". Parent class loader - field parent does not exist.");
                }
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                referenceType = null;
            }
            catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
                referenceType = null;
            }
        }
        return referenceType;
    }

    public static void printFeatures(Logger logger, VirtualMachine virtualMachine) {
        try {
            logger.fine("canAddMethod " + VirtualMachineWrapper.canAddMethod(virtualMachine));
            logger.fine("canBeModified " + VirtualMachineWrapper.canBeModified(virtualMachine));
            logger.fine("canGetBytecodes " + VirtualMachineWrapper.canGetBytecodes(virtualMachine));
            logger.fine("canGetCurrentContendedMonitor " + VirtualMachineWrapper.canGetCurrentContendedMonitor(virtualMachine));
            logger.fine("canGetMonitorInfo " + VirtualMachineWrapper.canGetMonitorInfo(virtualMachine));
            logger.fine("canGetOwnedMonitorInfo " + VirtualMachineWrapper.canGetOwnedMonitorInfo(virtualMachine));
            logger.fine("canGetSourceDebugExtension " + VirtualMachineWrapper.canGetSourceDebugExtension(virtualMachine));
            logger.fine("canGetSyntheticAttribute " + VirtualMachineWrapper.canGetSyntheticAttribute(virtualMachine));
            logger.fine("canPopFrames " + VirtualMachineWrapper.canPopFrames(virtualMachine));
            logger.fine("canRedefineClasses " + VirtualMachineWrapper.canRedefineClasses(virtualMachine));
            logger.fine("canRequestVMDeathEvent " + VirtualMachineWrapper.canRequestVMDeathEvent(virtualMachine));
            logger.fine("canUnrestrictedlyRedefineClasses " + VirtualMachineWrapper.canUnrestrictedlyRedefineClasses(virtualMachine));
            logger.fine("canUseInstanceFilters " + VirtualMachineWrapper.canUseInstanceFilters(virtualMachine));
            logger.fine("canWatchFieldAccess " + VirtualMachineWrapper.canWatchFieldAccess(virtualMachine));
            logger.fine("canWatchFieldModification " + VirtualMachineWrapper.canWatchFieldModification(virtualMachine));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            logger.fine(internalExceptionWrapper.getLocalizedMessage());
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            logger.fine(vMDisconnectedExceptionWrapper.getLocalizedMessage());
        }
    }
}

