/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadGroupReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.ThreadsCache;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class ThreadsTreeModel
implements TreeModel {
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(116) >= 0;
    private JPDADebuggerImpl debugger;
    private Map<Object, ChildrenTree> childrenCache = new WeakHashMap<Object, ChildrenTree>();
    private Listener listener;
    private Collection<ModelListener> listeners = new HashSet<ModelListener>();

    public ThreadsTreeModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        Object[] objectArray;
        Object[] objectArray2;
        Map<Object, ChildrenTree> map = this.childrenCache;
        synchronized (map) {
            objectArray2 = this.childrenCache.get(object);
            objectArray = objectArray2 != null ? objectArray2.getChildren() : null;
        }
        if (objectArray == null) {
            objectArray = this.computeChildren(object);
            if (objectArray == null) {
                throw new UnknownTypeException(object);
            }
            map = this.childrenCache;
            synchronized (map) {
                objectArray2 = new ChildrenTree();
                objectArray2.setChildren(objectArray);
                this.childrenCache.put(object, (ChildrenTree)objectArray2);
            }
        }
        int n3 = objectArray.length;
        n = Math.min(n3, n);
        n2 = Math.min(n3, n2);
        if (n == 0 && n2 == n3) {
            return objectArray;
        }
        objectArray2 = new Object[n2 - n];
        System.arraycopy(objectArray, n, objectArray2, 0, n2 - n);
        objectArray = objectArray2;
        return objectArray;
    }

    private Object[] computeChildren(Object object) {
        if (object.equals("Root")) {
            if (verbose) {
                VirtualMachine virtualMachine = this.debugger.getVirtualMachine();
                if (virtualMachine == null) {
                    System.err.println("\nThreadsTreeModel.computeChildren():\nVM is null!\n");
                } else {
                    try {
                        List<ThreadReference> list = VirtualMachineWrapper.allThreads(virtualMachine);
                        System.err.println("\nThreadsTreeModel.computeChildren() ALL Threads:");
                        for (ThreadReference threadReference : list) {
                            System.err.println("  " + ThreadReferenceWrapper.name(threadReference) + " is suspended: " + ThreadReferenceWrapper.isSuspended(threadReference) + ", suspend count = " + ThreadReferenceWrapper.suspendCount(threadReference));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    System.err.println("");
                }
            }
            return this.debugger.getTopLevelThreadGroups();
        }
        if (object instanceof JPDAThreadGroup) {
            JPDAThreadGroup jPDAThreadGroup = (JPDAThreadGroup)object;
            JPDAThreadGroup[] jPDAThreadGroupArray = jPDAThreadGroup.getThreadGroups();
            JPDAThread[] jPDAThreadArray = jPDAThreadGroup.getThreads();
            int n = jPDAThreadGroupArray.length + jPDAThreadArray.length;
            Object[] objectArray = new Object[n];
            System.arraycopy(jPDAThreadGroupArray, 0, objectArray, 0, jPDAThreadGroupArray.length);
            System.arraycopy(jPDAThreadArray, 0, objectArray, jPDAThreadGroupArray.length, jPDAThreadArray.length);
            return objectArray;
        }
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recomputeChildren() {
        Map<Object, ChildrenTree> map = this.childrenCache;
        synchronized (map) {
            this.recomputeChildren(this.getRoot());
        }
    }

    private void recomputeChildren(Object object) {
        ChildrenTree childrenTree = this.childrenCache.get(object);
        if (childrenTree != null) {
            Set<Object> set = this.childrenCache.keySet();
            Object[] objectArray = this.computeChildren(object);
            childrenTree.setChildren(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                if (!set.contains(objectArray[i])) continue;
                this.recomputeChildren(objectArray[i]);
            }
        }
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object instanceof JPDAThread) {
            return true;
        }
        if (object instanceof JPDAThreadGroup) {
            return false;
        }
        if (object == "Root") {
            return false;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(modelListener);
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(modelListener);
            if (this.listeners.size() == 0) {
                this.listener.destroy();
                this.listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged() {
        ModelListener[] modelListenerArray;
        this.recomputeChildren();
        ModelEvent.TreeChanged treeChanged = this.listeners;
        synchronized (treeChanged) {
            modelListenerArray = this.listeners.toArray(new ModelListener[0]);
        }
        treeChanged = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < modelListenerArray.length; ++i) {
            modelListenerArray[i].modelChanged((ModelEvent)treeChanged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeChanged(Object object) {
        ModelListener[] modelListenerArray;
        this.recomputeChildren();
        ModelEvent.NodeChanged nodeChanged = this.listeners;
        synchronized (nodeChanged) {
            modelListenerArray = this.listeners.toArray(new ModelListener[0]);
        }
        nodeChanged = new ModelEvent.NodeChanged((Object)this, object);
        for (int i = 0; i < modelListenerArray.length; ++i) {
            modelListenerArray[i].modelChanged((ModelEvent)nodeChanged);
        }
    }

    private static class ChildrenTree {
        private Object[] ch;

        public void setChildren(Object[] objectArray) {
            this.ch = objectArray;
        }

        public Object[] getChildren() {
            return this.ch;
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private JPDADebuggerImpl debugger;
        private ThreadsCache tc;
        private WeakReference<ThreadsTreeModel> model;
        private RequestProcessor.Task task;
        private Set<Object> nodesToRefresh;

        public Listener(ThreadsTreeModel threadsTreeModel, JPDADebuggerImpl jPDADebuggerImpl) {
            this.debugger = jPDADebuggerImpl;
            this.tc = jPDADebuggerImpl.getThreadsCache();
            this.model = new WeakReference<ThreadsTreeModel>(threadsTreeModel);
            this.tc.addPropertyChangeListener(this);
        }

        private ThreadsTreeModel getModel() {
            ThreadsTreeModel threadsTreeModel = (ThreadsTreeModel)this.model.get();
            if (threadsTreeModel == null) {
                this.destroy();
            }
            return threadsTreeModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy() {
            this.tc.removePropertyChangeListener(this);
            Listener listener = this;
            synchronized (listener) {
                if (this.task != null) {
                    this.task.cancel();
                    if (verbose) {
                        System.out.println("TTM cancel old task " + this.task);
                    }
                    this.task = null;
                }
            }
        }

        private RequestProcessor.Task createTask() {
            RequestProcessor.Task task = this.debugger.getRequestProcessor().create((Runnable)new RefreshTree());
            if (verbose) {
                System.out.println("TTM  create task " + task);
            }
            return task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ThreadGroupReference threadGroupReference;
            Object object;
            if (propertyChangeEvent.getPropertyName() == "threadStarted") {
                object = (ThreadReference)propertyChangeEvent.getNewValue();
                try {
                    threadGroupReference = ThreadReferenceWrapper.threadGroup((ThreadReference)object);
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    threadGroupReference = null;
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    return;
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    return;
                }
                catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                    threadGroupReference = null;
                }
            } else if (propertyChangeEvent.getPropertyName() == "threadDied") {
                object = (ThreadReference)propertyChangeEvent.getOldValue();
                try {
                    threadGroupReference = ThreadReferenceWrapper.threadGroup((ThreadReference)object);
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    threadGroupReference = null;
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    return;
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    threadGroupReference = null;
                }
                catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                    threadGroupReference = null;
                }
            } else if (propertyChangeEvent.getPropertyName() == "groupAdded") {
                threadGroupReference = (ThreadGroupReference)propertyChangeEvent.getNewValue();
                try {
                    threadGroupReference = ThreadGroupReferenceWrapper.parent(threadGroupReference);
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    threadGroupReference = null;
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    threadGroupReference = null;
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    threadGroupReference = null;
                }
            } else {
                return;
            }
            object = threadGroupReference == null ? "Root" : this.debugger.getThreadGroup(threadGroupReference);
            Listener listener = this;
            synchronized (listener) {
                if (this.task == null) {
                    this.task = this.createTask();
                }
                if (this.nodesToRefresh == null) {
                    this.nodesToRefresh = new LinkedHashSet<Object>();
                }
                this.nodesToRefresh.add(object);
                this.task.schedule(100);
            }
        }

        private class RefreshTree
        implements Runnable {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArrayList arrayList;
                ThreadsTreeModel threadsTreeModel = Listener.this.getModel();
                if (threadsTreeModel == null) {
                    return;
                }
                if (verbose) {
                    System.out.println("TTM do R task " + Listener.this.task);
                }
                Listener listener = Listener.this;
                synchronized (listener) {
                    arrayList = new ArrayList(Listener.this.nodesToRefresh);
                    Listener.this.nodesToRefresh.clear();
                }
                for (Object e : arrayList) {
                    threadsTreeModel.fireNodeChanged(e);
                }
            }
        }
    }
}

