/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class CvsVisibilityQuery
implements VisibilityQueryImplementation2,
VersioningListener {
    private static CvsVisibilityQuery instance;
    private static final String MARKER_CVS_REMOVED = "CVS/.nb-removed";
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final RequestProcessor.Task refreshVisibilityTask;

    public CvsVisibilityQuery() {
        CvsVersioningSystem.getInstance().getStatusCache().addVersioningListener(this);
        instance = this;
        this.refreshVisibilityTask = Utils.createTask((Runnable)new Runnable(){

            public void run() {
                CvsVisibilityQuery.this.fireVisibilityChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible(FileObject fileObject) {
        boolean bl;
        block5: {
            boolean bl2;
            long l;
            block3: {
                boolean bl3;
                block4: {
                    l = System.currentTimeMillis();
                    CvsVersioningSystem.LOG.log(Level.FINE, "isVisible {0}", new Object[]{fileObject});
                    bl2 = true;
                    try {
                        if (!fileObject.isData()) break block3;
                        bl3 = bl2;
                        Object var8_6 = null;
                        if (!CvsVersioningSystem.LOG.isLoggable(Level.FINE)) break block4;
                    }
                    catch (Throwable throwable) {
                        block6: {
                            Object var8_8 = null;
                            if (!CvsVersioningSystem.LOG.isLoggable(Level.FINE)) break block6;
                            CvsVersioningSystem.LOG.log(Level.FINE, "isVisible returns {0} in {1} millis", new Object[]{bl2, System.currentTimeMillis() - l});
                        }
                        throw throwable;
                    }
                    CvsVersioningSystem.LOG.log(Level.FINE, "isVisible returns {0} in {1} millis", new Object[]{bl2, System.currentTimeMillis() - l});
                }
                return bl3;
            }
            File file = FileUtil.toFile((FileObject)fileObject);
            bl = bl2 = this.isVisible(file);
            Object var8_7 = null;
            if (!CvsVersioningSystem.LOG.isLoggable(Level.FINE)) break block5;
            CvsVersioningSystem.LOG.log(Level.FINE, "isVisible returns {0} in {1} millis", new Object[]{bl2, System.currentTimeMillis() - l});
        }
        return bl;
    }

    public boolean isVisible(File file) {
        return file == null || file.isFile() || !CvsVisibilityQuery.isHiddenFolder(file);
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(this.listeners);
        arrayList.add(changeListener);
        this.listeners = arrayList;
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(this.listeners);
        arrayList.remove(changeListener);
        this.listeners = arrayList;
    }

    public void versioningEvent(VersioningEvent versioningEvent) {
        if (versioningEvent.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            File file = (File)versioningEvent.getParams()[0];
            if (file == null) {
                return;
            }
            File file2 = file.getParentFile();
            if (file2 == null) {
                return;
            }
            File file3 = new File(file2, MARKER_CVS_REMOVED);
            if (file3.exists()) {
                if (file.lastModified() > file3.lastModified() && !"CVS".equals(file.getName())) {
                    CvsVisibilityQuery.makeVisible(file2);
                }
                this.fireVisibilityChanged();
            }
        }
    }

    private static void makeVisible(File file) {
        if (file == null) {
            return;
        }
        new File(file, MARKER_CVS_REMOVED).delete();
        CvsVisibilityQuery.makeVisible(file.getParentFile());
    }

    static boolean isHiddenFolder(File file) {
        File file2 = new File(file, MARKER_CVS_REMOVED);
        if (file2.exists()) {
            File[] fileArray;
            for (File file3 : fileArray = file.listFiles()) {
                if (file3.lastModified() <= file2.lastModified() || "CVS".equals(file3.getName())) continue;
                CvsVisibilityQuery.makeVisible(file);
                CvsVisibilityQuery.refreshVisibility();
                return false;
            }
            return true;
        }
        return false;
    }

    private synchronized void fireVisibilityChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private static void refreshVisibility() {
        if (instance != null) {
            CvsVisibilityQuery.instance.refreshVisibilityTask.schedule(100);
        }
    }

    static void hideFolder(File file) throws IOException {
        new File(file, MARKER_CVS_REMOVED).createNewFile();
        CvsVisibilityQuery.refreshVisibility();
    }
}

