/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;
import org.netbeans.modules.cnd.refactoring.api.WhereUsedQueryConstants;
import org.netbeans.modules.cnd.refactoring.elements.CsmRefactoringElementImpl;
import org.netbeans.modules.cnd.refactoring.plugins.CsmRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmWhereUsedQueryPlugin
extends CsmRefactoringPlugin {
    private final WhereUsedQuery refactoring;
    private final CsmObject startReferenceObject;

    public CsmWhereUsedQueryPlugin(WhereUsedQuery whereUsedQuery) {
        this.refactoring = whereUsedQuery;
        this.startReferenceObject = (CsmObject)whereUsedQuery.getRefactoringSource().lookup(CsmObject.class);
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        CsmObject csmObject;
        CsmUID csmUID = (CsmUID)this.refactoring.getRefactoringSource().lookup(CsmUID.class);
        CsmObject csmObject2 = csmObject = csmUID == null ? null : (CsmObject)csmUID.getObject();
        if (csmObject == null) {
            return null;
        }
        Collection<RefactoringElementImplementation> collection = this.doPrepareElements(csmObject);
        if (collection != null) {
            refactoringElementsBag.addAll((AbstractRefactoring)this.refactoring, collection);
        }
        this.fireProgressListenerStop();
        return null;
    }

    Collection<RefactoringElementImplementation> doPrepareElements(CsmObject csmObject) {
        Collection<RefactoringElementImplementation> collection = null;
        if ((csmObject = CsmRefactoringUtils.convertToCsmObjectIfNeeded(csmObject)) == null) {
            return null;
        }
        if (this.isFindUsages()) {
            if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
                this.fireProgressListenerStart(1, 2);
                collection = this.processIncludeQuery((CsmFile)csmObject);
            } else {
                Collection<CsmObject> collection2 = this.getObjectsForFindUsages(csmObject);
                CsmFile csmFile = CsmRefactoringUtils.getCsmFile(this.startReferenceObject);
                HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
                for (CsmObject csmObject2 : collection2) {
                    hashSet.addAll(this.getRelevantFiles(csmFile, csmObject2, (AbstractRefactoring)this.refactoring));
                }
                this.fireProgressListenerStart(1, hashSet.size() + 2);
                collection = this.processObjectUsagesQuery(collection2, hashSet);
            }
        } else if (this.isFindDirectSubclassesOnly() || this.isFindSubclasses()) {
            assert (CsmKindUtilities.isClass((CsmObject)csmObject)) : "must be class";
            this.fireProgressListenerStart(1, 2);
            collection = this.processSubclassesQuery((CsmClass)csmObject);
        } else if (this.isFindOverridingMethods()) {
            assert (CsmKindUtilities.isMethod((CsmObject)csmObject)) : "must be method";
            this.fireProgressListenerStart(1, 2);
            collection = this.processOverridenMethodsQuery((CsmMethod)csmObject);
        }
        this.fireProgressListenerStep();
        return collection;
    }

    @Override
    public Problem preCheck() {
        CsmUID csmUID = (CsmUID)this.refactoring.getRefactoringSource().lookup(CsmUID.class);
        Problem problem = new Problem(true, NbBundle.getMessage(CsmWhereUsedQueryPlugin.class, (String)"MSG_InvalidObjectNothingToFind"));
        if (csmUID == null) {
            CsmFile csmFile = CsmRefactoringUtils.getCsmFile(this.startReferenceObject);
            if (csmFile == null || !csmFile.isValid()) {
                return problem;
            }
            return super.preCheck();
        }
        CsmObject csmObject = (CsmObject)csmUID.getObject();
        if (!CsmBaseUtilities.isValid((CsmObject)csmObject)) {
            return problem;
        }
        return super.preCheck();
    }

    @Override
    public Problem fastCheckParameters() {
        CsmUID csmUID = (CsmUID)this.refactoring.getRefactoringSource().lookup(CsmUID.class);
        if (csmUID != null && CsmKindUtilities.isMethod((CsmObject)((CsmObject)csmUID.getObject()))) {
            return this.checkParametersForMethod(this.isFindOverridingMethods(), this.isFindUsages());
        }
        return super.fastCheckParameters();
    }

    private Problem checkParametersForMethod(boolean bl, boolean bl2) {
        if (!bl2 && !bl) {
            return new Problem(true, NbBundle.getMessage(CsmWhereUsedQueryPlugin.class, (String)"MSG_NothingToFind"));
        }
        return null;
    }

    private Collection<CsmObject> getObjectsForFindUsages(CsmObject csmObject) {
        LinkedHashSet<CsmObject> linkedHashSet = new LinkedHashSet<CsmObject>();
        if (this.isFindUsages()) {
            if (CsmKindUtilities.isMethod((CsmObject)csmObject)) {
                CsmMethod csmMethod = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)csmObject));
                if (this.isFindOverridingMethods() && CsmVirtualInfoQuery.getDefault().isVirtual(csmMethod)) {
                    linkedHashSet.addAll(CsmVirtualInfoQuery.getDefault().getOverridenMethods(csmMethod, this.isSearchFromBaseClass()));
                }
            } else if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
                linkedHashSet.addAll(CsmRefactoringUtils.getConstructors((CsmClass)csmObject));
            }
            linkedHashSet.add(csmObject);
        }
        return linkedHashSet;
    }

    private boolean isFindSubclasses() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES);
    }

    private boolean isFindUsages() {
        return this.refactoring.getBooleanValue((Object)"FIND_REFERENCES");
    }

    private boolean isFindDirectSubclassesOnly() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES);
    }

    private boolean isFindOverridingMethods() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS);
    }

    private boolean isSearchFromBaseClass() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.SEARCH_FROM_BASECLASS);
    }

    private boolean isSearchInComments() {
        return this.refactoring.getBooleanValue((Object)"SEARCH_IN_COMMENTS");
    }

    private Collection<RefactoringElementImplementation> processObjectUsagesQuery(Collection<CsmObject> collection, Collection<CsmFile> collection2) {
        assert (this.isFindUsages()) : "must be find usages mode";
        final CsmReferenceRepository csmReferenceRepository = CsmReferenceRepository.getDefault();
        final ConcurrentLinkedQueue<RefactoringElementImplementation> concurrentLinkedQueue = new ConcurrentLinkedQueue<RefactoringElementImplementation>();
        final Set set = CsmReferenceKind.ALL;
        final CsmObject[] csmObjectArray = collection.toArray(new CsmObject[collection.size()]);
        final CsmReferenceRepository.Interrupter interrupter = new CsmReferenceRepository.Interrupter(){

            public boolean cancelled() {
                return CsmWhereUsedQueryPlugin.this.isCancelled();
            }
        };
        RequestProcessor requestProcessor = new RequestProcessor("FindUsagesQuery", CndUtils.getNumberCndWorkerThreads() + 1);
        final CountDownLatch countDownLatch = new CountDownLatch(collection2.size());
        for (final CsmFile csmFile : collection2) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block10: {
                        try {
                            Object object;
                            if (CsmWhereUsedQueryPlugin.this.isCancelled()) break block10;
                            String string = Thread.currentThread().getName();
                            try {
                                Thread.currentThread().setName("FindUsagesQuery: Analyzing " + csmFile.getAbsolutePath());
                                object = csmReferenceRepository.getReferences(csmObjectArray, csmFile, set, interrupter);
                                for (CsmReference csmReference : object) {
                                    concurrentLinkedQueue.add(CsmRefactoringElementImpl.create(csmReference, true));
                                }
                            }
                            finally {
                                Thread.currentThread().setName(string);
                            }
                            object = CsmWhereUsedQueryPlugin.this;
                            synchronized (object) {
                                CsmWhereUsedQueryPlugin.this.fireProgressListenerStep();
                            }
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }
                }
            };
            requestProcessor.post(runnable);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return concurrentLinkedQueue;
    }

    private Collection<RefactoringElementImplementation> processOverridenMethodsQuery(CsmMethod csmMethod) {
        assert (this.isFindOverridingMethods()) : "must be search for overriden methods";
        LinkedHashSet<RefactoringElementImplementation> linkedHashSet = new LinkedHashSet<RefactoringElementImplementation>(1024);
        Collection collection = CsmVirtualInfoQuery.getDefault().getOverridenMethods(csmMethod, this.isSearchFromBaseClass());
        collection.add(csmMethod);
        for (CsmMethod csmMethod2 : collection) {
            CsmFunctionDefinition csmFunctionDefinition;
            CsmReference csmReference = CsmReferenceSupport.createObjectReference((CsmOffsetable)csmMethod2);
            linkedHashSet.add(CsmRefactoringElementImpl.create(csmReference, false));
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmMethod2) || (csmFunctionDefinition = csmMethod2.getDefinition()) == null) continue;
            CsmReference csmReference2 = CsmReferenceSupport.createObjectReference((CsmOffsetable)csmFunctionDefinition);
            linkedHashSet.add(CsmRefactoringElementImpl.create(csmReference2, false));
        }
        return linkedHashSet;
    }

    @Override
    protected final ModificationResult processFiles(Collection<CsmFile> collection, AtomicReference<Problem> atomicReference) {
        return null;
    }

    private Collection<RefactoringElementImplementation> processIncludeQuery(CsmFile csmFile) {
        assert (this.isFindUsages()) : "must be find usages";
        LinkedHashSet<RefactoringElementImplementation> linkedHashSet = new LinkedHashSet<RefactoringElementImplementation>(1024);
        Collection collection = CsmIncludeHierarchyResolver.getDefault().getIncludes(csmFile);
        for (CsmReference csmReference : collection) {
            linkedHashSet.add(CsmRefactoringElementImpl.create(csmReference, false));
        }
        return linkedHashSet;
    }

    private Collection<RefactoringElementImplementation> processSubclassesQuery(CsmClass csmClass) {
        assert (this.isFindDirectSubclassesOnly() || this.isFindSubclasses()) : "must be search of subclasses";
        LinkedHashSet<RefactoringElementImplementation> linkedHashSet = new LinkedHashSet<RefactoringElementImplementation>(1024);
        boolean bl = this.isFindDirectSubclassesOnly();
        Collection collection = CsmTypeHierarchyResolver.getDefault().getSubTypes(csmClass, bl);
        for (CsmReference csmReference : collection) {
            linkedHashSet.add(CsmRefactoringElementImpl.create(csmReference, false));
        }
        return linkedHashSet;
    }
}

