/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.api.ChangeParametersRefactoring;
import org.netbeans.modules.cnd.refactoring.plugins.CsmModificationRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.plugins.CsmRenameRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.refactoring.api.Problem;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeParametersPlugin
extends CsmModificationRefactoringPlugin {
    private ChangeParametersRefactoring refactoring;
    private Collection<CsmObject> referencedObjects;

    public ChangeParametersPlugin(ChangeParametersRefactoring changeParametersRefactoring) {
        super(changeParametersRefactoring);
        this.refactoring = changeParametersRefactoring;
    }

    private Collection<CsmObject> getRefactoredObjects() {
        return this.referencedObjects == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.referencedObjects);
    }

    private CsmFile getStartCsmFile() {
        CsmFile csmFile = CsmRefactoringUtils.getCsmFile(this.getStartReferenceObject());
        if (csmFile == null && this.getEditorContext() != null) {
            csmFile = this.getEditorContext().getFile();
        }
        return csmFile;
    }

    @Override
    protected Collection<CsmFile> getRefactoredFiles() {
        Collection<CsmObject> collection = this.getRefactoredObjects();
        if (collection == null || collection.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
        CsmFile csmFile = this.getStartCsmFile();
        for (CsmObject csmObject : collection) {
            Collection<CsmProject> collection2 = CsmRefactoringUtils.getRelatedCsmProjects(csmObject, null);
            CsmProject[] csmProjectArray = collection2.toArray(new CsmProject[collection2.size()]);
            this.refactoring.getContext().add((Object)csmProjectArray);
            hashSet.addAll(this.getRelevantFiles(csmFile, csmObject, this.refactoring));
        }
        return hashSet;
    }

    @Override
    public Problem fastCheckParameters() {
        ChangeParametersRefactoring.ParameterInfo[] parameterInfoArray = this.refactoring.getParameterInfo();
        Problem problem = null;
        for (int i = 0; i < parameterInfoArray.length; ++i) {
            Object object;
            int n = parameterInfoArray[i].getOriginalIndex();
            if (n == -1) {
                object = parameterInfoArray[i].getName();
                if (object == null || object.length() < 1) {
                    problem = ChangeParametersPlugin.createProblem(problem, true, ChangeParametersPlugin.newParMessage("ERR_parname"));
                } else if (!CndLexerUtilities.isCppIdentifier((CharSequence)object)) {
                    problem = ChangeParametersPlugin.createProblem(problem, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_InvalidIdentifier", (Object)object));
                }
                CharSequence charSequence = parameterInfoArray[i].getType();
                if (charSequence == null) {
                    problem = ChangeParametersPlugin.createProblem(problem, true, ChangeParametersPlugin.newParMessage("ERR_partype"));
                }
                if ((object = parameterInfoArray[i].getDefaultValue()) == null || object.length() < 1) {
                    problem = ChangeParametersPlugin.createProblem(problem, true, ChangeParametersPlugin.newParMessage("ERR_pardefv"));
                }
            }
            if (((ChangeParametersRefactoring.ParameterInfo)(object = parameterInfoArray[i])).getType() == null || !((Object)((ChangeParametersRefactoring.ParameterInfo)object).getType()).toString().endsWith("...") || i == parameterInfoArray.length - 1) continue;
            problem = ChangeParametersPlugin.createProblem(problem, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_VarargsFinalPosition", (Object[])new Object[0]));
        }
        return problem;
    }

    private static String newParMessage(String string) {
        return new MessageFormat(ChangeParametersPlugin.getString("ERR_newpar")).format(new Object[]{ChangeParametersPlugin.getString(string)});
    }

    private static String getString(String string) {
        return NbBundle.getMessage(ChangeParametersPlugin.class, (String)string);
    }

    private CsmObject getRefactoredCsmElement() {
        CsmContext csmContext;
        CsmObject csmObject = this.getStartReferenceObject();
        if (csmObject == null && (csmContext = this.getEditorContext()) != null) {
            csmObject = csmContext.getEnclosingFunction();
        }
        return csmObject;
    }

    @Override
    public Problem preCheck() {
        Problem problem = null;
        this.fireProgressListenerStart(1, 4);
        CsmObject csmObject = this.getRefactoredCsmElement();
        problem = this.isResovledElement(csmObject);
        this.fireProgressListenerStep();
        if (problem != null) {
            return problem;
        }
        CsmObject csmObject2 = CsmRefactoringUtils.getReferencedElement(csmObject);
        if (!CsmKindUtilities.isFunction((CsmObject)csmObject2) || CsmKindUtilities.isDestructor((CsmObject)csmObject2)) {
            problem = ChangeParametersPlugin.createProblem(problem, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_ChangeParamsWrongType"));
            return problem;
        }
        if (this.referencedObjects == null) {
            this.initReferencedObjects(csmObject2);
            this.fireProgressListenerStep();
        }
        problem = this.checkIfModificationPossible(problem, csmObject2, ChangeParametersPlugin.getString("ERR_Overrides_Fatal"), ChangeParametersPlugin.getString("ERR_OverridesOrOverriden"));
        this.fireProgressListenerStop();
        return problem;
    }

    private void initReferencedObjects(CsmObject csmObject) {
        CsmObject csmObject2 = CsmRefactoringUtils.getReferencedElement(csmObject);
        if (csmObject2 != null) {
            this.referencedObjects = new LinkedHashSet<CsmObject>();
            if (CsmKindUtilities.isMethod((CsmObject)csmObject2) && !CsmKindUtilities.isConstructor((CsmObject)csmObject2)) {
                CsmMethod csmMethod = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)csmObject2));
                this.referencedObjects.add((CsmObject)csmMethod);
                if (CsmVirtualInfoQuery.getDefault().isVirtual(csmMethod)) {
                    this.referencedObjects.addAll(CsmVirtualInfoQuery.getDefault().getOverridenMethods(csmMethod, true));
                    assert (!this.referencedObjects.isEmpty()) : "must be at least start object " + csmMethod;
                }
            } else {
                this.referencedObjects.add(csmObject2);
            }
        }
    }

    @Override
    protected final void processFile(CsmFile csmFile, ModificationResult modificationResult, AtomicReference<Problem> atomicReference) {
        Collection<CsmObject> collection = this.getRefactoredObjects();
        assert (collection != null && collection.size() > 0) : "method must be called for resolved element";
        FileObject fileObject = CsmUtilities.getFileObject((CsmFile)csmFile);
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (CsmObject csmObject : collection) {
            Collection collection2 = CsmReferenceRepository.getDefault().getReferences(csmObject, csmFile, CsmReferenceKind.ALL, null);
            linkedHashSet.addAll(collection2);
        }
        if (linkedHashSet.size() > 0) {
            CsmObject csmObject;
            ArrayList arrayList = new ArrayList(linkedHashSet);
            Collections.sort(arrayList, new Comparator<CsmReference>(){

                @Override
                public int compare(CsmReference csmReference, CsmReference csmReference2) {
                    return csmReference.getStartOffset() - csmReference2.getStartOffset();
                }
            });
            csmObject = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
            this.processRefactoredReferences(arrayList, fileObject, (CloneableEditorSupport)csmObject, modificationResult, atomicReference);
        }
    }

    private boolean needSpaceAfterComma() {
        return true;
    }

    private void processRefactoredReferences(List<CsmReference> list, FileObject fileObject, CloneableEditorSupport cloneableEditorSupport, ModificationResult modificationResult, AtomicReference<Problem> atomicReference) {
        ChangeParametersRefactoring.ParameterInfo[] parameterInfoArray = this.refactoring.getParameterInfo();
        for (CsmReference csmReference : list) {
            String string;
            String string2;
            ModificationResult.Difference difference = this.changeFunRef(csmReference, cloneableEditorSupport, string2 = ((Object)csmReference.getText()).toString(), parameterInfoArray, string = this.getDescription(csmReference, string2), atomicReference);
            if (difference == null) continue;
            modificationResult.addDifference(fileObject, difference);
        }
    }

    private String getDescription(CsmReference csmReference, String string) {
        boolean bl = CsmReferenceResolver.getDefault().isKindOf(csmReference, EnumSet.of(CsmReferenceKind.DECLARATION, CsmReferenceKind.DEFINITION));
        String string2 = NbBundle.getMessage(CsmRenameRefactoringPlugin.class, (String)(bl ? "UpdateSignature" : "UpdateFunRef"), (Object)string);
        return string2;
    }

    private ModificationResult.Difference changeFunRef(CsmReference csmReference, CloneableEditorSupport cloneableEditorSupport, String string, ChangeParametersRefactoring.ParameterInfo[] parameterInfoArray, String string2, AtomicReference<Problem> atomicReference) {
        int n;
        int n2;
        StyledDocument styledDocument = cloneableEditorSupport.getDocument();
        FunctionInfo functionInfo = this.prepareFunctionInfo(csmReference, styledDocument);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (!functionInfo.isValid()) {
            if (string == null) {
                string = ((Object)csmReference.getText()).toString();
            }
            stringBuilder.append(string);
            stringBuilder2.append(string);
            n2 = csmReference.getStartOffset();
            n = csmReference.getEndOffset();
        } else {
            boolean bl = CsmReferenceResolver.getDefault().isKindOf(csmReference, EnumSet.of(CsmReferenceKind.DECLARATION, CsmReferenceKind.DEFINITION));
            boolean bl2 = CsmReferenceResolver.getDefault().isKindOf(csmReference, EnumSet.of(CsmReferenceKind.DEFINITION));
            n2 = functionInfo.getStartOffset();
            n = functionInfo.getEndOffset();
            boolean bl3 = true;
            boolean bl4 = false;
            stringBuilder.append(functionInfo.getOriginalParamsText());
            stringBuilder2.append("(");
            for (int i = 0; i < parameterInfoArray.length; ++i) {
                ChangeParametersRefactoring.ParameterInfo parameterInfo;
                int n3;
                if (!bl3) {
                    stringBuilder2.append(",");
                }
                if ((n3 = (parameterInfo = parameterInfoArray[i]).getOriginalIndex()) == -1) {
                    if (!bl3 && this.needSpaceAfterComma()) {
                        stringBuilder2.append(" ");
                    }
                    bl3 = false;
                    if (bl) {
                        stringBuilder2.append(parameterInfo.getType()).append(" ").append(parameterInfo.getName());
                        if (bl2 && this.refactoring.isUseDefaultValueOnlyInFunctionDefinition()) {
                            stringBuilder2.append(" = ").append(parameterInfo.getDefaultValue());
                        } else {
                            stringBuilder2.append(" /* = ").append(parameterInfo.getDefaultValue()).append(" */");
                        }
                        bl4 = true;
                        continue;
                    }
                    if (!this.refactoring.isUseDefaultValueOnlyInFunctionDefinition()) {
                        stringBuilder2.append(parameterInfo.getDefaultValue());
                        bl4 = true;
                        continue;
                    }
                    bl3 = true;
                    continue;
                }
                if (!functionInfo.hasParam(n3)) continue;
                CharSequence charSequence = functionInfo.getParameter(n3);
                if (!bl3 && this.needSpaceAfterComma() && !Character.isWhitespace(charSequence.charAt(0))) {
                    stringBuilder2.append(" ");
                }
                bl3 = false;
                stringBuilder2.append(charSequence);
            }
            stringBuilder2.append(")");
            if (!bl4) {
                return null;
            }
        }
        assert (n2 <= n);
        PositionRef positionRef = cloneableEditorSupport.createPositionRef(n2, Position.Bias.Forward);
        PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(n, Position.Bias.Backward);
        ModificationResult.Difference difference = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, positionRef, positionRef2, stringBuilder.toString(), stringBuilder2.toString(), string2);
        return difference;
    }

    private FunctionInfo prepareFunctionInfo(final CsmReference csmReference, final Document document) {
        final FunParamsTokenProcessor funParamsTokenProcessor = new FunParamsTokenProcessor(document);
        if (document != null) {
            document.render(new Runnable(){

                public void run() {
                    CndTokenUtilities.processTokens((CndTokenProcessor)funParamsTokenProcessor, (Document)document, (int)csmReference.getStartOffset(), (int)document.getLength());
                }
            });
        }
        return funParamsTokenProcessor.getFunctionInfo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FunParamsTokenProcessor
    implements CndTokenProcessor<Token<CppTokenId>> {
        private State state = State.START;
        private BlockConsumer blockConsumer;
        private final FunctionInfo funInfo = new FunctionInfo();
        private final Document doc;
        private Boolean inPP = null;
        private int curParamStartOffset = -1;

        private FunParamsTokenProcessor(Document document) {
            this.doc = document;
        }

        public boolean isStopped() {
            return this.state == State.END;
        }

        public FunctionInfo getFunctionInfo() {
            return this.funInfo;
        }

        public boolean token(Token<CppTokenId> token, int n) {
            if (this.blockConsumer != null) {
                if (this.blockConsumer.isLastToken(token)) {
                    this.blockConsumer = null;
                }
                return false;
            }
            if (this.inPP == null) {
                if (token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                    this.inPP = Boolean.TRUE;
                    return true;
                }
                this.inPP = Boolean.FALSE;
            } else if (this.inPP == Boolean.FALSE && token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                return false;
            }
            switch (this.state) {
                case START: {
                    this.skipName(token, n);
                    break;
                }
                case IN_PARAMS: {
                    this.inParams(token, n);
                }
            }
            return false;
        }

        public void start(int n, int n2, int n3) {
        }

        public void end(int n, int n2) {
            if (this.funInfo.startOffset != this.funInfo.endOffset) {
                try {
                    this.funInfo.origParamsText = this.doc.getText(this.funInfo.startOffset, this.funInfo.endOffset - this.funInfo.startOffset);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        private void inParams(Token<CppTokenId> token, int n) {
            switch ((CppTokenId)token.id()) {
                case LPAREN: {
                    this.blockConsumer = new BlockConsumer(CppTokenId.LPAREN, CppTokenId.RPAREN);
                    break;
                }
                case LBRACE: {
                    this.blockConsumer = new BlockConsumer(CppTokenId.LBRACE, CppTokenId.RBRACE);
                    break;
                }
                case LBRACKET: {
                    this.blockConsumer = new BlockConsumer(CppTokenId.LBRACKET, CppTokenId.RBRACKET);
                    break;
                }
                case COMMA: {
                    this.finishParam(n);
                    this.startParam(n);
                    break;
                }
                case RPAREN: {
                    this.finishParam(n);
                    this.state = State.END;
                    break;
                }
                case SEMICOLON: {
                    this.finishParam(n);
                    this.state = State.END;
                }
            }
        }

        private void skipName(Token<CppTokenId> token, int n) {
            switch ((CppTokenId)token.id()) {
                case LPAREN: {
                    this.state = State.IN_PARAMS;
                    this.startParam(n);
                    break;
                }
                case LT: {
                    this.blockConsumer = new BlockConsumer(CppTokenId.LT, CppTokenId.GT);
                    break;
                }
                case RPAREN: 
                case SEMICOLON: {
                    this.state = State.END;
                }
            }
        }

        private void finishParam(int n) {
            assert (this.curParamStartOffset > 0);
            try {
                String string;
                String string2 = string = n <= this.curParamStartOffset ? "" : this.doc.getText(this.curParamStartOffset, n - this.curParamStartOffset);
                if (!this.funInfo.paramText.isEmpty() || string.trim().length() != 0) {
                    this.funInfo.addParam(string);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.funInfo.setEndOffset(n + 1);
        }

        private void startParam(int n) {
            this.funInfo.setStartOffsetIfNeeded(n);
            this.curParamStartOffset = n + 1;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class BlockConsumer {
            private final CppTokenId openBracket;
            private final CppTokenId closeBracket;
            private int depth;

            public BlockConsumer(CppTokenId cppTokenId, CppTokenId cppTokenId2) {
                this.openBracket = cppTokenId;
                this.closeBracket = cppTokenId2;
                this.depth = 0;
            }

            public boolean isLastToken(Token<CppTokenId> token) {
                boolean bl = false;
                if (token.id() == this.openBracket) {
                    ++this.depth;
                } else if (token.id() == this.closeBracket) {
                    --this.depth;
                    bl = this.depth <= 0;
                }
                return bl;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            START,
            IN_PARAMS,
            END;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FunctionInfo {
        private int startOffset = -1;
        private int endOffset = -1;
        private CharSequence origParamsText = "";
        private List<CharSequence> paramText = new ArrayList<CharSequence>();

        private FunctionInfo() {
        }

        public CharSequence getOriginalParamsText() {
            return this.origParamsText;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public List<CharSequence> getParametersText() {
            return this.paramText;
        }

        private void addParam(String string) {
            this.paramText.add(string);
        }

        public void setStartOffsetIfNeeded(int n) {
            if (this.startOffset < 0) {
                this.startOffset = n;
                this.endOffset = n;
            }
        }

        private boolean hasParam(int n) {
            return n < this.paramText.size();
        }

        private CharSequence getParameter(int n) {
            return this.paramText.get(n);
        }

        private boolean isValid() {
            return this.endOffset > this.startOffset;
        }

        private void setEndOffset(int n) {
            this.endOffset = n;
        }

        public String toString() {
            return this.origParamsText + "[" + this.startOffset + "-" + this.endOffset + "] params:" + this.paramText;
        }
    }
}

