/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncapsulateFieldsRefactoring
extends AbstractRefactoring {
    private Collection<EncapsulateFieldInfo> refactorFields = Collections.emptyList();
    private Set<CsmVisibility> methodModifiers = Collections.emptySet();
    private Set<CsmVisibility> fieldModifiers = Collections.emptySet();
    private CsmFile classDeclFile = null;
    private CsmFile classDefFile = null;
    private boolean alwaysUseAccessors;
    private boolean methodInline;

    public EncapsulateFieldsRefactoring(CsmObject csmObject, CsmContext csmContext) {
        super(EncapsulateFieldsRefactoring.createLookup(csmObject, csmContext));
    }

    private static Lookup createLookup(CsmObject csmObject, CsmContext csmContext) {
        assert (csmObject != null || csmContext != null) : "must be non null object to refactor";
        if (csmContext == null) {
            return Lookups.fixed((Object[])new Object[]{csmObject});
        }
        if (csmObject == null) {
            return Lookups.fixed((Object[])new Object[]{csmContext});
        }
        return Lookups.fixed((Object[])new Object[]{csmObject, csmContext});
    }

    public Collection<EncapsulateFieldInfo> getRefactorFields() {
        return this.refactorFields;
    }

    public Set<CsmVisibility> getMethodModifiers() {
        return this.methodModifiers;
    }

    public Set<CsmVisibility> getFieldModifiers() {
        return this.fieldModifiers;
    }

    public boolean isAlwaysUseAccessors() {
        return this.alwaysUseAccessors;
    }

    public boolean isMethodInline() {
        return this.methodInline;
    }

    public void setMethodInline(boolean bl) {
        this.methodInline = bl;
    }

    public void setRefactorFields(Collection<EncapsulateFieldInfo> collection) {
        this.refactorFields = Collections.unmodifiableCollection(new ArrayList<EncapsulateFieldInfo>(collection));
    }

    public void setMethodModifiers(Set<CsmVisibility> set) {
        this.methodModifiers = set;
    }

    public void setFieldModifiers(Set<CsmVisibility> set) {
        this.fieldModifiers = set;
    }

    public void setAlwaysUseAccessors(boolean bl) {
        this.alwaysUseAccessors = bl;
    }

    public CsmFile getClassDeclarationFile() {
        return this.classDeclFile;
    }

    public void setClassDeclarationFile(CsmFile csmFile) {
        this.classDeclFile = csmFile;
    }

    public CsmFile getClassDefinitionFile() {
        return this.classDefFile;
    }

    public void setClassDefinitonFile(CsmFile csmFile) {
        this.classDefFile = csmFile;
    }

    public static final class EncapsulateFieldInfo {
        final CsmField field;
        final CsmMethod defaultGetter;
        final CsmMethod defaultSetter;
        final String getterName;
        final String setterName;

        public EncapsulateFieldInfo(CsmField csmField, String string, String string2, CsmMethod csmMethod, CsmMethod csmMethod2) {
            this.field = csmField;
            this.getterName = string;
            this.setterName = string2;
            this.defaultGetter = csmMethod;
            this.defaultSetter = csmMethod2;
        }

        public String getGetterName() {
            return this.getterName;
        }

        public String getSetterName() {
            return this.setterName;
        }

        public CsmField getField() {
            return this.field;
        }

        public CsmMethod getDefaultGetter() {
            return this.defaultGetter;
        }

        public CsmMethod getDefaultSetter() {
            return this.defaultSetter;
        }
    }
}

