/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.threadmap.support.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.dataprovider.DataModelScheme;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.impl.SQLDataStorage;
import org.netbeans.modules.dlight.msa.support.MSASQLTables;
import org.netbeans.modules.dlight.spi.dataprovider.DataProviderFactory;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.threadmap.dataprovider.ThreadMapDataProviderImpl;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapDataProvider;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapDataScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadMapDataProviderFactory
implements DataProviderFactory {
    private final DataStorageType supportedStorageType;
    private final List<DataModelScheme> providedSchemas = Collections.singletonList(ThreadMapDataScheme.getScheme());
    private final List<DataTableMetadata> requiredTables;

    public ThreadMapDataProviderFactory() {
        this.supportedStorageType = SQLDataStorage.getStorageType();
        this.requiredTables = Collections.singletonList(MSASQLTables.msa.tableMetadata);
    }

    public ThreadMapDataProvider create() {
        return new ThreadMapDataProviderImpl();
    }

    public Collection<DataModelScheme> getProvidedDataModelScheme() {
        return this.providedSchemas;
    }

    public boolean provides(DataModelScheme dataModelScheme) {
        return this.providedSchemas.contains(dataModelScheme);
    }

    public boolean validate(DataStorage dataStorage) {
        if (!dataStorage.supportsType(this.supportedStorageType)) {
            return false;
        }
        for (DataTableMetadata dataTableMetadata : this.requiredTables) {
            if (dataStorage.hasData(dataTableMetadata)) continue;
            return false;
        }
        return true;
    }
}

