/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.web.jsf.editor.facelets.DefaultFaceletLibraries;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptorException;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FaceletsLibraryDescriptor
extends LibraryDescriptor {
    static FaceletsLibraryDescriptor create(FileObject fileObject) throws LibraryDescriptorException {
        return new FaceletsLibraryDescriptor(fileObject);
    }

    static FaceletsLibraryDescriptor create(InputStream inputStream) throws LibraryDescriptorException {
        return new FaceletsLibraryDescriptor(inputStream);
    }

    private FaceletsLibraryDescriptor(FileObject fileObject) throws LibraryDescriptorException {
        super(fileObject);
        this.parseLibrary();
    }

    private FaceletsLibraryDescriptor(InputStream inputStream) throws LibraryDescriptorException {
        super(inputStream);
        this.parseLibrary(inputStream);
    }

    public String getDefaultPrefix() {
        return DefaultFaceletLibraries.getLibraryDefaultPrefix(this.getURI());
    }

    public String getDisplayName() {
        return DefaultFaceletLibraries.getLibraryDisplayName(this.getURI());
    }

    public static String parseNamespace(InputStream inputStream) {
        return FaceletsLibraryDescriptor.parseNamespace(inputStream, "facelet-taglib", "namespace");
    }

    protected void parseLibrary(InputStream inputStream) throws LibraryDescriptorException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setEncoding("UTF-8");
            documentBuilder.setEntityResolver(UserCatalog.getDefault().getEntityResolver());
            Document document = documentBuilder.parse(inputSource);
            Node node = FaceletsLibraryDescriptor.getNodeByName(document, "facelet-taglib");
            this.uri = FaceletsLibraryDescriptor.getTextContent(node, "namespace");
            if (this.uri == null) {
                throw new IllegalStateException("Missing namespace entry in " + this.getDefinitionFile().getPath() + " library.", null);
            }
            NodeList nodeList = document.getElementsByTagName("tag");
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    String string = FaceletsLibraryDescriptor.getTextContent(node2, "tag-name");
                    String string2 = FaceletsLibraryDescriptor.getTextContent(node2, "description");
                    HashMap<String, LibraryDescriptor.Attribute> hashMap = new HashMap<String, LibraryDescriptor.Attribute>();
                    for (Node node3 : FaceletsLibraryDescriptor.getNodesByName(node2, "attribute")) {
                        String string3 = FaceletsLibraryDescriptor.getTextContent(node3, "name");
                        String string4 = FaceletsLibraryDescriptor.getTextContent(node3, "description");
                        boolean bl = Boolean.parseBoolean(FaceletsLibraryDescriptor.getTextContent(node3, "required"));
                        hashMap.put(string3, new LibraryDescriptor.Attribute(string3, string4, bl));
                    }
                    this.tags.put(string, new LibraryDescriptor.TagImpl(string, string2, hashMap));
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new LibraryDescriptorException("Error parsing facelets library: ", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new LibraryDescriptorException("Error parsing facelets library: ", sAXException);
        }
        catch (IOException iOException) {
            throw new LibraryDescriptorException("Error parsing facelets library: ", iOException);
        }
    }
}

