/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.rubyproject.RakeParameters;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Fixtures {
    private static final Logger LOGGER = Logger.getLogger(Fixtures.class.getName());
    private static final List<String> FIXTURE_TASKS = Arrays.asList("db:fixtures:load");

    private Fixtures() {
    }

    static boolean isFixtureTask(RakeTask rakeTask) {
        if (rakeTask == null) {
            return false;
        }
        return FIXTURE_TASKS.contains(rakeTask.getTask());
    }

    public static List<Fixture> getFixtures(Project project) {
        FileObject fileObject = project.getProjectDirectory();
        FileObject fileObject2 = fileObject.getFileObject("test/fixtures");
        if (fileObject2 == null) {
            return Collections.emptyList();
        }
        ArrayList<Fixture> arrayList = new ArrayList<Fixture>();
        for (FileObject fileObject3 : fileObject2.getChildren()) {
            String string = fileObject3.getName();
            if (!fileObject3.getMIMEType().equals("text/x-yaml") && !fileObject3.isFolder()) continue;
            arrayList.add(new Fixture(string, fileObject3.isFolder()));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Fixture
    implements RakeParameters.RakeParameter,
    Comparable<Fixture> {
        private final String name;
        private final boolean dir;

        public Fixture(String string, boolean bl) {
            this.name = string;
            this.dir = bl;
        }

        @Override
        public String toRakeParam() {
            return this.dir ? "FIXTURES_DIR=" + this.name : "FIXTURES=" + this.name;
        }

        @Override
        public int compareTo(Fixture fixture) {
            return this.toRakeParam().compareTo(fixture.toRakeParam());
        }

        public String toString() {
            return this.toRakeParam();
        }
    }
}

