/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.ui.PropertiesDialog;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConnectManager {
    private static final ConnectManager DEFAULT = new ConnectManager();
    private final PropertyChangeListener listener = new ReconnectPropertyChangeListener();
    private static final Logger LOGGER = Logger.getLogger(ConnectManager.class.getName());
    private boolean reconnecting = false;

    private ConnectManager() {
    }

    public static ConnectManager getDefault() {
        return DEFAULT;
    }

    public PropertyChangeListener getReconnectListener() {
        return this.listener;
    }

    public void reconnect(final DatabaseServer databaseServer) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        block13: {
                            if (!ConnectManager.this.reconnecting) break block13;
                            LOGGER.log(Level.FINE, "Already reconnecting to the server");
                            return;
                        }
                        ConnectManager.this.reconnecting = true;
                    }
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ConnectManager.class, (String)"MSG_ReconnectingToMySQL"));
                    databaseServer.reconnect();
                }
                catch (DatabaseException databaseException) {
                    LOGGER.log(Level.INFO, databaseException.getMessage(), databaseException);
                    boolean bl = Utils.displayYesNoDialog(NbBundle.getMessage(ConnectManager.class, (String)"MSG_ReconnectFailed", (Object)databaseException.getMessage()));
                    if (bl) {
                        Mutex.EVENT.postReadRequest(new Runnable(){

                            public void run() {
                                PropertiesDialog propertiesDialog = new PropertiesDialog(databaseServer);
                                boolean bl = propertiesDialog.displayDialog();
                                if (bl) {
                                    ConnectManager.getDefault().reconnect(databaseServer);
                                }
                            }
                        });
                    }
                }
                catch (TimeoutException timeoutException) {
                    LOGGER.log(Level.INFO, timeoutException.getMessage(), timeoutException);
                    Utils.displayErrorMessage(timeoutException.getMessage());
                }
                finally {
                    ConnectManager.this.setReconnecting(false);
                }
            }
        });
    }

    private synchronized void setReconnecting(boolean bl) {
        this.reconnecting = bl;
    }

    private class ReconnectPropertyChangeListener
    implements PropertyChangeListener {
        private ReconnectPropertyChangeListener() {
        }

        private boolean propertyChangeNeedsReconnect(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            return string.equals("adminuser") || string.equals("adminpwd") || string.equals("host") || string.equals("port");
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DatabaseServer databaseServer = (DatabaseServer)propertyChangeEvent.getSource();
            if (this.propertyChangeNeedsReconnect(propertyChangeEvent)) {
                ConnectManager.this.reconnect(databaseServer);
            }
        }
    }
}

