/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.navigator;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.modules.navigator.NavigatorController;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NavigatorTC
extends TopComponent {
    private static NavigatorTC instance;
    private NavigatorPanel selectedPanel;
    private List<NavigatorPanel> panels;
    private NavigatorController controller;
    private final JLabel notAvailLbl = new JLabel(NbBundle.getMessage(NavigatorTC.class, (String)"MSG_NotAvailable"));
    private Lookup navTCLookup;
    private JPanel contentArea;
    private JPanel holderPanel;
    private JComboBox panelSelector;

    private NavigatorTC() {
        this.initComponents();
        this.setName(NbBundle.getMessage(NavigatorTC.class, (String)"LBL_Navigator"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/navigator/resources/navigator.png"));
        this.setFocusable(true);
        this.putClientProperty("SlidingName", this.getName());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NavigatorTC.class, (String)"ACC_DESC_NavigatorTC"));
        this.notAvailLbl.setHorizontalAlignment(0);
        this.notAvailLbl.setEnabled(false);
        Color color = UIManager.getColor("window");
        this.notAvailLbl.setBackground(color != null ? color : Color.white);
        this.notAvailLbl.setOpaque(true);
        this.holderPanel.setOpaque(false);
        this.getController().installActions();
        this.setToEmpty();
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            Color color2 = UIManager.getColor("NbExplorerView.background");
            this.setBackground(color2);
            this.notAvailLbl.setBackground(color2);
            this.setOpaque(true);
            this.holderPanel.setOpaque(true);
            this.holderPanel.setBackground(color2);
            this.holderPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("NbSplitPane.background")));
        }
    }

    public static final NavigatorTC getInstance() {
        NavigatorTC navigatorTC = (NavigatorTC)WindowManager.getDefault().findTopComponent("navigatorTC");
        if (navigatorTC == null) {
            navigatorTC = NavigatorTC.privateGetInstance();
            Logger.getAnonymousLogger().warning("Could not locate the navigator component via its winsys id");
        }
        return navigatorTC;
    }

    public static final NavigatorTC privateGetInstance() {
        if (instance == null) {
            instance = new NavigatorTC();
        }
        return instance;
    }

    public void setSelectedPanel(NavigatorPanel navigatorPanel) {
        int n = this.panels.indexOf(navigatorPanel);
        assert (n != -1) : "Panel to select is not available";
        if (navigatorPanel.equals(this.selectedPanel)) {
            return;
        }
        this.selectedPanel = navigatorPanel;
        ((CardLayout)this.contentArea.getLayout()).show(this.contentArea, String.valueOf(n));
        this.panelSelector.setSelectedIndex(n);
    }

    public NavigatorPanel getSelectedPanel() {
        return this.selectedPanel;
    }

    public List<NavigatorPanel> getPanels() {
        return this.panels;
    }

    public void setPanels(List<NavigatorPanel> list, NavigatorPanel navigatorPanel) {
        this.panels = list;
        int n = list == null ? -1 : list.size();
        this.selectedPanel = null;
        if (n <= 0) {
            this.setToEmpty();
        } else {
            this.contentArea.removeAll();
            this.panelSelector.removeAllItems();
            this.holderPanel.setVisible(n != 1);
            JComponent jComponent = null;
            int n2 = 0;
            boolean bl = false;
            for (NavigatorPanel navigatorPanel2 : list) {
                this.panelSelector.addItem(navigatorPanel2.getDisplayName());
                jComponent = navigatorPanel2.getComponent();
                if (jComponent == null) {
                    NullPointerException nullPointerException = new NullPointerException("Method " + navigatorPanel2.getClass().getName() + ".getComponent() must not return null under any condition!");
                    ErrorManager.getDefault().notify(4096, (Throwable)nullPointerException);
                } else {
                    this.contentArea.add((Component)jComponent, String.valueOf(n2));
                }
                if (navigatorPanel2 == navigatorPanel) {
                    bl = true;
                }
                ++n2;
            }
            if (bl) {
                this.setSelectedPanel(navigatorPanel);
            } else {
                this.selectedPanel = list.get(0);
            }
            this.resetFromEmpty();
        }
    }

    public JComboBox getPanelSelector() {
        return this.panelSelector;
    }

    public JComponent getContentArea() {
        return this.contentArea;
    }

    public String preferredID() {
        return "navigatorTC";
    }

    public int getPersistenceType() {
        return 0;
    }

    public boolean requestFocusInWindow() {
        if (this.selectedPanel != null) {
            return this.selectedPanel.getComponent().requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public void requestFocus() {
        if (this.selectedPanel != null) {
            this.selectedPanel.getComponent().requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("navigator.java");
    }

    public void componentOpened() {
        this.getController().navigatorTCOpened();
    }

    public void componentClosed() {
        this.getController().navigatorTCClosed();
    }

    public Lookup getLookup() {
        if (this.navTCLookup == null) {
            Lookup lookup = super.getLookup();
            Lookup lookup2 = this.getController().getPanelLookup();
            this.navTCLookup = new ProxyLookup(new Lookup[]{lookup, lookup2});
        }
        return this.navTCLookup;
    }

    public UndoRedo getUndoRedo() {
        return this.getController().getUndoRedo();
    }

    public NavigatorController getController() {
        if (this.controller == null) {
            this.controller = new NavigatorController(this);
        }
        return this.controller;
    }

    private void setToEmpty() {
        if (this.notAvailLbl.isShowing()) {
            return;
        }
        this.remove(this.holderPanel);
        this.holderPanel.setVisible(false);
        this.remove(this.contentArea);
        this.add(this.notAvailLbl, "Center");
        this.revalidate();
        this.repaint();
    }

    private void resetFromEmpty() {
        if (this.contentArea.isShowing()) {
            // empty if block
        }
        this.remove(this.notAvailLbl);
        this.add(this.holderPanel, "North");
        this.add(this.contentArea, "Center");
        this.revalidate();
        this.repaint();
    }

    private void initComponents() {
        this.holderPanel = new JPanel();
        this.panelSelector = new JComboBox();
        this.contentArea = new JPanel();
        this.setLayout(new BorderLayout());
        this.holderPanel.setLayout(new BorderLayout());
        this.holderPanel.add((Component)this.panelSelector, "Center");
        this.add(this.holderPanel, "North");
        this.contentArea.setLayout(new CardLayout());
        this.add(this.contentArea, "Center");
    }
}

