/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rhtml.editor;

import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.netbeans.editor.BaseDocument;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.bracesmatching.support.BracesMatcherSupport;

public class RhtmlBracesMatcher
implements BracesMatcher {
    private final MatcherContext context;
    private final BracesMatcher delegate;

    RhtmlBracesMatcher(MatcherContext matcherContext) {
        this.context = matcherContext;
        this.delegate = BracesMatcherSupport.defaultMatcher((MatcherContext)matcherContext, (int)-1, (int)-1);
    }

    public int[] findOrigin() throws InterruptedException, BadLocationException {
        return this.delegate.findOrigin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            int n;
            int n2;
            BaseDocument baseDocument = (BaseDocument)this.context.getDocument();
            int n3 = this.context.getSearchOffset();
            char[] cArray = baseDocument.getChars(n3, 1);
            if (this.isRhtmlStartTag(baseDocument, n3, cArray)) {
                int n4 = baseDocument.getText().length();
                int n5 = RhtmlBracesMatcher.matchChar((Document)baseDocument, n3, n4, '>');
                while (n5 != -1 && baseDocument.getChars(n5 - 1, 1)[0] == '=') {
                    n5 = RhtmlBracesMatcher.matchChar((Document)baseDocument, n5 + 1, n4, '>');
                }
                int[] nArray = new int[]{n5, n5 + 1};
                return nArray;
            }
            if (this.isRhtmlEndTag(baseDocument, n3, cArray) && (n2 = RhtmlBracesMatcher.matchChar((Document)baseDocument, n3, n = 0, '<')) != -1) {
                int[] nArray = new int[]{n2, n2 + 1};
                return nArray;
            }
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
        return this.delegate.findMatches();
    }

    private boolean isRhtmlEndTag(BaseDocument baseDocument, int n, char[] cArray) throws BadLocationException {
        char[] cArray2;
        if (n == 0) {
            return false;
        }
        int n2 = baseDocument.getText().length();
        if (n2 <= 1) {
            return false;
        }
        if (cArray[0] == '%' && n2 >= n + 1 && baseDocument.getChars(n + 1, 1)[0] == '>') {
            return true;
        }
        if (cArray[0] == '>') {
            return baseDocument.getChars(n - 1, 1)[0] != '=';
        }
        if (n2 >= 3 && n - 2 > 0 && (cArray2 = baseDocument.getChars(n - 2, 3))[1] == '>') {
            return cArray2[0] == '%';
        }
        return false;
    }

    private boolean isRhtmlStartTag(BaseDocument baseDocument, int n, char[] cArray) throws BadLocationException {
        int n2 = baseDocument.getText().length();
        if (n2 < n + 1) {
            return false;
        }
        if (cArray[0] == '<' && n2 >= n + 1 && baseDocument.getChars(n + 1, 1)[0] == '%') {
            return true;
        }
        if (cArray[0] == '%' && n - 1 > 0) {
            return baseDocument.getChars(n - 1, 1)[0] == '<';
        }
        return false;
    }

    private static int matchChar(Document document, int n, int n2, char c) throws BadLocationException {
        int n3;
        boolean bl = n2 < n;
        int n4 = n3 = bl ? n - n2 : n2 - n;
        if (bl) {
            Segment segment = new Segment();
            document.getText(n - n3, n3, segment);
            for (int i = n3 - 1; i >= 0; --i) {
                if (MatcherContext.isTaskCanceled()) {
                    return -1;
                }
                if (c != segment.array[segment.offset + i]) continue;
                return n - (n3 - i);
            }
        } else {
            Segment segment = new Segment();
            document.getText(n, n3, segment);
            for (int i = 0; i < n3; ++i) {
                if (MatcherContext.isTaskCanceled()) {
                    return -1;
                }
                if (c != segment.array[segment.offset + i]) continue;
                return n + i;
            }
        }
        return -1;
    }
}

