/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rhtml;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.RubyCodeCompleter;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.rhtml.lexer.api.RhtmlTokenId;

public class RhtmlCompleter
extends RubyCodeCompleter {
    public CodeCompletionResult complete(CodeCompletionContext codeCompletionContext) {
        ParserResult parserResult = codeCompletionContext.getParserResult();
        int n = codeCompletionContext.getCaretOffset();
        BaseDocument baseDocument = RubyUtils.getDocument((Parser.Result)parserResult);
        if (baseDocument != null && RhtmlCompleter.isWithinRuby((Document)baseDocument, n)) {
            return super.complete(codeCompletionContext);
        }
        return CodeCompletionResult.NONE;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent jTextComponent, String string) {
        int n;
        Document document = jTextComponent.getDocument();
        if (RhtmlCompleter.isWithinRuby(document, n = jTextComponent.getCaret().getDot())) {
            return super.getAutoQuery(jTextComponent, string);
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    static boolean isWithinRuby(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            TokenId tokenId = tokenSequence.token().id();
            if (tokenId == RhtmlTokenId.RUBY || tokenId == RhtmlTokenId.RUBY_EXPR) {
                return true;
            }
            if (tokenId == RhtmlTokenId.DELIMITER) {
                tokenSequence.movePrevious();
                if (tokenSequence.token().id() == RhtmlTokenId.RUBY || tokenSequence.token().id() == RhtmlTokenId.RUBY_EXPR) {
                    return true;
                }
            }
        }
        return false;
    }
}

