/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.Registry;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.editor.ext.html.parser.SyntaxParserContext;
import org.netbeans.editor.ext.html.parser.SyntaxTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxParserResult {
    private static final String FALLBACK_DOCTYPE = "-//W3C//DTD HTML 4.01 Transitional//EN";
    private SyntaxParserContext context;
    private String publicID;
    private Map<String, AstNode> astRoots;
    private Map<String, String> namespaces;

    public SyntaxParserResult(SyntaxParserContext syntaxParserContext) {
        this.context = syntaxParserContext;
    }

    public CharSequence getSource() {
        return this.context.getSourceText();
    }

    public List<SyntaxElement> getElements() {
        return this.context.getElements();
    }

    public synchronized AstNode getASTRoot() {
        return this.getASTRoot(null);
    }

    public synchronized AstNode getASTRoot(String string) {
        return this.getASTRoot(string, null);
    }

    public synchronized AstNode getASTRoot(String string, DTD dTD) {
        if (string == null && dTD == null) {
            dTD = this.getFallbackDTD();
        }
        if (this.astRoots == null) {
            this.astRoots = new HashMap<String, AstNode>();
        }
        if (this.astRoots.containsKey(string)) {
            return this.astRoots.get(string);
        }
        ArrayList<SyntaxElement> arrayList = new ArrayList<SyntaxElement>();
        String string2 = this.getDeclaredNamespaces().get(string);
        for (SyntaxElement object2 : this.getElements()) {
            if (object2.type() == 4 || object2.type() == 5) {
                SyntaxElement.Tag tag = (SyntaxElement.Tag)object2;
                String string3 = this.getTagNamePrefix(tag);
                if (!(string3 == null && string2 == null || string3 != null && string2 == null && !this.getDeclaredNamespaces().containsValue(string3)) && (string3 == null || string2 == null || !string3.equals(string2))) continue;
                arrayList.add(object2);
                continue;
            }
            arrayList.add(object2);
        }
        Object object3 = null;
        if (this.getDTDNoFallback() != null) {
            object3 = dTD != null ? this.getDTDNoFallback() : null;
        } else if (dTD != null) {
            object3 = dTD;
        }
        AstNode astNode = SyntaxTree.makeTree(this.context.clone().setElements(arrayList).setDTD((DTD)object3));
        astNode.setProperty("namespace", string);
        this.astRoots.put(string, astNode);
        return astNode;
    }

    private String getTagNamePrefix(SyntaxElement.Tag tag) {
        String string = tag.getName();
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public synchronized String getPublicID() {
        if (this.publicID == null) {
            for (SyntaxElement syntaxElement : this.getElements()) {
                String string;
                if (syntaxElement.type() != 1 || (string = ((SyntaxElement.Declaration)syntaxElement).getPublicIdentifier()) == null) continue;
                this.publicID = string;
                break;
            }
        }
        return this.publicID;
    }

    public synchronized Map<String, String> getDeclaredNamespaces() {
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
            for (SyntaxElement syntaxElement : this.getElements()) {
                if (syntaxElement.type() != 4) continue;
                SyntaxElement.Tag tag = (SyntaxElement.Tag)syntaxElement;
                for (SyntaxElement.TagAttribute tagAttribute : tag.getAttributes()) {
                    String string;
                    String string2 = tagAttribute.getName();
                    if (!string2.startsWith("xmlns")) continue;
                    int n = string2.indexOf(58);
                    String string3 = string = n == -1 ? null : string2.substring(n + 1);
                    String string4 = tagAttribute.getValue();
                    if (this.namespaces.containsKey(SyntaxParserResult.dequote(string4))) continue;
                    this.namespaces.put(SyntaxParserResult.dequote(string4), string);
                }
            }
        }
        return this.namespaces;
    }

    @Deprecated
    public Map<String, URI> getGlobalNamespaces() {
        HashMap<String, URI> hashMap = new HashMap<String, URI>();
        AstNode astNode = this.getASTRoot();
        for (AstNode astNode2 : astNode.children()) {
            if (astNode2.type() != AstNode.NodeType.OPEN_TAG) continue;
            for (String string : astNode2.getAttributeKeys()) {
                if (!string.startsWith("xmlns")) continue;
                int n = string.indexOf(58);
                String string2 = n == -1 ? "" : string.substring(n + 1);
                AstNode.Attribute attribute = astNode2.getAttribute(string);
                try {
                    hashMap.put(string2, new URI(attribute.unquotedValue()));
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        return hashMap;
    }

    private DTD getDTDNoFallback() {
        if (this.getPublicID() == null) {
            if (this.context.getDTD() != null) {
                return this.context.getDTD();
            }
        } else {
            return Registry.getDTD(this.getPublicID(), null);
        }
        return null;
    }

    public DTD getDTD() {
        if (this.getPublicID() == null) {
            if (this.context.getDTD() != null) {
                return this.context.getDTD();
            }
            return this.getFallbackDTD();
        }
        DTD dTD = Registry.getDTD(this.getPublicID(), null);
        return dTD != null ? dTD : this.getFallbackDTD();
    }

    private DTD getFallbackDTD() {
        return Registry.getDTD(FALLBACK_DOCTYPE, null);
    }

    private static String dequote(String string) {
        if (string.length() < 2) {
            return string;
        }
        if (!(string.charAt(0) != '\'' && string.charAt(0) != '\"' || string.charAt(string.length() - 1) != '\'' && string.charAt(string.length() - 1) != '\"')) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }
}

