/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.runprofiles;

import org.netbeans.modules.cnd.api.xml.AttrValuePair;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.xml.sax.Attributes;

public class RunProfileXMLCodec
extends XMLDecoder
implements XMLEncoder {
    private RunProfile profile;
    private static final String PROFILE_ID = "runprofile";
    private static final String VARIABLE_ELEMENT = "variable";
    private static final String NAME_ATTR = "name";
    private static final String VALUE_ATTR = "value";
    private static final String ENVIRONMENT_ELEMENT = "environment";
    private static final String ARGS_ELEMENT = "args";
    private static final String RUNDIR_ELEMENT = "rundir";
    private static final String BUILD_FIRST_ELEMENT = "buildfirst";
    private static final String CONSOLE_TYPE_ELEMENT = "console-type";
    private static final String TERMINAL_TYPE_ELEMENT = "terminal-type";
    private static final String REMOVE_INSTRUMENTATION_ELEMENT = "remove-instrumentation";
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";
    private static final int thisversion = 6;

    public RunProfileXMLCodec(RunProfile runProfile) {
        this.profile = runProfile;
    }

    public static int getVersion() {
        return 6;
    }

    public String tag() {
        return PROFILE_ID;
    }

    public void start(Attributes attributes) throws VersionException {
        String string = "run profile";
        int n = RunProfileXMLCodec.getVersion();
        this.checkVersion(attributes, string, n);
    }

    public void end() {
        this.profile.clearChanged();
    }

    public void startElement(String string, Attributes attributes) {
        if (string.equals(VARIABLE_ELEMENT)) {
            this.profile.getEnvironment().putenv(attributes.getValue(NAME_ATTR), attributes.getValue(VALUE_ATTR));
        }
    }

    public void endElement(String string, String string2) {
        if (string.equals(ARGS_ELEMENT)) {
            this.profile.setArgsRaw(string2);
        } else if (string.equals(RUNDIR_ELEMENT)) {
            this.profile.setRunDir(string2);
        } else if (string.equals(BUILD_FIRST_ELEMENT)) {
            this.profile.setBuildFirst(string2.equals(TRUE_VALUE));
        } else {
            int n;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (string.equals(CONSOLE_TYPE_ELEMENT)) {
                this.profile.getConsoleType().setValue(n);
            } else if (string.equals(TERMINAL_TYPE_ELEMENT)) {
                this.profile.getTerminalType().setValue(n);
            } else if (string.equals(REMOVE_INSTRUMENTATION_ELEMENT)) {
                this.profile.getRemoveInstrumentation().setValue(n);
            }
        }
    }

    private static void encode(XMLEncoderStream xMLEncoderStream, String[] stringArray) {
        xMLEncoderStream.element(VARIABLE_ELEMENT, new AttrValuePair[]{new AttrValuePair(NAME_ATTR, "" + stringArray[0]), new AttrValuePair(VALUE_ATTR, "" + stringArray[1])});
    }

    private static void encode(XMLEncoderStream xMLEncoderStream, Env env) {
        String[][] stringArray = env.getenvAsPairs();
        xMLEncoderStream.elementOpen(ENVIRONMENT_ELEMENT);
        for (int i = 0; i < stringArray.length; ++i) {
            RunProfileXMLCodec.encode(xMLEncoderStream, stringArray[i]);
        }
        xMLEncoderStream.elementClose(ENVIRONMENT_ELEMENT);
    }

    private static void encode(XMLEncoderStream xMLEncoderStream, RunProfile runProfile) {
        xMLEncoderStream.elementOpen(PROFILE_ID, RunProfileXMLCodec.getVersion());
        xMLEncoderStream.element(ARGS_ELEMENT, runProfile.getArgsFlat());
        xMLEncoderStream.element(RUNDIR_ELEMENT, runProfile.getRunDir());
        xMLEncoderStream.element(BUILD_FIRST_ELEMENT, "" + runProfile.getBuildFirst());
        xMLEncoderStream.element(CONSOLE_TYPE_ELEMENT, Integer.toString(runProfile.getConsoleType().getValue()));
        xMLEncoderStream.element(TERMINAL_TYPE_ELEMENT, Integer.toString(runProfile.getTerminalType().getValue()));
        xMLEncoderStream.element(REMOVE_INSTRUMENTATION_ELEMENT, Integer.toString(runProfile.getRemoveInstrumentation().getValue()));
        RunProfileXMLCodec.encode(xMLEncoderStream, runProfile.getEnvironment());
        xMLEncoderStream.elementClose(PROFILE_ID);
    }

    public void encode(XMLEncoderStream xMLEncoderStream) {
        RunProfileXMLCodec.encode(xMLEncoderStream, this.profile);
    }
}

