/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Action;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.CodeEvaluator;
import org.netbeans.modules.debugger.jpda.ui.models.CachedChildrenTreeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class EvaluatorTreeModel
extends CachedChildrenTreeModel
implements NodeActionsProviderFilter {
    public static final String HISTORY_NODE = "org/netbeans/modules/debugger/jpda/resources/history_node_16.png";
    public static final String HISTORY_ITEM = "org/netbeans/modules/debugger/jpda/resources/eval_history_item.png";
    private final Action PASTE_TO_EVALUATOR = Models.createAction((String)NbBundle.getBundle(EvaluatorTreeModel.class).getString("CTL_PasteExprFromHistoryToEvaluator"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            CodeEvaluator.getInstance().pasteExpression(((ItemNode)objectArray[0]).item.expr);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private Collection<ModelListener> listeners = new HashSet<ModelListener>();
    EvaluatorListener evalListener = new EvaluatorListener();

    public EvaluatorTreeModel() {
        CodeEvaluator.addResultListener(this.evalListener);
    }

    public Object getRoot() {
        return "Root";
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if ("Root".equals(object)) {
            return false;
        }
        if (object instanceof SpecialNode) {
            return ((SpecialNode)object).isLeaf();
        }
        throw new UnknownTypeException((Object)object.toString());
    }

    protected Object[] computeChildren(Object object) throws UnknownTypeException {
        if (object instanceof SpecialNode) {
            return ((SpecialNode)object).getChildren(0, 0);
        }
        if (object == "Root") {
            Variable variable = CodeEvaluator.getResult();
            ArrayList<CodeEvaluator.History.Item> arrayList = CodeEvaluator.getHistory();
            int n = 0;
            if (variable != null) {
                ++n;
            }
            if (arrayList.size() > 0) {
                ++n;
            }
            Object[] objectArray = new Object[n];
            int n2 = 0;
            if (variable != null) {
                objectArray[n2++] = variable;
            }
            if (arrayList.size() > 0) {
                objectArray[n2] = new HistoryNode();
            }
            return objectArray;
        }
        throw new UnknownTypeException((Object)object.toString());
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if ("Root".equals(object)) {
            Variable variable = CodeEvaluator.getResult();
            ArrayList<CodeEvaluator.History.Item> arrayList = CodeEvaluator.getHistory();
            int n = 0;
            if (variable != null) {
                ++n;
            }
            if (arrayList.size() > 0) {
                ++n;
            }
            return n;
        }
        if (object instanceof SpecialNode) {
            return ((SpecialNode)object).getChildrenCount();
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeChanged(Object object) {
        ModelListener[] modelListenerArray;
        try {
            this.recomputeChildren();
        }
        catch (UnknownTypeException unknownTypeException) {
            return;
        }
        ModelEvent.NodeChanged nodeChanged = this.listeners;
        synchronized (nodeChanged) {
            modelListenerArray = this.listeners.toArray(new ModelListener[0]);
        }
        nodeChanged = new ModelEvent.NodeChanged((Object)this, object);
        for (int i = 0; i < modelListenerArray.length; ++i) {
            modelListenerArray[i].modelChanged((ModelEvent)nodeChanged);
        }
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (object instanceof ItemNode) {
            CodeEvaluator.getInstance().pasteExpression(((ItemNode)object).item.expr);
        } else {
            nodeActionsProvider.performDefaultAction(object);
        }
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (object instanceof ItemNode) {
            return new Action[]{this.PASTE_TO_EVALUATOR};
        }
        return nodeActionsProvider.getActions(object);
    }

    private class EvaluatorListener
    implements PropertyChangeListener {
        private EvaluatorListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EvaluatorTreeModel.this.fireNodeChanged("Root");
        }
    }

    static class ItemNode
    extends SpecialNode {
        CodeEvaluator.History.Item item;

        protected ItemNode(CodeEvaluator.History.Item item) {
            this.item = item;
        }

        Object[] getChildren(int n, int n2) {
            return new Object[0];
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ItemNode)) {
                return false;
            }
            return this.item.equals(((ItemNode)object).item);
        }

        public int hashCode() {
            int n = 5;
            n = 31 * n + (this.item != null ? this.item.hashCode() : 0);
            return n;
        }

        String getDisplayName() {
            return this.item.expr;
        }

        String getIconBase() {
            return EvaluatorTreeModel.HISTORY_ITEM;
        }

        boolean isLeaf() {
            return true;
        }

        int getChildrenCount() {
            return 0;
        }

        String getShortDescription() {
            return this.item.tooltip;
        }

        String getValueAt(String string) {
            if ("LocalsToString".equals(string)) {
                return this.item.toString;
            }
            if ("LocalsType".equals(string)) {
                return this.item.type;
            }
            if ("LocalsValue".equals(string)) {
                return this.item.value;
            }
            return "";
        }
    }

    static class HistoryNode
    extends SpecialNode {
        HistoryNode() {
        }

        Object[] getChildren(int n, int n2) {
            ArrayList<CodeEvaluator.History.Item> arrayList = CodeEvaluator.getHistory();
            Object[] objectArray = new ItemNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                CodeEvaluator.History.Item item = arrayList.get(i);
                objectArray[i] = new ItemNode(item);
            }
            return objectArray;
        }

        public boolean equals(Object object) {
            return object instanceof HistoryNode;
        }

        public int hashCode() {
            int n = 7;
            return n;
        }

        String getDisplayName() {
            return NbBundle.getBundle(EvaluatorTreeModel.class).getString("MSG_EvaluatorHistoryFilterNode");
        }

        String getIconBase() {
            return EvaluatorTreeModel.HISTORY_NODE;
        }

        boolean isLeaf() {
            return false;
        }

        int getChildrenCount() {
            return CodeEvaluator.getHistory().size();
        }

        String getShortDescription() {
            return NbBundle.getBundle(EvaluatorTreeModel.class).getString("CTL_EvaluatorHistoryNode");
        }

        String getValueAt(String string) {
            return "";
        }
    }

    static abstract class SpecialNode {
        SpecialNode() {
        }

        abstract Object[] getChildren(int var1, int var2);

        abstract int getChildrenCount();

        abstract String getDisplayName();

        abstract String getValueAt(String var1);

        abstract String getShortDescription();

        abstract String getIconBase();

        abstract boolean isLeaf();
    }
}

