/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.util.Map;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;

public abstract class SyntaxElement {
    private JspSyntaxSupport support;
    private SyntaxElement previous;
    private SyntaxElement next;
    int offset;
    int length;

    public SyntaxElement(JspSyntaxSupport jspSyntaxSupport, int n, int n2) {
        this.support = jspSyntaxSupport;
        this.offset = n;
        this.length = n2 - n;
    }

    public abstract int getCompletionContext();

    public int getElementOffset() {
        return this.offset;
    }

    public int getElementLength() {
        return this.length;
    }

    public SyntaxElement getPrevious() throws BadLocationException {
        if (this.previous == null) {
            this.previous = this.support.getPreviousElement(this.offset);
            if (this.previous != null) {
                this.previous.next = this;
            }
        }
        return this.previous;
    }

    public SyntaxElement getNext() throws BadLocationException {
        if (this.next == null) {
            this.next = this.support.getNextElement(this.offset + this.length);
            if (this.next != null) {
                this.next.previous = this;
            }
        }
        return this.next;
    }

    public String getImage() throws BadLocationException {
        return this.support.getDocument().getText(this.offset, this.length);
    }

    public String toString() {
        String string = "???";
        try {
            string = this.support.getDocument().getText(this.getElementOffset(), this.getElementLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return "Element [" + this.offset + "," + (this.offset + this.length - 1) + "] (" + string + ")";
    }

    public static class Directive
    extends TagDirective {
        public Directive(JspSyntaxSupport jspSyntaxSupport, int n, int n2, String string, Map map) {
            super(jspSyntaxSupport, n, n2, string, map);
        }

        public int getCompletionContext() {
            return 3;
        }

        public String toString() {
            return "JSP Directive " + super.toString();
        }
    }

    public static class Tag
    extends TagDirective {
        private boolean isClosed;

        public Tag(JspSyntaxSupport jspSyntaxSupport, int n, int n2, String string, Map map, boolean bl) {
            super(jspSyntaxSupport, n, n2, string, map);
            this.isClosed = bl;
        }

        public Tag(JspSyntaxSupport jspSyntaxSupport, int n, int n2, String string, Map map) {
            this(jspSyntaxSupport, n, n2, string, map, false);
        }

        public int getCompletionContext() {
            return 1;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public String toString() {
            return "JSP Tag " + super.toString();
        }
    }

    public static abstract class TagDirective
    extends TagLikeElement {
        Map attribs;

        public TagDirective(JspSyntaxSupport jspSyntaxSupport, int n, int n2, String string, Map map) {
            super(jspSyntaxSupport, n, n2, string);
            this.attribs = map;
        }

        public Map getAttributes() {
            return this.attribs;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString() + " - {");
            for (Object k : this.attribs.keySet()) {
                stringBuffer.append(k).append("='").append(this.attribs.get(k)).append("', ");
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    public static class EndTag
    extends TagLikeElement {
        public EndTag(JspSyntaxSupport jspSyntaxSupport, int n, int n2, String string) {
            super(jspSyntaxSupport, n, n2, string);
        }

        public int getCompletionContext() {
            return 2;
        }

        public String toString() {
            return "JSP EndTag " + super.toString();
        }
    }

    public static abstract class TagLikeElement
    extends SyntaxElement {
        String name;

        public TagLikeElement(JspSyntaxSupport jspSyntaxSupport, int n, int n2, String string) {
            super(jspSyntaxSupport, n, n2);
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return super.toString() + " - '" + this.name + "'";
        }
    }

    public static class Error
    extends SyntaxElement {
        public Error(JspSyntaxSupport jspSyntaxSupport, int n, int n2) {
            super(jspSyntaxSupport, n, n2);
        }

        public int getCompletionContext() {
            return 8;
        }

        public String toString() {
            return "JSP Error " + super.toString();
        }
    }

    public static class ScriptingL
    extends SyntaxElement {
        public ScriptingL(JspSyntaxSupport jspSyntaxSupport, int n, int n2) {
            super(jspSyntaxSupport, n, n2);
        }

        public int getCompletionContext() {
            return 7;
        }

        public String toString() {
            return "JSP Scripting Language " + super.toString();
        }
    }

    public static class ContentL
    extends SyntaxElement {
        public ContentL(JspSyntaxSupport jspSyntaxSupport, int n, int n2) {
            super(jspSyntaxSupport, n, n2);
        }

        public int getCompletionContext() {
            return 6;
        }

        public String toString() {
            return "JSP Content Language " + super.toString();
        }
    }

    public static class Text
    extends SyntaxElement {
        public Text(JspSyntaxSupport jspSyntaxSupport, int n, int n2) {
            super(jspSyntaxSupport, n, n2);
        }

        public int getCompletionContext() {
            return 5;
        }

        public String toString() {
            return "JSP Text " + super.toString();
        }
    }

    public static class ExpressionLanguage
    extends SyntaxElement {
        public ExpressionLanguage(JspSyntaxSupport jspSyntaxSupport, int n, int n2) {
            super(jspSyntaxSupport, n, n2);
        }

        public int getCompletionContext() {
            return 9;
        }

        public String toString() {
            return "Expression Language " + super.toString();
        }
    }

    public static class Comment
    extends SyntaxElement {
        public Comment(JspSyntaxSupport jspSyntaxSupport, int n, int n2) {
            super(jspSyntaxSupport, n, n2);
        }

        public int getCompletionContext() {
            return 4;
        }

        public String toString() {
            return "JSP Comment " + super.toString();
        }
    }
}

