/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceCategoriesPresenter;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceCategoryDescriptor;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceItemPresenter;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceOrderingController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePanelSupport {
    static Map<ScreenResourceCategoryDescriptor, ArrayList<ScreenResourceItemPresenter>> getCategoryDescriptors(DesignComponent designComponent) {
        if (designComponent == null) {
            return Collections.emptyMap();
        }
        Collection collection = designComponent.getPresenters(ScreenResourceCategoriesPresenter.class);
        HashMap<ScreenResourceCategoryDescriptor, ArrayList<ScreenResourceItemPresenter>> hashMap = new HashMap<ScreenResourceCategoryDescriptor, ArrayList<ScreenResourceItemPresenter>>();
        for (ScreenResourceCategoriesPresenter screenResourceCategoriesPresenter : collection) {
            Collection<ScreenResourceCategoryDescriptor> collection2 = screenResourceCategoriesPresenter.getCategoryDescriptors();
            if (collection2 == null) continue;
            for (ScreenResourceCategoryDescriptor screenResourceCategoryDescriptor : collection2) {
                hashMap.put(screenResourceCategoryDescriptor, new ArrayList());
            }
        }
        return hashMap;
    }

    static void resolveResources(DesignDocument designDocument, DesignComponent designComponent, Map<ScreenResourceCategoryDescriptor, ArrayList<ScreenResourceItemPresenter>> map) {
        if (designComponent == null) {
            return;
        }
        Collection collection = DocumentSupport.gatherAllPresentersOfClass((DesignDocument)designDocument, ScreenResourceItemPresenter.class);
        for (ScreenResourceItemPresenter object : collection) {
            ScreenResourceOrderingController[] screenResourceOrderingControllerArray;
            ArrayList<ScreenResourceItemPresenter> arrayList;
            if (!object.isActiveFor(designComponent) || (arrayList = map.get(screenResourceOrderingControllerArray = object.getCategoryDescriptor())) == null) continue;
            arrayList.add(object);
        }
        for (ScreenResourceCategoryDescriptor screenResourceCategoryDescriptor : map.keySet()) {
            for (ScreenResourceOrderingController screenResourceOrderingController : screenResourceCategoryDescriptor.getOrderingControllers()) {
                List<ScreenResourceItemPresenter> list = screenResourceOrderingController.getOrdered(designComponent, (Collection<ScreenResourceItemPresenter>)map.get(screenResourceCategoryDescriptor));
                if (list == null) continue;
                map.get(screenResourceCategoryDescriptor).removeAll(list);
                map.get(screenResourceCategoryDescriptor).addAll(list);
            }
        }
    }

    public static List<ScreenResourceCategoryDescriptor> getSortedCategories(Set<ScreenResourceCategoryDescriptor> set) {
        ArrayList<ScreenResourceCategoryDescriptor> arrayList = new ArrayList<ScreenResourceCategoryDescriptor>(set);
        Collections.sort(arrayList, new Comparator<ScreenResourceCategoryDescriptor>(){

            @Override
            public int compare(ScreenResourceCategoryDescriptor screenResourceCategoryDescriptor, ScreenResourceCategoryDescriptor screenResourceCategoryDescriptor2) {
                return screenResourceCategoryDescriptor.getOrder() - screenResourceCategoryDescriptor2.getOrder();
            }
        });
        return arrayList;
    }
}

