/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.CompositeNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.Transformable;

public abstract class Viewport
extends CompositeNode
implements Transformable {
    public static final int DEFAULT_VIEWPORT_WIDTH = 100;
    public static final int DEFAULT_VIEWPORT_HEIGHT = 100;
    public static final int ZOOM_PAN_MAGNIFY = 0;
    public static final int ZOOM_PAN_DISABLE = 1;
    public static final int ZOOM_PAN_UNKNOWN = 2;
    protected int width = 100;
    protected int height = 100;
    protected Transform transform = new Transform(null);
    protected Transform inverseTxf = new Transform(null);
    protected int zoomAndPan = 0;

    public ModelNode nodeHitAt(float[] pt) {
        return this.nodeHitAt(this.getLastChildNode(), pt);
    }

    public int getZoomAndPan() {
        return this.zoomAndPan;
    }

    public void setZoomAndPan(int newZoomAndPan) {
        if (newZoomAndPan != 0 && newZoomAndPan != 1 && newZoomAndPan != 2) {
            throw new IllegalArgumentException();
        }
        if (newZoomAndPan == this.zoomAndPan) {
            return;
        }
        this.modifyingNode();
        this.zoomAndPan = newZoomAndPan;
        this.modifiedNode();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setSize(int newWidth, int newHeight) {
        if (newWidth < 0 || newHeight < 0) {
            throw new IllegalArgumentException();
        }
        if (newWidth == this.width && newHeight == this.height) {
            return;
        }
        this.modifyingNode();
        this.width = newWidth;
        this.height = newHeight;
        this.recomputeTransformState(null);
        this.computeCanRenderWidthBit(this.width);
        this.computeCanRenderHeightBit(this.height);
        this.modifiedNode();
    }

    public Transform getTransformState() {
        return this.transform;
    }

    public Transform getInverseTransformState() {
        if ((this.canRenderState & 0x10) == 0) {
            if (this.inverseTxf == null) {
                this.inverseTxf = new Transform(null);
                try {
                    this.inverseTxf = (Transform)this.transform.inverse(this.inverseTxf);
                }
                catch (Exception e) {
                    throw new Error();
                }
            }
        } else {
            this.inverseTxf = null;
        }
        return this.inverseTxf;
    }

    protected void recomputeTransformState(Transform parentTransform) {
        if (parentTransform != null) {
            throw new IllegalArgumentException();
        }
        this.computeCanRenderTransformBit(this.transform);
        this.inverseTxf = null;
        this.recomputeTransformState(this.transform, this.getFirstChildNode());
    }

    public void setTransform(Transform newTransform) {
        if (ElementNode.equal(newTransform, this.transform)) {
            return;
        }
        this.modifyingNode();
        this.transform = newTransform;
        this.recomputeTransformState(null);
        this.modifiedNode();
    }

    public Transform getTransform() {
        return this.transform;
    }

    protected Transform appendTransform(Transform tx, Transform workTx) {
        if (this.transform == null) {
            return tx;
        }
        tx = this.recycleTransform(tx, workTx);
        tx.mMultiply(this.transform);
        return tx;
    }
}

