/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.GraphicsProperties;
import com.sun.perseus.j2d.PaintTarget;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.AbstractRenderingNodeProxy;
import com.sun.perseus.model.CompositeGraphicsNode;
import com.sun.perseus.model.CompositeGraphicsNodeProxy;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNodeProxy;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.MotionTraitAnim;
import com.sun.perseus.model.TraitAnim;
import com.sun.perseus.model.TransformTraitAnim;
import com.sun.perseus.model.Transformable;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRect;

public abstract class AbstractRenderingNode
extends CompositeGraphicsNode
implements Transformable {
    protected Transform transform;
    protected Transform motion;

    public AbstractRenderingNode(DocumentNode ownerDocument) {
        super(ownerDocument);
    }

    protected void clearLayouts() {
    }

    ElementNodeProxy buildProxy() {
        return new AbstractRenderingNodeProxy(this);
    }

    public ModelNode nodeHitAt(float[] pt) {
        if (this.canRenderState != 0 || !this.isHitVP(pt)) {
            return null;
        }
        return this;
    }

    abstract boolean isHitVP(float[] var1);

    abstract boolean isProxyHitVP(float[] var1, AbstractRenderingNodeProxy var2);

    ModelNode proxyNodeHitAt(float[] pt, ElementNodeProxy proxy) {
        if (this.canRenderState != 0 || !this.isProxyHitVP(pt, (AbstractRenderingNodeProxy)proxy)) {
            return null;
        }
        return proxy;
    }

    void setComputedDisplay(boolean newDisplay) {
        super.setComputedDisplay(newDisplay);
    }

    void setComputedVisibility(boolean newVisibility) {
        super.setComputedVisibility(newVisibility);
    }

    public void paint(RenderGraphics rg) {
        if (this.canRenderState != 0) {
            return;
        }
        this.paintRendered(rg, this, this, this.txf);
    }

    Box addBBox(Box bbox, Transform t) {
        return this.addNodeBBox(bbox, t);
    }

    public SVGRect getBBox() {
        return this.addNodeBBox(null, null);
    }

    public SVGRect getScreenBBox() {
        if (!this.inDocumentTree()) {
            return null;
        }
        return this.addNodeBBox(null, this.txf);
    }

    abstract void paintRendered(RenderGraphics var1, GraphicsProperties var2, PaintTarget var3, Transform var4);

    public int getNumberOfProperties() {
        return 15;
    }

    protected void propagatePropertyState(int propertyIndex, Object parentPropertyValue) {
        if (this.firstProxy != null) {
            ElementNodeProxy proxy = this.firstProxy;
            while (proxy != null) {
                ((CompositeGraphicsNodeProxy)proxy).proxiedPropertyStateChange(propertyIndex, parentPropertyValue);
                proxy = proxy.nextProxy;
            }
        }
    }

    protected void propagateFloatPropertyState(int propertyIndex, float parentPropertyValue) {
        if (this.firstProxy != null) {
            ElementNodeProxy proxy = this.firstProxy;
            while (proxy != null) {
                ((CompositeGraphicsNodeProxy)proxy).proxiedFloatPropertyStateChange(propertyIndex, parentPropertyValue);
                proxy = proxy.nextProxy;
            }
        }
    }

    protected void propagatePackedPropertyState(int propertyIndex, int parentPropertyValue) {
        if (this.firstProxy != null) {
            ElementNodeProxy proxy = this.firstProxy;
            while (proxy != null) {
                ((CompositeGraphicsNodeProxy)proxy).proxiedPackedPropertyStateChange(propertyIndex, parentPropertyValue);
                proxy = proxy.nextProxy;
            }
        }
    }

    protected void recomputeTransformState(Transform parentTransform) {
        this.txf = this.appendTransform(parentTransform, this.txf);
        this.inverseTxf = null;
        this.computeCanRenderTransformBit(this.txf);
    }

    public void setTransform(Transform newTransform) {
        if (AbstractRenderingNode.equal(this.transform, newTransform)) {
            return;
        }
        this.modifyingNode();
        this.transform = newTransform;
        this.recomputeTransformState();
        this.recomputeProxyTransformState();
        this.modifiedNode();
    }

    public void setMotion(Transform newMotion) {
        if (AbstractRenderingNode.equal(newMotion, this.motion)) {
            return;
        }
        this.modifyingNode();
        this.motion = newMotion;
        this.recomputeTransformState();
        this.recomputeProxyTransformState();
        this.modifiedNode();
    }

    public Transform getTransform() {
        return this.transform;
    }

    public Transform getMotion() {
        return this.motion;
    }

    void nodeHookedInDocumentTree() {
        super.nodeHookedInDocumentTree();
    }

    void nodeUnhookedFromDocumentTree() {
        super.nodeUnhookedFromDocumentTree();
    }

    protected Transform appendTransform(Transform tx, Transform workTx) {
        if (this.transform == null && this.motion == null) {
            return tx;
        }
        tx = this.recycleTransform(tx, workTx);
        if (this.motion != null) {
            tx.mMultiply(this.motion);
        }
        if (this.transform != null) {
            tx.mMultiply(this.transform);
        }
        return tx;
    }

    public boolean hasNodeRendering() {
        return true;
    }

    protected void nodeRendered() {
    }

    boolean supportsTrait(String traitName) {
        if ("transform" == traitName || "#motion" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("transform" == name) {
            return AbstractRenderingNode.toStringTrait(this.transform);
        }
        if ("#motion" == name) {
            return AbstractRenderingNode.toStringTrait(this.motion);
        }
        return super.getTraitImpl(name);
    }

    SVGMatrix getMatrixTraitImpl(String name) throws DOMException {
        if ("transform".equals(name)) {
            return this.toSVGMatrixTrait(this.transform);
        }
        if ("#motion".equals(name)) {
            return this.toSVGMatrixTrait(this.motion);
        }
        return super.getMatrixTraitImpl(name);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("transform" == traitName) {
            return new TransformTraitAnim(this, traitName);
        }
        if ("#motion" == traitName) {
            return new MotionTraitAnim(this, traitName);
        }
        return super.createTraitAnimImpl(traitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("transform" == name) {
            if (this.transform == null) {
                this.modifyingNode();
                this.transform = new Transform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else if (!this.transform.equals(value)) {
                this.modifyingNode();
                this.transform.setTransform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else {
                return;
            }
            this.recomputeTransformState();
            this.recomputeProxyTransformState();
            this.modifiedNode();
        } else if ("#motion" == name) {
            if (this.motion == null) {
                this.modifyingNode();
                this.motion = new Transform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else if (!this.motion.equals(value)) {
                this.modifyingNode();
                this.motion.setTransform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else {
                return;
            }
            this.recomputeTransformState();
            this.recomputeProxyTransformState();
            this.modifiedNode();
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("transform" == traitName || "#motion" == traitName) {
            Transform txf = this.parseTransformTrait(traitName, value);
            return new float[][]{{txf.getComponent(0)}, {txf.getComponent(1)}, {txf.getComponent(2)}, {txf.getComponent(3)}, {txf.getComponent(4)}, {txf.getComponent(5)}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("transform" == name) {
            this.setTransform(this.parseTransformTrait(name, value));
        } else if ("#motion" == name) {
            this.setMotion(this.parseTransformTrait(name, value));
        } else {
            super.setTraitImpl(name, value);
        }
    }

    void setMatrixTraitImpl(String name, Transform matrix) throws DOMException {
        if ("transform".equals(name)) {
            this.setTransform(matrix);
        } else if ("#motion" == name) {
            this.setMotion(matrix);
        } else {
            super.setMatrixTraitImpl(name, matrix);
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("transform" == name) {
            Transform transform = new Transform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            return AbstractRenderingNode.toStringTrait(transform);
        }
        return super.toStringTrait(name, value);
    }
}

