/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.codetemplates;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateInsertRequest;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.editor.completion.GsfCompletionProvider;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.Exceptions;

public class GsfCodeTemplateProcessor
implements CodeTemplateProcessor {
    private CodeTemplateInsertRequest request;
    private ParserResult cInfo = null;
    private Snapshot snapshot = null;

    private GsfCodeTemplateProcessor(CodeTemplateInsertRequest codeTemplateInsertRequest) {
        this.request = codeTemplateInsertRequest;
    }

    public synchronized void updateDefaultValues() {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (CodeTemplateParameter codeTemplateParameter : this.request.getMasterParameters()) {
                CodeTemplateParameter codeTemplateParameter2 = codeTemplateParameter;
                String string = this.getProposedValue(codeTemplateParameter2);
                if (string == null || string.equals(codeTemplateParameter2.getValue())) continue;
                codeTemplateParameter2.setValue(string);
                bl = true;
            }
        }
    }

    public void parameterValueChanged(CodeTemplateParameter codeTemplateParameter, boolean bl) {
        if (bl) {
            for (CodeTemplateParameter codeTemplateParameter2 : this.request.getMasterParameters()) {
                String string;
                CodeTemplateParameter codeTemplateParameter3 = codeTemplateParameter2;
                if (codeTemplateParameter3.isUserModified() || (string = this.getProposedValue(codeTemplateParameter3)) == null || string.equals(codeTemplateParameter3.getValue())) continue;
                codeTemplateParameter3.setValue(string);
            }
        }
    }

    public void release() {
    }

    private String getProposedValue(CodeTemplateParameter codeTemplateParameter) {
        String string = codeTemplateParameter.getName();
        JTextComponent jTextComponent = this.request.getComponent();
        int n = jTextComponent.getCaret().getDot();
        String string2 = this.delegatedResolve(n, codeTemplateParameter.getName(), string, codeTemplateParameter.getHints());
        return string2;
    }

    private String delegatedResolve(int n, String string, String string2, Map map) {
        try {
            if (this.initParsing()) {
                CodeCompletionHandler codeCompletionHandler = GsfCompletionProvider.getCompletable(this.snapshot.getSource().getDocument(true), n);
                if (codeCompletionHandler == null) {
                    return null;
                }
                return codeCompletionHandler.resolveTemplateVariable(string2, this.cInfo, n, string, map);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean initParsing() {
        if (this.cInfo == null) {
            BaseDocument baseDocument;
            final JTextComponent jTextComponent = this.request.getComponent();
            Source source = Source.create((Document)jTextComponent.getDocument());
            if (jTextComponent.getDocument() instanceof BaseDocument && (baseDocument = (BaseDocument)jTextComponent.getDocument()).isAtomicLock()) {
                return false;
            }
            if (source != null) {
                try {
                    ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws IOException, ParseException {
                            Parser.Result result = resultIterator.getParserResult(jTextComponent.getCaretPosition());
                            if (!(result instanceof ParserResult)) {
                                return;
                            }
                            GsfCodeTemplateProcessor.this.cInfo = (ParserResult)result;
                            GsfCodeTemplateProcessor.this.snapshot = result.getSnapshot();
                        }
                    });
                }
                catch (ParseException parseException) {
                    Exceptions.printStackTrace((Throwable)parseException);
                }
            }
        }
        return this.cInfo != null;
    }

    public static final class Factory
    implements CodeTemplateProcessorFactory {
        public CodeTemplateProcessor createProcessor(CodeTemplateInsertRequest codeTemplateInsertRequest) {
            return new GsfCodeTemplateProcessor(codeTemplateInsertRequest);
        }
    }
}

