/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.DefsNode;
import org.jrubyparser.ast.GlobalVarNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.NewlineNode;
import org.jrubyparser.ast.Node;
import org.openide.util.Enumerations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AstNodeAdapter
implements TreeNode {
    private static final boolean HIDE_NEWLINE_NODES = false;
    private final Node node;
    private final AstNodeAdapter parent;
    private AstNodeAdapter[] children;

    AstNodeAdapter(AstNodeAdapter astNodeAdapter, Node node) {
        this.parent = astNodeAdapter;
        this.node = node;
    }

    private void ensureChildrenInitialized() {
        if (this.children != null) {
            return;
        }
        List list = this.node.childNodes();
        this.children = new AstNodeAdapter[list.size()];
        int n = 0;
        for (Node node : list) {
            this.children[n++] = new AstNodeAdapter(this, node);
        }
    }

    private void addChildren(List<AstNodeAdapter> list, Node node) {
        List list2 = node.childNodes();
        for (Node node2 : list2) {
            if (node2 instanceof NewlineNode) {
                this.addChildren(list, node2);
                continue;
            }
            list.add(new AstNodeAdapter(this, node2));
        }
    }

    @Override
    public TreeNode getChildAt(int n) {
        this.ensureChildrenInitialized();
        return this.children[n];
    }

    @Override
    public int getChildCount() {
        this.ensureChildrenInitialized();
        return this.children.length;
    }

    @Override
    public TreeNode getParent() {
        this.ensureChildrenInitialized();
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        this.ensureChildrenInitialized();
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != treeNode) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        this.ensureChildrenInitialized();
        return this.children.length > 0;
    }

    @Override
    public boolean isLeaf() {
        this.ensureChildrenInitialized();
        return this.children.length == 0;
    }

    public Enumeration children() {
        this.ensureChildrenInitialized();
        return Enumerations.array((Object[])this.children);
    }

    public String toString() {
        if (this.node.getPosition() == SourcePosition.INVALID_POSITION) {
            return "INVALID_POSITION";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(this.node.toString());
        stringBuilder.append("<i>");
        stringBuilder.append(" (");
        if (this.node.isInvisible()) {
            stringBuilder.append("INVISIBLE");
        } else {
            stringBuilder.append(this.getStartOffset());
            stringBuilder.append("-");
            stringBuilder.append(this.getEndOffset());
        }
        stringBuilder.append(") ");
        stringBuilder.append("</i>");
        String string = null;
        if (this.node instanceof INameNode) {
            string = ((INameNode)this.node).getName();
        } else if (this.node instanceof DefnNode) {
            string = ((DefnNode)this.node).getName();
        } else if (this.node instanceof DefsNode) {
            string = ((DefsNode)this.node).getName();
        } else if (this.node instanceof ConstDeclNode) {
            string = ((ConstDeclNode)this.node).getName();
        } else if (this.node instanceof GlobalVarNode) {
            string = ((GlobalVarNode)this.node).getName();
        } else if (this.node instanceof ClassNode) {
            Colon3Node colon3Node = ((ClassNode)this.node).getCPath();
            if (colon3Node instanceof Colon2Node) {
                Colon2Node colon2Node = (Colon2Node)colon3Node;
                string = colon2Node.getName();
            } else {
                string = colon3Node.toString();
            }
        } else if (this.node instanceof ModuleNode) {
            Colon3Node colon3Node = ((ModuleNode)this.node).getCPath();
            if (colon3Node instanceof Colon2Node) {
                Colon2Node colon2Node = (Colon2Node)colon3Node;
                string = colon2Node.getName();
            } else {
                string = colon3Node.toString();
            }
        }
        if (string != null) {
            stringBuilder.append(" : <b>");
            stringBuilder.append(string);
            stringBuilder.append("</b>");
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public int getStartOffset() {
        if (this.node.isInvisible()) {
            return -1;
        }
        if (this.node.getPosition() == SourcePosition.INVALID_POSITION) {
            return -1;
        }
        if (this.node.getPosition() != null) {
            return this.node.getPosition().getStartOffset();
        }
        return -1;
    }

    public int getEndOffset() {
        if (this.node.isInvisible()) {
            return -1;
        }
        if (this.node.getPosition() == SourcePosition.INVALID_POSITION) {
            return -1;
        }
        if (this.node.getPosition() != null) {
            return this.node.getPosition().getEndOffset();
        }
        return -1;
    }

    public Object getAstNode() {
        return this.node;
    }
}

