/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.palette;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public final class ImportPaletteFolderPanel
extends JPanel {
    private static String s_lastSelection = "";
    private File m_folder = null;
    private String m_lastValue = "";
    private ButtonGroup buttonGroup1;
    private JTextField displayNameTextField;
    private JTextField folderTextField;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public ImportPaletteFolderPanel() {
        this.initComponents();
        this.folderTextField.setText(s_lastSelection);
    }

    public File getFolder() {
        return new File(this.folderTextField.getText());
    }

    public String getDisplayName() {
        String string = this.displayNameTextField.getText();
        return string.length() > 0 ? string : this.folderTextField.getText();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.displayNameTextField = new JTextField();
        this.folderTextField = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel1.setText("Display name:");
        this.jLabel1.setToolTipText("Display name of the new palette category");
        this.jLabel2.setText("Folder:");
        this.jLabel2.setToolTipText("Folder containing SVG images to import");
        this.jButton1.setText("Browse ...");
        this.jButton1.setToolTipText("Locate the folder");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportPaletteFolderPanel.this.browseFolder(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel2).add(45, 45, 45).add((Component)this.folderTextField, -1, 350, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.displayNameTextField, -1, 350, Short.MAX_VALUE))).addPreferredGap(0).add((Component)this.jButton1).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jButton1).add((Component)this.folderTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.displayNameTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browseFolder(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.folderTextField.getText());
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(ImportPaletteFolderPanel.class, (String)"LBL_Select"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!file.isDirectory()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ImportPaletteFolderPanel.class, (String)"ERROR_NotDirectory", (Object)file), 2));
                return;
            }
            this.m_folder = file;
            String string = this.m_folder.getAbsoluteFile().toString();
            this.folderTextField.setText(string);
            if (this.m_lastValue.equals(this.displayNameTextField.getText())) {
                this.displayNameTextField.setText(string);
            }
            s_lastSelection = this.m_lastValue = string;
        }
    }
}

