/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.net.URL;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.impl.indexing.Pair;
import org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater;
import org.openide.filesystems.FileEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileEventLog
implements Runnable {
    private static final Logger LOG = Logger.getLogger(FileEventLog.class.getName());
    private final ThreadLocal<Map<URL, Map<String, Pair<FileOp, RepositoryUpdater.Work>>>> changes = new ThreadLocal();

    public void record(FileOp fileOp, URL uRL, String string, FileEvent fileEvent, RepositoryUpdater.Work work) {
        Map<URL, Map<String, Pair<FileOp, RepositoryUpdater.Work>>> map;
        Map<String, Pair<FileOp, RepositoryUpdater.Work>> map2;
        assert (fileOp != null);
        assert (uRL != null);
        if (string == null) {
            string = "";
        }
        if ((map2 = (map = this.getChanges(true)).get(uRL)) == null) {
            map2 = new HashMap<String, Pair<FileOp, RepositoryUpdater.Work>>();
            map.put(uRL, map2);
        }
        map2.put(string, Pair.of(fileOp, work));
        fileEvent.runWhenDeliveryOver((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.commit();
        }
        finally {
            this.cleanUp();
        }
    }

    private Map<URL, Map<String, Pair<FileOp, RepositoryUpdater.Work>>> getChanges(boolean bl) {
        Map<URL, Map<String, Pair<FileOp, RepositoryUpdater.Work>>> map = this.changes.get();
        if (map == null && bl) {
            map = new HashMap<URL, Map<String, Pair<FileOp, RepositoryUpdater.Work>>>();
            this.changes.set(map);
        }
        return map;
    }

    private void commit() {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        IdentityHashMap identityHashMap = new IdentityHashMap();
        Map<URL, Map<String, Pair<FileOp, RepositoryUpdater.Work>>> map = this.getChanges(false);
        if (map != null) {
            for (Map map2 : map.values()) {
                for (Pair pair : map2.values()) {
                    if (pair.first == FileOp.DELETE) {
                        if (identityHashMap.containsKey(pair.second)) continue;
                        linkedList.add(pair.second);
                        identityHashMap.put(pair.second, pair.second);
                        continue;
                    }
                    linkedList2.add(pair.second);
                }
            }
        }
        RepositoryUpdater repositoryUpdater = RepositoryUpdater.getDefault();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("SCHEDULING: " + linkedList);
        }
        repositoryUpdater.scheduleWork(linkedList);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("SCHEDULING: " + linkedList2);
        }
        repositoryUpdater.scheduleWork(linkedList2);
    }

    private void cleanUp() {
        this.changes.remove();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileOp {
        DELETE,
        CREATE;

    }
}

