/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.modules.parsing.impl.indexing.CancelRequest;
import org.netbeans.modules.parsing.impl.indexing.DeletedIndexable;
import org.netbeans.modules.parsing.impl.indexing.IndexableImpl;
import org.netbeans.modules.parsing.impl.indexing.TimeStamps;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Crawler {
    private final URL root;
    private final boolean checkTimeStamps;
    private final TimeStamps timeStamps;
    private final CancelRequest cancelRequest;
    private Collection<IndexableImpl> resources;
    private Collection<IndexableImpl> allResources;
    private Collection<IndexableImpl> deleted;
    private boolean finished;

    protected Crawler(URL uRL, boolean bl, boolean bl2, CancelRequest cancelRequest) throws IOException {
        this.root = uRL;
        this.checkTimeStamps = bl;
        this.timeStamps = TimeStamps.forRoot(uRL, bl2);
        this.cancelRequest = cancelRequest;
    }

    public final Collection<IndexableImpl> getResources() throws IOException {
        this.init();
        return this.checkTimeStamps ? this.resources : this.allResources;
    }

    public final Collection<IndexableImpl> getAllResources() throws IOException {
        this.init();
        return this.allResources;
    }

    public final Collection<IndexableImpl> getDeletedResources() throws IOException {
        this.init();
        return this.deleted;
    }

    public final void storeTimestamps() throws IOException {
        this.init();
        this.timeStamps.store();
    }

    public final boolean isFinished() throws IOException {
        this.init();
        return this.finished;
    }

    protected final boolean isUpToDate(FileObject fileObject, String string) {
        boolean bl = this.timeStamps.checkAndStoreTimestamp(fileObject, string);
        return this.checkTimeStamps ? bl : false;
    }

    protected final boolean isCancelled() {
        return this.cancelRequest.isRaised();
    }

    protected abstract boolean collectResources(Collection<IndexableImpl> var1, Collection<IndexableImpl> var2);

    private void init() throws IOException {
        if (this.resources == null) {
            LinkedHashSet<IndexableImpl> linkedHashSet = this.checkTimeStamps ? new LinkedHashSet<IndexableImpl>() : null;
            LinkedHashSet<IndexableImpl> linkedHashSet2 = new LinkedHashSet<IndexableImpl>();
            this.finished = this.collectResources(linkedHashSet, linkedHashSet2);
            this.resources = this.checkTimeStamps ? Collections.unmodifiableCollection(linkedHashSet) : null;
            this.allResources = Collections.unmodifiableCollection(linkedHashSet2);
            Set<String> set = this.timeStamps.getUnseenFiles();
            if (set != null) {
                this.deleted = new ArrayList<IndexableImpl>(set.size());
                for (String string : set) {
                    this.deleted.add(new DeletedIndexable(this.root, string));
                }
                this.deleted = Collections.unmodifiableCollection(this.deleted);
            } else {
                this.deleted = Collections.emptySet();
            }
        }
    }
}

